"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const AWS = require("aws-sdk");
const codebuild = new AWS.CodeBuild();
async function handler(event) {
    var _a, _b, _c, _d;
    console.debug(`event: ${JSON.stringify(event)}`);
    const projectName = ((_a = event.queryStringParameters) === null || _a === void 0 ? void 0 : _a.projectName) || process.env.DEFAULT_PROJECT_NAME;
    const onlyUrl = (_b = event.queryStringParameters) === null || _b === void 0 ? void 0 : _b.url;
    if (!projectName || projectName === '') {
        throw 'projectName in query parameter is not existing or empty!';
    }
    // eslint-disable-next-line @typescript-eslint/no-require-imports
    const fs = require('fs');
    let builds;
    try {
        builds = await codebuild.listBuildsForProject({
            projectName: projectName || '',
        }).promise();
    }
    catch (e) {
        return {
            statusCode: 200,
            headers: {
                'Content-Type': 'image/svg+xml',
            },
            body: fs.readFileSync('./badges/not_found.svg').toString('base64'),
            isBase64Encoded: true,
        };
    }
    console.debug(`lastBuildStatus: ${JSON.stringify(builds)}`);
    const lastBuildId = ((_c = builds.ids) === null || _c === void 0 ? void 0 : _c[0]) || '';
    const region = process.env.AWS_REGION;
    const account = process.env.ACCOUNT;
    if (onlyUrl === 'true') {
        return {
            statusCode: 301,
            headers: {
                Location: `https://${region}.console.aws.amazon.com/codesuite/codebuild/${account}/projects/${projectName}/build/${lastBuildId}`,
            },
        };
    }
    const lastBuild = await codebuild.batchGetBuilds({
        ids: [lastBuildId],
    }).promise();
    console.debug(`lastBuild: ${JSON.stringify(lastBuild)}`);
    const lastBuildStatus = (_d = lastBuild.builds) === null || _d === void 0 ? void 0 : _d[0].buildStatus;
    console.debug(`lastBuildStatus: ${lastBuildStatus}`);
    let imagePath = './badges/failed.svg';
    switch (lastBuildStatus) {
        case 'SUCCEEDED': {
            imagePath = './badges/succeeded.svg';
            break;
        }
        case 'FAILED': {
            imagePath = './badges/failed.svg';
            break;
        }
        case 'IN_PROGRESS': {
            imagePath = './badges/in_progress.svg';
            break;
        }
        case 'STOPPED': {
            imagePath = './badges/stopped.svg';
            break;
        }
        case 'FAULT': {
            imagePath = './badges/failed.svg';
            break;
        }
        case 'TIMED_OUT': {
            imagePath = './badges/failed.svg';
            break;
        }
    }
    return {
        statusCode: 200,
        headers: {
            'Content-Type': 'image/svg+xml',
        },
        body: fs.readFileSync(imagePath).toString('base64'),
        isBase64Encoded: true,
    };
}
exports.handler = handler;
;
//# sourceMappingURL=data:application/json;base64,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