"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isResourceScrutinyType = exports.ResourceScrutinyType = exports.SpecialRefKind = exports.isPrimitiveMapAttribute = exports.isComplexListAttribute = exports.isPrimitiveListAttribute = exports.isMapAttribute = exports.isListAttribute = exports.isPrimitiveAttribute = exports.isTaggableResource = void 0;
const property_1 = require("./property");
/**
 * Determine if the resource supports tags
 *
 * This function combined with isTagProperty determines if the `cdk.TagManager`
 * and `cdk.TaggableResource` can process these tags. If not, standard code
 * generation of properties will be used.
 */
function isTaggableResource(spec) {
    if (spec.Properties === undefined) {
        return false;
    }
    for (const key of Object.keys(spec.Properties)) {
        if (property_1.isTagPropertyName(key) && property_1.isTagProperty(spec.Properties[key])) {
            return true;
        }
    }
    return false;
}
exports.isTaggableResource = isTaggableResource;
function isPrimitiveAttribute(spec) {
    return !!spec.PrimitiveType;
}
exports.isPrimitiveAttribute = isPrimitiveAttribute;
function isListAttribute(spec) {
    return spec.Type === 'List';
}
exports.isListAttribute = isListAttribute;
function isMapAttribute(spec) {
    return spec.Type === 'Map';
}
exports.isMapAttribute = isMapAttribute;
function isPrimitiveListAttribute(spec) {
    return isListAttribute(spec) && !!spec.PrimitiveItemType;
}
exports.isPrimitiveListAttribute = isPrimitiveListAttribute;
function isComplexListAttribute(spec) {
    return isListAttribute(spec) && !!spec.ItemType;
}
exports.isComplexListAttribute = isComplexListAttribute;
function isPrimitiveMapAttribute(spec) {
    return isMapAttribute(spec) && !!spec.PrimitiveItemType;
}
exports.isPrimitiveMapAttribute = isPrimitiveMapAttribute;
/**
 * Type declaration for special values of the "Ref" attribute represents.
 *
 * The attribute can take on more values than these, but these are treated specially.
 */
var SpecialRefKind;
(function (SpecialRefKind) {
    /**
     * No '.ref' member is generated for this type, because it doesn't have a meaningful value.
     */
    SpecialRefKind["None"] = "None";
    /**
     * The generated class will inherit from the built-in 'Arn' type.
     */
    SpecialRefKind["Arn"] = "Arn";
})(SpecialRefKind = exports.SpecialRefKind || (exports.SpecialRefKind = {}));
var ResourceScrutinyType;
(function (ResourceScrutinyType) {
    /**
     * No additional scrutiny
     */
    ResourceScrutinyType["None"] = "None";
    /**
     * An externally attached policy document to a resource
     *
     * (Common for SQS, SNS, S3, ...)
     */
    ResourceScrutinyType["ResourcePolicyResource"] = "ResourcePolicyResource";
    /**
     * This is an IAM policy on an identity resource
     *
     * (Basically saying: this is AWS::IAM::Policy)
     */
    ResourceScrutinyType["IdentityPolicyResource"] = "IdentityPolicyResource";
    /**
     * This is a Lambda Permission policy
     */
    ResourceScrutinyType["LambdaPermission"] = "LambdaPermission";
    /**
     * An ingress rule object
     */
    ResourceScrutinyType["IngressRuleResource"] = "IngressRuleResource";
    /**
     * A set of egress rules
     */
    ResourceScrutinyType["EgressRuleResource"] = "EgressRuleResource";
})(ResourceScrutinyType = exports.ResourceScrutinyType || (exports.ResourceScrutinyType = {}));
function isResourceScrutinyType(str) {
    return ResourceScrutinyType[str] !== undefined;
}
exports.isResourceScrutinyType = isResourceScrutinyType;
//# sourceMappingURL=data:application/json;base64,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