"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssetManifestArtifact = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cloud_artifact_1 = require("../cloud-artifact");
/**
 * Asset manifest is a description of a set of assets which need to be built and published.
 *
 * @stability stable
 */
class AssetManifestArtifact extends cloud_artifact_1.CloudArtifact {
    /**
     * @stability stable
     */
    constructor(assembly, name, artifact) {
        var _b;
        super(assembly, name, artifact);
        const properties = (this.manifest.properties || {});
        if (!properties.file) {
            throw new Error('Invalid AssetManifestArtifact. Missing "file" property');
        }
        this.file = path.resolve(this.assembly.directory, properties.file);
        this.requiresBootstrapStackVersion = (_b = properties.requiresBootstrapStackVersion) !== null && _b !== void 0 ? _b : 1;
        this.bootstrapStackVersionSsmParameter = properties.bootstrapStackVersionSsmParameter;
    }
}
exports.AssetManifestArtifact = AssetManifestArtifact;
_a = JSII_RTTI_SYMBOL_1;
AssetManifestArtifact[_a] = { fqn: "@aws-cdk/cx-api.AssetManifestArtifact", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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