"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NestedCloudAssemblyArtifact = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cloud_artifact_1 = require("../cloud-artifact");
const cloud_assembly_1 = require("../cloud-assembly");
/**
 * Asset manifest is a description of a set of assets which need to be built and published.
 *
 * @stability stable
 */
class NestedCloudAssemblyArtifact extends cloud_artifact_1.CloudArtifact {
    /**
     * @stability stable
     */
    constructor(assembly, name, artifact) {
        var _b;
        super(assembly, name, artifact);
        const properties = (this.manifest.properties || {});
        this.directoryName = properties.directoryName;
        this.displayName = (_b = properties.displayName) !== null && _b !== void 0 ? _b : name;
    }
    /**
     * Full path to the nested assembly directory.
     *
     * @stability stable
     */
    get fullPath() {
        return path.join(this.assembly.directory, this.directoryName);
    }
    /**
     * The nested Assembly.
     *
     * @stability stable
     */
    get nestedAssembly() {
        if (!this._nestedAssembly) {
            this._nestedAssembly = new cloud_assembly_1.CloudAssembly(this.fullPath);
        }
        return this._nestedAssembly;
    }
}
exports.NestedCloudAssemblyArtifact = NestedCloudAssemblyArtifact;
_a = JSII_RTTI_SYMBOL_1;
NestedCloudAssemblyArtifact[_a] = { fqn: "@aws-cdk/cx-api.NestedCloudAssemblyArtifact", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmVzdGVkLWNsb3VkLWFzc2VtYmx5LWFydGlmYWN0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsibmVzdGVkLWNsb3VkLWFzc2VtYmx5LWFydGlmYWN0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNkJBQTZCO0FBRTdCLHNEQUFrRDtBQUNsRCxzREFBa0Q7Ozs7OztBQUtsRCxNQUFhLDJCQUE0QixTQUFRLDhCQUFhOzs7O0lBZ0I1RCxZQUFZLFFBQXVCLEVBQUUsSUFBWSxFQUFFLFFBQW1DOztRQUNwRixLQUFLLENBQUMsUUFBUSxFQUFFLElBQUksRUFBRSxRQUFRLENBQUMsQ0FBQztRQUVoQyxNQUFNLFVBQVUsR0FBRyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsVUFBVSxJQUFJLEVBQUUsQ0FBMkMsQ0FBQztRQUM5RixJQUFJLENBQUMsYUFBYSxHQUFHLFVBQVUsQ0FBQyxhQUFhLENBQUM7UUFDOUMsSUFBSSxDQUFDLFdBQVcsU0FBRyxVQUFVLENBQUMsV0FBVyxtQ0FBSSxJQUFJLENBQUM7SUFDcEQsQ0FBQzs7Ozs7O0lBS0QsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLFNBQVMsRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUM7SUFDaEUsQ0FBQzs7Ozs7O0lBS0QsSUFBVyxjQUFjO1FBQ3ZCLElBQUksQ0FBQyxJQUFJLENBQUMsZUFBZSxFQUFFO1lBQ3pCLElBQUksQ0FBQyxlQUFlLEdBQUcsSUFBSSw4QkFBYSxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQztTQUN6RDtRQUNELE9BQU8sSUFBSSxDQUFDLGVBQWUsQ0FBQztJQUM5QixDQUFDOztBQXZDSCxrRUF3Q0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBwYXRoIGZyb20gJ3BhdGgnO1xuaW1wb3J0ICogYXMgY3hzY2hlbWEgZnJvbSAnQGF3cy1jZGsvY2xvdWQtYXNzZW1ibHktc2NoZW1hJztcbmltcG9ydCB7IENsb3VkQXJ0aWZhY3QgfSBmcm9tICcuLi9jbG91ZC1hcnRpZmFjdCc7XG5pbXBvcnQgeyBDbG91ZEFzc2VtYmx5IH0gZnJvbSAnLi4vY2xvdWQtYXNzZW1ibHknO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIE5lc3RlZENsb3VkQXNzZW1ibHlBcnRpZmFjdCBleHRlbmRzIENsb3VkQXJ0aWZhY3Qge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBkaXJlY3RvcnlOYW1lOiBzdHJpbmc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyByZWFkb25seSBkaXNwbGF5TmFtZTogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBDYWNoZSBmb3IgdGhlIGlubmVyIGFzc2VtYmx5IGxvYWRpbmdcbiAgICovXG4gIHByaXZhdGUgX25lc3RlZEFzc2VtYmx5PzogQ2xvdWRBc3NlbWJseTtcblxuICBjb25zdHJ1Y3Rvcihhc3NlbWJseTogQ2xvdWRBc3NlbWJseSwgbmFtZTogc3RyaW5nLCBhcnRpZmFjdDogY3hzY2hlbWEuQXJ0aWZhY3RNYW5pZmVzdCkge1xuICAgIHN1cGVyKGFzc2VtYmx5LCBuYW1lLCBhcnRpZmFjdCk7XG5cbiAgICBjb25zdCBwcm9wZXJ0aWVzID0gKHRoaXMubWFuaWZlc3QucHJvcGVydGllcyB8fCB7fSkgYXMgY3hzY2hlbWEuTmVzdGVkQ2xvdWRBc3NlbWJseVByb3BlcnRpZXM7XG4gICAgdGhpcy5kaXJlY3RvcnlOYW1lID0gcHJvcGVydGllcy5kaXJlY3RvcnlOYW1lO1xuICAgIHRoaXMuZGlzcGxheU5hbWUgPSBwcm9wZXJ0aWVzLmRpc3BsYXlOYW1lID8/IG5hbWU7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGdldCBmdWxsUGF0aCgpOiBzdHJpbmcge1xuICAgIHJldHVybiBwYXRoLmpvaW4odGhpcy5hc3NlbWJseS5kaXJlY3RvcnksIHRoaXMuZGlyZWN0b3J5TmFtZSk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBnZXQgbmVzdGVkQXNzZW1ibHkoKTogQ2xvdWRBc3NlbWJseSB7XG4gICAgaWYgKCF0aGlzLl9uZXN0ZWRBc3NlbWJseSkge1xuICAgICAgdGhpcy5fbmVzdGVkQXNzZW1ibHkgPSBuZXcgQ2xvdWRBc3NlbWJseSh0aGlzLmZ1bGxQYXRoKTtcbiAgICB9XG4gICAgcmV0dXJuIHRoaXMuX25lc3RlZEFzc2VtYmx5O1xuICB9XG59XG4iXX0=