/**
 * Load balancer ip address type.
 *
 * @stability stable
 */
export declare enum LoadBalancerIpAddressType {
    /**
     * IPV4 ip address.
     *
     * @stability stable
     */
    IPV4 = "ipv4",
    /**
     * Dual stack address.
     *
     * @stability stable
     */
    DUAL_STACK = "dualstack"
}
/**
 * Properties of a discovered load balancer.
 *
 * @stability stable
 */
export interface LoadBalancerContextResponse {
    /**
     * The ARN of the load balancer.
     *
     * @stability stable
     */
    readonly loadBalancerArn: string;
    /**
     * The hosted zone ID of the load balancer's name.
     *
     * @stability stable
     */
    readonly loadBalancerCanonicalHostedZoneId: string;
    /**
     * Load balancer's DNS name.
     *
     * @stability stable
     */
    readonly loadBalancerDnsName: string;
    /**
     * Type of IP address.
     *
     * @stability stable
     */
    readonly ipAddressType: LoadBalancerIpAddressType;
    /**
     * Load balancer's security groups.
     *
     * @stability stable
     */
    readonly securityGroupIds: string[];
    /**
     * Load balancer's VPC.
     *
     * @stability stable
     */
    readonly vpcId: string;
}
/**
 * Properties of a discovered load balancer listener.
 *
 * @stability stable
 */
export interface LoadBalancerListenerContextResponse {
    /**
     * The ARN of the listener.
     *
     * @stability stable
     */
    readonly listenerArn: string;
    /**
     * The port the listener is listening on.
     *
     * @stability stable
     */
    readonly listenerPort: number;
    /**
     * The security groups of the load balancer.
     *
     * @stability stable
     */
    readonly securityGroupIds: string[];
}
