"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PROVIDER_ERROR_KEY = exports.CLI_VERSION_ENV = exports.CLI_ASM_VERSION_ENV = exports.DEFAULT_REGION_ENV = exports.DEFAULT_ACCOUNT_ENV = exports.CONTEXT_ENV = exports.OUTDIR_ENV = void 0;
// output directory into which to emit synthesis outputs. CDK doesn't allow outdir
// to be specified both through the CDK_OUTDIR environment variable and the through
// aws:cdk:outdir context.
exports.OUTDIR_ENV = 'CDK_OUTDIR';
exports.CONTEXT_ENV = 'CDK_CONTEXT_JSON';
/**
 * Environment variable set by the CDK CLI with the default AWS account ID.
 */
exports.DEFAULT_ACCOUNT_ENV = 'CDK_DEFAULT_ACCOUNT';
/**
 * Environment variable set by the CDK CLI with the default AWS region.
 */
exports.DEFAULT_REGION_ENV = 'CDK_DEFAULT_REGION';
/**
 * Version of Cloud Assembly expected by CDK CLI.
 *
 * CLI started emitting this at 1.10.1
 */
exports.CLI_ASM_VERSION_ENV = 'CDK_CLI_ASM_VERSION';
/**
 * Version of the CLI currently running.
 *
 * CLI started emitting this at 1.10.1
 */
exports.CLI_VERSION_ENV = 'CDK_CLI_VERSION';
/**
 * If a context value is an object with this key, it indicates an error
 */
exports.PROVIDER_ERROR_KEY = '$providerError';
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY3hhcGkuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJjeGFwaS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxrRkFBa0Y7QUFDbEYsbUZBQW1GO0FBQ25GLDBCQUEwQjtBQUNiLFFBQUEsVUFBVSxHQUFHLFlBQVksQ0FBQztBQUMxQixRQUFBLFdBQVcsR0FBRyxrQkFBa0IsQ0FBQztBQUU5Qzs7R0FFRztBQUNVLFFBQUEsbUJBQW1CLEdBQUcscUJBQXFCLENBQUM7QUFFekQ7O0dBRUc7QUFDVSxRQUFBLGtCQUFrQixHQUFHLG9CQUFvQixDQUFDO0FBRXZEOzs7O0dBSUc7QUFDVSxRQUFBLG1CQUFtQixHQUFHLHFCQUFxQixDQUFDO0FBRXpEOzs7O0dBSUc7QUFDVSxRQUFBLGVBQWUsR0FBRyxpQkFBaUIsQ0FBQztBQUVqRDs7R0FFRztBQUNVLFFBQUEsa0JBQWtCLEdBQUcsZ0JBQWdCLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBvdXRwdXQgZGlyZWN0b3J5IGludG8gd2hpY2ggdG8gZW1pdCBzeW50aGVzaXMgb3V0cHV0cy4gQ0RLIGRvZXNuJ3QgYWxsb3cgb3V0ZGlyXG4vLyB0byBiZSBzcGVjaWZpZWQgYm90aCB0aHJvdWdoIHRoZSBDREtfT1VURElSIGVudmlyb25tZW50IHZhcmlhYmxlIGFuZCB0aGUgdGhyb3VnaFxuLy8gYXdzOmNkazpvdXRkaXIgY29udGV4dC5cbmV4cG9ydCBjb25zdCBPVVRESVJfRU5WID0gJ0NES19PVVRESVInO1xuZXhwb3J0IGNvbnN0IENPTlRFWFRfRU5WID0gJ0NES19DT05URVhUX0pTT04nO1xuXG4vKipcbiAqIEVudmlyb25tZW50IHZhcmlhYmxlIHNldCBieSB0aGUgQ0RLIENMSSB3aXRoIHRoZSBkZWZhdWx0IEFXUyBhY2NvdW50IElELlxuICovXG5leHBvcnQgY29uc3QgREVGQVVMVF9BQ0NPVU5UX0VOViA9ICdDREtfREVGQVVMVF9BQ0NPVU5UJztcblxuLyoqXG4gKiBFbnZpcm9ubWVudCB2YXJpYWJsZSBzZXQgYnkgdGhlIENESyBDTEkgd2l0aCB0aGUgZGVmYXVsdCBBV1MgcmVnaW9uLlxuICovXG5leHBvcnQgY29uc3QgREVGQVVMVF9SRUdJT05fRU5WID0gJ0NES19ERUZBVUxUX1JFR0lPTic7XG5cbi8qKlxuICogVmVyc2lvbiBvZiBDbG91ZCBBc3NlbWJseSBleHBlY3RlZCBieSBDREsgQ0xJLlxuICpcbiAqIENMSSBzdGFydGVkIGVtaXR0aW5nIHRoaXMgYXQgMS4xMC4xXG4gKi9cbmV4cG9ydCBjb25zdCBDTElfQVNNX1ZFUlNJT05fRU5WID0gJ0NES19DTElfQVNNX1ZFUlNJT04nO1xuXG4vKipcbiAqIFZlcnNpb24gb2YgdGhlIENMSSBjdXJyZW50bHkgcnVubmluZy5cbiAqXG4gKiBDTEkgc3RhcnRlZCBlbWl0dGluZyB0aGlzIGF0IDEuMTAuMVxuICovXG5leHBvcnQgY29uc3QgQ0xJX1ZFUlNJT05fRU5WID0gJ0NES19DTElfVkVSU0lPTic7XG5cbi8qKlxuICogSWYgYSBjb250ZXh0IHZhbHVlIGlzIGFuIG9iamVjdCB3aXRoIHRoaXMga2V5LCBpdCBpbmRpY2F0ZXMgYW4gZXJyb3JcbiAqL1xuZXhwb3J0IGNvbnN0IFBST1ZJREVSX0VSUk9SX0tFWSA9ICckcHJvdmlkZXJFcnJvcic7Il19