import * as cxschema from '@aws-cdk/cloud-assembly-schema';
/**
 * The key used when CDK path is embedded in **CloudFormation template** metadata (not cdk metadata).
 */
export declare const PATH_METADATA_KEY = "aws:cdk:path";
/**
 * @stability stable
 */
export declare enum SynthesisMessageLevel {
    /**
     * @stability stable
     */
    INFO = "info",
    /**
     * @stability stable
     */
    WARNING = "warning",
    /**
     * @stability stable
     */
    ERROR = "error"
}
/**
 * @stability stable
 */
export interface MetadataEntryResult extends cxschema.MetadataEntry {
    /**
     * The path in which this entry was defined.
     *
     * @stability stable
     */
    readonly path: string;
}
/**
 * Metadata associated with the objects in the stack's Construct tree
 */
export declare type StackMetadata = {
    [path: string]: cxschema.MetadataEntry[];
};
/**
 * @stability stable
 */
export interface SynthesisMessage {
    /**
     * @stability stable
     */
    readonly level: SynthesisMessageLevel;
    /**
     * @stability stable
     */
    readonly id: string;
    /**
     * @stability stable
     */
    readonly entry: cxschema.MetadataEntry;
}
