"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Default = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Provides default values for certain regional information points.
 *
 * @stability stable
 */
class Default {
    constructor() { }
    /**
     * Computes a "standard" AWS Service principal for a given service, region and suffix.
     *
     * This is useful for example when
     * you need to compute a service principal name, but you do not have a synthesize-time region literal available (so
     * all you have is `{ "Ref": "AWS::Region" }`). This way you get the same defaulting behavior that is normally used
     * for built-in data.
     *
     * @param service the name of the service (s3, s3.amazonaws.com, ...).
     * @param region the region in which the service principal is needed.
     * @param urlSuffix the URL suffix for the partition in which the region is located.
     * @stability stable
     */
    static servicePrincipal(service, region, urlSuffix) {
        const matches = service.match(/^([^.]+)(?:(?:\.amazonaws\.com(?:\.cn)?)|(?:\.c2s\.ic\.gov)|(?:\.sc2s\.sgov\.gov))?$/);
        if (!matches) {
            // Return "service" if it does not look like any of the following:
            // - s3
            // - s3.amazonaws.com
            // - s3.amazonaws.com.cn
            // - s3.c2s.ic.gov
            // - s3.sc2s.sgov.gov
            return service;
        }
        service = matches[1]; // Simplify the service name down to something like "s3"
        // Exceptions for Service Principals in us-iso-*
        const US_ISO_EXCEPTIONS = new Set([
            'cloudhsm',
            'config',
            'states',
            'workspaces',
        ]);
        // Exceptions for Service Principals in us-isob-*
        const US_ISOB_EXCEPTIONS = new Set([
            'dms',
            'states',
        ]);
        // Account for idiosyncratic Service Principals in `us-iso-*` regions
        if (region.startsWith('us-iso-') && US_ISO_EXCEPTIONS.has(service)) {
            switch (service) {
                // Services with universal principal
                case ('states'):
                    return `${service}.amazonaws.com`;
                // Services with a partitional principal
                default:
                    return `${service}.${urlSuffix}`;
            }
        }
        // Account for idiosyncratic Service Principals in `us-isob-*` regions
        if (region.startsWith('us-isob-') && US_ISOB_EXCEPTIONS.has(service)) {
            switch (service) {
                // Services with universal principal
                case ('states'):
                    return `${service}.amazonaws.com`;
                // Services with a partitional principal
                default:
                    return `${service}.${urlSuffix}`;
            }
        }
        switch (service) {
            // Services with a regional AND partitional principal
            case 'codedeploy':
            case 'logs':
                return `${service}.${region}.${urlSuffix}`;
            // Services with a regional principal
            case 'states':
                return `${service}.${region}.amazonaws.com`;
            // Services with a partitional principal
            case 'ec2':
                return `${service}.${urlSuffix}`;
            // Services with a universal principal across all regions/partitions (the default case)
            default:
                return `${service}.amazonaws.com`;
        }
    }
}
exports.Default = Default;
_a = JSII_RTTI_SYMBOL_1;
Default[_a] = { fqn: "@aws-cdk/region-info.Default", version: "1.106.1" };
/**
 * The default value for a VPC Endpoint Service name prefix, useful if you do not have a synthesize-time region literal available (all you have is `{ "Ref": "AWS::Region" }`).
 *
 * @stability stable
 */
Default.VPC_ENDPOINT_SERVICE_NAME_PREFIX = 'com.amazonaws.vpce';
//# sourceMappingURL=data:application/json;base64,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