# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AutoScalingConfigurationAutoScalingResources',
    'AutoScalingConfigurationPolicy',
    'AutoScalingConfigurationPolicyCapacity',
    'AutoScalingConfigurationPolicyExecutionSchedule',
    'AutoScalingConfigurationPolicyResourceAction',
    'AutoScalingConfigurationPolicyRule',
    'AutoScalingConfigurationPolicyRuleAction',
    'AutoScalingConfigurationPolicyRuleMetric',
    'AutoScalingConfigurationPolicyRuleMetricThreshold',
    'GetAutoScalingConfigurationAutoScalingResourceResult',
    'GetAutoScalingConfigurationPolicyResult',
    'GetAutoScalingConfigurationPolicyCapacityResult',
    'GetAutoScalingConfigurationPolicyExecutionScheduleResult',
    'GetAutoScalingConfigurationPolicyResourceActionResult',
    'GetAutoScalingConfigurationPolicyRuleResult',
    'GetAutoScalingConfigurationPolicyRuleActionResult',
    'GetAutoScalingConfigurationPolicyRuleMetricResult',
    'GetAutoScalingConfigurationPolicyRuleMetricThresholdResult',
    'GetAutoScalingConfigurationsAutoScalingConfigurationResult',
    'GetAutoScalingConfigurationsAutoScalingConfigurationAutoScalingResourceResult',
    'GetAutoScalingConfigurationsAutoScalingConfigurationPolicyResult',
    'GetAutoScalingConfigurationsAutoScalingConfigurationPolicyCapacityResult',
    'GetAutoScalingConfigurationsAutoScalingConfigurationPolicyExecutionScheduleResult',
    'GetAutoScalingConfigurationsAutoScalingConfigurationPolicyResourceActionResult',
    'GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleResult',
    'GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleActionResult',
    'GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleMetricResult',
    'GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleMetricThresholdResult',
    'GetAutoScalingConfigurationsFilterResult',
]

@pulumi.output_type
class AutoScalingConfigurationAutoScalingResources(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource that is managed by the autoscaling configuration.
        :param _builtins.str type: The type of resource.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the resource that is managed by the autoscaling configuration.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of resource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class AutoScalingConfigurationPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyType":
            suggest = "policy_type"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "executionSchedule":
            suggest = "execution_schedule"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "resourceAction":
            suggest = "resource_action"
        elif key == "timeCreated":
            suggest = "time_created"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScalingConfigurationPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScalingConfigurationPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScalingConfigurationPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy_type: _builtins.str,
                 capacity: Optional['outputs.AutoScalingConfigurationPolicyCapacity'] = None,
                 display_name: Optional[_builtins.str] = None,
                 execution_schedule: Optional['outputs.AutoScalingConfigurationPolicyExecutionSchedule'] = None,
                 id: Optional[_builtins.str] = None,
                 is_enabled: Optional[_builtins.bool] = None,
                 resource_action: Optional['outputs.AutoScalingConfigurationPolicyResourceAction'] = None,
                 rules: Optional[Sequence['outputs.AutoScalingConfigurationPolicyRule']] = None,
                 time_created: Optional[_builtins.str] = None):
        """
        :param _builtins.str policy_type: The type of autoscaling policy.
        :param 'AutoScalingConfigurationPolicyCapacityArgs' capacity: The capacity requirements of the autoscaling policy.
        :param _builtins.str display_name: A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param 'AutoScalingConfigurationPolicyExecutionScheduleArgs' execution_schedule: An execution schedule for an autoscaling policy.
        :param _builtins.str id: ID of the condition that is assigned after creation.
        :param _builtins.bool is_enabled: Whether the autoscaling policy is enabled.
        :param 'AutoScalingConfigurationPolicyResourceActionArgs' resource_action: An action that can be executed against a resource.
        :param _builtins.str time_created: The date and time the autoscaling configuration was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "policy_type", policy_type)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if execution_schedule is not None:
            pulumi.set(__self__, "execution_schedule", execution_schedule)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if resource_action is not None:
            pulumi.set(__self__, "resource_action", resource_action)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> _builtins.str:
        """
        The type of autoscaling policy.
        """
        return pulumi.get(self, "policy_type")

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional['outputs.AutoScalingConfigurationPolicyCapacity']:
        """
        The capacity requirements of the autoscaling policy.
        """
        return pulumi.get(self, "capacity")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="executionSchedule")
    def execution_schedule(self) -> Optional['outputs.AutoScalingConfigurationPolicyExecutionSchedule']:
        """
        An execution schedule for an autoscaling policy.
        """
        return pulumi.get(self, "execution_schedule")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        ID of the condition that is assigned after creation.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether the autoscaling policy is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter(name="resourceAction")
    def resource_action(self) -> Optional['outputs.AutoScalingConfigurationPolicyResourceAction']:
        """
        An action that can be executed against a resource.
        """
        return pulumi.get(self, "resource_action")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.AutoScalingConfigurationPolicyRule']]:
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[_builtins.str]:
        """
        The date and time the autoscaling configuration was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class AutoScalingConfigurationPolicyCapacity(dict):
    def __init__(__self__, *,
                 initial: Optional[_builtins.int] = None,
                 max: Optional[_builtins.int] = None,
                 min: Optional[_builtins.int] = None):
        """
        :param _builtins.int initial: For a threshold-based autoscaling policy, this value is the initial number of instances to launch in the instance pool immediately after autoscaling is enabled. After autoscaling retrieves performance metrics, the number of instances is automatically adjusted from this initial number to a number that is based on the limits that you set.
               
               For a schedule-based autoscaling policy, this value is the target pool size to scale to when executing the schedule that's defined in the autoscaling policy.
        :param _builtins.int max: For a threshold-based autoscaling policy, this value is the maximum number of instances the instance pool is allowed to increase to (scale out).
               
               For a schedule-based autoscaling policy, this value is not used.
        :param _builtins.int min: For a threshold-based autoscaling policy, this value is the minimum number of instances the instance pool is allowed to decrease to (scale in).
               
               For a schedule-based autoscaling policy, this value is not used.
        """
        if initial is not None:
            pulumi.set(__self__, "initial", initial)
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)

    @_builtins.property
    @pulumi.getter
    def initial(self) -> Optional[_builtins.int]:
        """
        For a threshold-based autoscaling policy, this value is the initial number of instances to launch in the instance pool immediately after autoscaling is enabled. After autoscaling retrieves performance metrics, the number of instances is automatically adjusted from this initial number to a number that is based on the limits that you set.

        For a schedule-based autoscaling policy, this value is the target pool size to scale to when executing the schedule that's defined in the autoscaling policy.
        """
        return pulumi.get(self, "initial")

    @_builtins.property
    @pulumi.getter
    def max(self) -> Optional[_builtins.int]:
        """
        For a threshold-based autoscaling policy, this value is the maximum number of instances the instance pool is allowed to increase to (scale out).

        For a schedule-based autoscaling policy, this value is not used.
        """
        return pulumi.get(self, "max")

    @_builtins.property
    @pulumi.getter
    def min(self) -> Optional[_builtins.int]:
        """
        For a threshold-based autoscaling policy, this value is the minimum number of instances the instance pool is allowed to decrease to (scale in).

        For a schedule-based autoscaling policy, this value is not used.
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class AutoScalingConfigurationPolicyExecutionSchedule(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 timezone: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str expression: A cron expression that represents the time at which to execute the autoscaling policy.
               
               Cron expressions have this format: `<second> <minute> <hour> <day of month> <month> <day of week> <year>`
               
               You can use special characters that are supported with the Quartz cron implementation.
               
               You must specify `0` as the value for seconds.
               
               Example: `0 15 10 ? * *`
        :param _builtins.str timezone: The time zone for the execution schedule.
        :param _builtins.str type: The type of execution schedule.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "timezone", timezone)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        """
        A cron expression that represents the time at which to execute the autoscaling policy.

        Cron expressions have this format: `<second> <minute> <hour> <day of month> <month> <day of week> <year>`

        You can use special characters that are supported with the Quartz cron implementation.

        You must specify `0` as the value for seconds.

        Example: `0 15 10 ? * *`
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> _builtins.str:
        """
        The time zone for the execution schedule.
        """
        return pulumi.get(self, "timezone")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of execution schedule.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class AutoScalingConfigurationPolicyResourceAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionType":
            suggest = "action_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScalingConfigurationPolicyResourceAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScalingConfigurationPolicyResourceAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScalingConfigurationPolicyResourceAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: _builtins.str,
                 action_type: _builtins.str):
        """
        :param _builtins.str action_type: The type of resource action.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "action_type", action_type)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="actionType")
    def action_type(self) -> _builtins.str:
        """
        The type of resource action.
        """
        return pulumi.get(self, "action_type")


@pulumi.output_type
class AutoScalingConfigurationPolicyRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScalingConfigurationPolicyRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScalingConfigurationPolicyRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScalingConfigurationPolicyRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: _builtins.str,
                 action: Optional['outputs.AutoScalingConfigurationPolicyRuleAction'] = None,
                 id: Optional[_builtins.str] = None,
                 metric: Optional['outputs.AutoScalingConfigurationPolicyRuleMetric'] = None):
        """
        :param 'AutoScalingConfigurationPolicyRuleActionArgs' action: The action to take when autoscaling is triggered.
        :param _builtins.str id: ID of the condition that is assigned after creation.
        :param 'AutoScalingConfigurationPolicyRuleMetricArgs' metric: Metric and threshold details for triggering an autoscaling action.
        """
        pulumi.set(__self__, "display_name", display_name)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if metric is not None:
            pulumi.set(__self__, "metric", metric)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional['outputs.AutoScalingConfigurationPolicyRuleAction']:
        """
        The action to take when autoscaling is triggered.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        ID of the condition that is assigned after creation.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def metric(self) -> Optional['outputs.AutoScalingConfigurationPolicyRuleMetric']:
        """
        Metric and threshold details for triggering an autoscaling action.
        """
        return pulumi.get(self, "metric")


@pulumi.output_type
class AutoScalingConfigurationPolicyRuleAction(dict):
    def __init__(__self__, *,
                 type: Optional[_builtins.str] = None,
                 value: Optional[_builtins.int] = None):
        """
        :param _builtins.str type: The type of action to take.
        :param _builtins.int value: To scale out (increase the number of instances), provide a positive value. To scale in (decrease the number of instances), provide a negative value.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The type of action to take.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.int]:
        """
        To scale out (increase the number of instances), provide a positive value. To scale in (decrease the number of instances), provide a negative value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AutoScalingConfigurationPolicyRuleMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricType":
            suggest = "metric_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScalingConfigurationPolicyRuleMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScalingConfigurationPolicyRuleMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScalingConfigurationPolicyRuleMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_type: Optional[_builtins.str] = None,
                 threshold: Optional['outputs.AutoScalingConfigurationPolicyRuleMetricThreshold'] = None):
        if metric_type is not None:
            pulumi.set(__self__, "metric_type", metric_type)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)

    @_builtins.property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "metric_type")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> Optional['outputs.AutoScalingConfigurationPolicyRuleMetricThreshold']:
        return pulumi.get(self, "threshold")


@pulumi.output_type
class AutoScalingConfigurationPolicyRuleMetricThreshold(dict):
    def __init__(__self__, *,
                 operator: Optional[_builtins.str] = None,
                 value: Optional[_builtins.int] = None):
        """
        :param _builtins.str operator: The comparison operator to use. Options are greater than (`GT`), greater than or equal to (`GTE`), less than (`LT`), and less than or equal to (`LTE`).
        :param _builtins.int value: ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def operator(self) -> Optional[_builtins.str]:
        """
        The comparison operator to use. Options are greater than (`GT`), greater than or equal to (`GTE`), less than (`LT`), and less than or equal to (`LTE`).
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.int]:
        """
        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAutoScalingConfigurationAutoScalingResourceResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str id: ID of the condition that is assigned after creation.
        :param _builtins.str type: The type of action to take.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the condition that is assigned after creation.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of action to take.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetAutoScalingConfigurationPolicyResult(dict):
    def __init__(__self__, *,
                 capacities: Sequence['outputs.GetAutoScalingConfigurationPolicyCapacityResult'],
                 display_name: _builtins.str,
                 execution_schedules: Sequence['outputs.GetAutoScalingConfigurationPolicyExecutionScheduleResult'],
                 id: _builtins.str,
                 is_enabled: _builtins.bool,
                 policy_type: _builtins.str,
                 resource_actions: Sequence['outputs.GetAutoScalingConfigurationPolicyResourceActionResult'],
                 rules: Sequence['outputs.GetAutoScalingConfigurationPolicyRuleResult'],
                 time_created: _builtins.str):
        """
        :param Sequence['GetAutoScalingConfigurationPolicyCapacityArgs'] capacities: The capacity requirements of the autoscaling policy.
        :param _builtins.str display_name: A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param Sequence['GetAutoScalingConfigurationPolicyExecutionScheduleArgs'] execution_schedules: The schedule for executing the autoscaling policy.
        :param _builtins.str id: ID of the condition that is assigned after creation.
        :param _builtins.bool is_enabled: Whether the autoscaling policy is enabled.
        :param _builtins.str policy_type: The type of autoscaling policy.
        :param Sequence['GetAutoScalingConfigurationPolicyResourceActionArgs'] resource_actions: An action that can be executed against a resource.
        :param _builtins.str time_created: The date and time the autoscaling configuration was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "capacities", capacities)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "execution_schedules", execution_schedules)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "policy_type", policy_type)
        pulumi.set(__self__, "resource_actions", resource_actions)
        pulumi.set(__self__, "rules", rules)
        pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter
    def capacities(self) -> Sequence['outputs.GetAutoScalingConfigurationPolicyCapacityResult']:
        """
        The capacity requirements of the autoscaling policy.
        """
        return pulumi.get(self, "capacities")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="executionSchedules")
    def execution_schedules(self) -> Sequence['outputs.GetAutoScalingConfigurationPolicyExecutionScheduleResult']:
        """
        The schedule for executing the autoscaling policy.
        """
        return pulumi.get(self, "execution_schedules")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the condition that is assigned after creation.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> _builtins.bool:
        """
        Whether the autoscaling policy is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> _builtins.str:
        """
        The type of autoscaling policy.
        """
        return pulumi.get(self, "policy_type")

    @_builtins.property
    @pulumi.getter(name="resourceActions")
    def resource_actions(self) -> Sequence['outputs.GetAutoScalingConfigurationPolicyResourceActionResult']:
        """
        An action that can be executed against a resource.
        """
        return pulumi.get(self, "resource_actions")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetAutoScalingConfigurationPolicyRuleResult']:
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the autoscaling configuration was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetAutoScalingConfigurationPolicyCapacityResult(dict):
    def __init__(__self__, *,
                 initial: _builtins.int,
                 max: _builtins.int,
                 min: _builtins.int):
        """
        :param _builtins.int initial: For a threshold-based autoscaling policy, this value is the initial number of instances to launch in the instance pool immediately after autoscaling is enabled. After autoscaling retrieves performance metrics, the number of instances is automatically adjusted from this initial number to a number that is based on the limits that you set.
        :param _builtins.int max: For a threshold-based autoscaling policy, this value is the maximum number of instances the instance pool is allowed to increase to (scale out).
        :param _builtins.int min: For a threshold-based autoscaling policy, this value is the minimum number of instances the instance pool is allowed to decrease to (scale in).
        """
        pulumi.set(__self__, "initial", initial)
        pulumi.set(__self__, "max", max)
        pulumi.set(__self__, "min", min)

    @_builtins.property
    @pulumi.getter
    def initial(self) -> _builtins.int:
        """
        For a threshold-based autoscaling policy, this value is the initial number of instances to launch in the instance pool immediately after autoscaling is enabled. After autoscaling retrieves performance metrics, the number of instances is automatically adjusted from this initial number to a number that is based on the limits that you set.
        """
        return pulumi.get(self, "initial")

    @_builtins.property
    @pulumi.getter
    def max(self) -> _builtins.int:
        """
        For a threshold-based autoscaling policy, this value is the maximum number of instances the instance pool is allowed to increase to (scale out).
        """
        return pulumi.get(self, "max")

    @_builtins.property
    @pulumi.getter
    def min(self) -> _builtins.int:
        """
        For a threshold-based autoscaling policy, this value is the minimum number of instances the instance pool is allowed to decrease to (scale in).
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class GetAutoScalingConfigurationPolicyExecutionScheduleResult(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 timezone: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str expression: A cron expression that represents the time at which to execute the autoscaling policy.
        :param _builtins.str timezone: The time zone for the execution schedule.
        :param _builtins.str type: The type of action to take.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "timezone", timezone)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        """
        A cron expression that represents the time at which to execute the autoscaling policy.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> _builtins.str:
        """
        The time zone for the execution schedule.
        """
        return pulumi.get(self, "timezone")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of action to take.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetAutoScalingConfigurationPolicyResourceActionResult(dict):
    def __init__(__self__, *,
                 action: _builtins.str,
                 action_type: _builtins.str):
        """
        :param _builtins.str action: The action to take when autoscaling is triggered.
        :param _builtins.str action_type: The type of resource action.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "action_type", action_type)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        The action to take when autoscaling is triggered.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="actionType")
    def action_type(self) -> _builtins.str:
        """
        The type of resource action.
        """
        return pulumi.get(self, "action_type")


@pulumi.output_type
class GetAutoScalingConfigurationPolicyRuleResult(dict):
    def __init__(__self__, *,
                 actions: Sequence['outputs.GetAutoScalingConfigurationPolicyRuleActionResult'],
                 display_name: _builtins.str,
                 id: _builtins.str,
                 metrics: Sequence['outputs.GetAutoScalingConfigurationPolicyRuleMetricResult']):
        """
        :param Sequence['GetAutoScalingConfigurationPolicyRuleActionArgs'] actions: The action to take when autoscaling is triggered.
        :param _builtins.str display_name: A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param _builtins.str id: ID of the condition that is assigned after creation.
        :param Sequence['GetAutoScalingConfigurationPolicyRuleMetricArgs'] metrics: Metric and threshold details for triggering an autoscaling action.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "metrics", metrics)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GetAutoScalingConfigurationPolicyRuleActionResult']:
        """
        The action to take when autoscaling is triggered.
        """
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the condition that is assigned after creation.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def metrics(self) -> Sequence['outputs.GetAutoScalingConfigurationPolicyRuleMetricResult']:
        """
        Metric and threshold details for triggering an autoscaling action.
        """
        return pulumi.get(self, "metrics")


@pulumi.output_type
class GetAutoScalingConfigurationPolicyRuleActionResult(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 value: _builtins.int):
        """
        :param _builtins.str type: The type of action to take.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of action to take.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.int:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAutoScalingConfigurationPolicyRuleMetricResult(dict):
    def __init__(__self__, *,
                 metric_type: _builtins.str,
                 thresholds: Sequence['outputs.GetAutoScalingConfigurationPolicyRuleMetricThresholdResult']):
        pulumi.set(__self__, "metric_type", metric_type)
        pulumi.set(__self__, "thresholds", thresholds)

    @_builtins.property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> _builtins.str:
        return pulumi.get(self, "metric_type")

    @_builtins.property
    @pulumi.getter
    def thresholds(self) -> Sequence['outputs.GetAutoScalingConfigurationPolicyRuleMetricThresholdResult']:
        return pulumi.get(self, "thresholds")


@pulumi.output_type
class GetAutoScalingConfigurationPolicyRuleMetricThresholdResult(dict):
    def __init__(__self__, *,
                 operator: _builtins.str,
                 value: _builtins.int):
        """
        :param _builtins.str operator: The comparison operator to use. Options are greater than (`GT`), greater than or equal to (`GTE`), less than (`LT`), and less than or equal to (`LTE`).
        """
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        The comparison operator to use. Options are greater than (`GT`), greater than or equal to (`GTE`), less than (`LT`), and less than or equal to (`LTE`).
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.int:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAutoScalingConfigurationsAutoScalingConfigurationResult(dict):
    def __init__(__self__, *,
                 auto_scaling_resources: Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationAutoScalingResourceResult'],
                 compartment_id: _builtins.str,
                 cool_down_in_seconds: _builtins.int,
                 defined_tags: Mapping[str, _builtins.str],
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 is_enabled: _builtins.bool,
                 max_resource_count: _builtins.int,
                 min_resource_count: _builtins.int,
                 policies: Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyResult'],
                 time_created: _builtins.str):
        """
        :param Sequence['GetAutoScalingConfigurationsAutoScalingConfigurationAutoScalingResourceArgs'] auto_scaling_resources: A resource that is managed by an autoscaling configuration. The only supported type is "instancePool."
        :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the resources monitored by the metric that you are searching for. Use tenancyId to search in the root compartment.
        :param _builtins.int cool_down_in_seconds: For threshold-based autoscaling policies, this value is the minimum period of time to wait between scaling actions. The cooldown period gives the system time to stabilize before rescaling. The minimum value is 300 seconds, which is also the default. The cooldown period starts when the instance pool reaches the running state.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.
        :param Mapping[str, _builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param _builtins.str id: ID of the condition that is assigned after creation.
        :param _builtins.bool is_enabled: Whether the autoscaling policy is enabled.
        :param _builtins.int max_resource_count: The maximum number of resources to scale out to.
        :param _builtins.int min_resource_count: The minimum number of resources to scale in to.
        :param Sequence['GetAutoScalingConfigurationsAutoScalingConfigurationPolicyArgs'] policies: Autoscaling policy definitions for the autoscaling configuration. An autoscaling policy defines the criteria that trigger autoscaling actions and the actions to take.
        :param _builtins.str time_created: The date and time the autoscaling configuration was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "auto_scaling_resources", auto_scaling_resources)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "cool_down_in_seconds", cool_down_in_seconds)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "max_resource_count", max_resource_count)
        pulumi.set(__self__, "min_resource_count", min_resource_count)
        pulumi.set(__self__, "policies", policies)
        pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter(name="autoScalingResources")
    def auto_scaling_resources(self) -> Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationAutoScalingResourceResult']:
        """
        A resource that is managed by an autoscaling configuration. The only supported type is "instancePool."
        """
        return pulumi.get(self, "auto_scaling_resources")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the resources monitored by the metric that you are searching for. Use tenancyId to search in the root compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="coolDownInSeconds")
    def cool_down_in_seconds(self) -> _builtins.int:
        """
        For threshold-based autoscaling policies, this value is the minimum period of time to wait between scaling actions. The cooldown period gives the system time to stabilize before rescaling. The minimum value is 300 seconds, which is also the default. The cooldown period starts when the instance pool reaches the running state.
        """
        return pulumi.get(self, "cool_down_in_seconds")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the condition that is assigned after creation.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> _builtins.bool:
        """
        Whether the autoscaling policy is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter(name="maxResourceCount")
    def max_resource_count(self) -> _builtins.int:
        """
        The maximum number of resources to scale out to.
        """
        return pulumi.get(self, "max_resource_count")

    @_builtins.property
    @pulumi.getter(name="minResourceCount")
    def min_resource_count(self) -> _builtins.int:
        """
        The minimum number of resources to scale in to.
        """
        return pulumi.get(self, "min_resource_count")

    @_builtins.property
    @pulumi.getter
    def policies(self) -> Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyResult']:
        """
        Autoscaling policy definitions for the autoscaling configuration. An autoscaling policy defines the criteria that trigger autoscaling actions and the actions to take.
        """
        return pulumi.get(self, "policies")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the autoscaling configuration was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetAutoScalingConfigurationsAutoScalingConfigurationAutoScalingResourceResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str id: ID of the condition that is assigned after creation.
        :param _builtins.str type: The type of action to take.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the condition that is assigned after creation.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of action to take.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetAutoScalingConfigurationsAutoScalingConfigurationPolicyResult(dict):
    def __init__(__self__, *,
                 capacities: Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyCapacityResult'],
                 display_name: _builtins.str,
                 execution_schedules: Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyExecutionScheduleResult'],
                 id: _builtins.str,
                 is_enabled: _builtins.bool,
                 policy_type: _builtins.str,
                 resource_actions: Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyResourceActionResult'],
                 rules: Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleResult'],
                 time_created: _builtins.str):
        """
        :param Sequence['GetAutoScalingConfigurationsAutoScalingConfigurationPolicyCapacityArgs'] capacities: The capacity requirements of the autoscaling policy.
        :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.
        :param Sequence['GetAutoScalingConfigurationsAutoScalingConfigurationPolicyExecutionScheduleArgs'] execution_schedules: The schedule for executing the autoscaling policy.
        :param _builtins.str id: ID of the condition that is assigned after creation.
        :param _builtins.bool is_enabled: Whether the autoscaling policy is enabled.
        :param _builtins.str policy_type: The type of autoscaling policy.
        :param Sequence['GetAutoScalingConfigurationsAutoScalingConfigurationPolicyResourceActionArgs'] resource_actions: An action that can be executed against a resource.
        :param _builtins.str time_created: The date and time the autoscaling configuration was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "capacities", capacities)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "execution_schedules", execution_schedules)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "policy_type", policy_type)
        pulumi.set(__self__, "resource_actions", resource_actions)
        pulumi.set(__self__, "rules", rules)
        pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter
    def capacities(self) -> Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyCapacityResult']:
        """
        The capacity requirements of the autoscaling policy.
        """
        return pulumi.get(self, "capacities")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="executionSchedules")
    def execution_schedules(self) -> Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyExecutionScheduleResult']:
        """
        The schedule for executing the autoscaling policy.
        """
        return pulumi.get(self, "execution_schedules")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the condition that is assigned after creation.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> _builtins.bool:
        """
        Whether the autoscaling policy is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> _builtins.str:
        """
        The type of autoscaling policy.
        """
        return pulumi.get(self, "policy_type")

    @_builtins.property
    @pulumi.getter(name="resourceActions")
    def resource_actions(self) -> Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyResourceActionResult']:
        """
        An action that can be executed against a resource.
        """
        return pulumi.get(self, "resource_actions")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleResult']:
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the autoscaling configuration was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetAutoScalingConfigurationsAutoScalingConfigurationPolicyCapacityResult(dict):
    def __init__(__self__, *,
                 initial: _builtins.int,
                 max: _builtins.int,
                 min: _builtins.int):
        """
        :param _builtins.int initial: For a threshold-based autoscaling policy, this value is the initial number of instances to launch in the instance pool immediately after autoscaling is enabled. After autoscaling retrieves performance metrics, the number of instances is automatically adjusted from this initial number to a number that is based on the limits that you set.
        :param _builtins.int max: For a threshold-based autoscaling policy, this value is the maximum number of instances the instance pool is allowed to increase to (scale out).
        :param _builtins.int min: For a threshold-based autoscaling policy, this value is the minimum number of instances the instance pool is allowed to decrease to (scale in).
        """
        pulumi.set(__self__, "initial", initial)
        pulumi.set(__self__, "max", max)
        pulumi.set(__self__, "min", min)

    @_builtins.property
    @pulumi.getter
    def initial(self) -> _builtins.int:
        """
        For a threshold-based autoscaling policy, this value is the initial number of instances to launch in the instance pool immediately after autoscaling is enabled. After autoscaling retrieves performance metrics, the number of instances is automatically adjusted from this initial number to a number that is based on the limits that you set.
        """
        return pulumi.get(self, "initial")

    @_builtins.property
    @pulumi.getter
    def max(self) -> _builtins.int:
        """
        For a threshold-based autoscaling policy, this value is the maximum number of instances the instance pool is allowed to increase to (scale out).
        """
        return pulumi.get(self, "max")

    @_builtins.property
    @pulumi.getter
    def min(self) -> _builtins.int:
        """
        For a threshold-based autoscaling policy, this value is the minimum number of instances the instance pool is allowed to decrease to (scale in).
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class GetAutoScalingConfigurationsAutoScalingConfigurationPolicyExecutionScheduleResult(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 timezone: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str expression: A cron expression that represents the time at which to execute the autoscaling policy.
        :param _builtins.str timezone: The time zone for the execution schedule.
        :param _builtins.str type: The type of action to take.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "timezone", timezone)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        """
        A cron expression that represents the time at which to execute the autoscaling policy.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> _builtins.str:
        """
        The time zone for the execution schedule.
        """
        return pulumi.get(self, "timezone")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of action to take.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetAutoScalingConfigurationsAutoScalingConfigurationPolicyResourceActionResult(dict):
    def __init__(__self__, *,
                 action: _builtins.str,
                 action_type: _builtins.str):
        """
        :param _builtins.str action: The action to take when autoscaling is triggered.
        :param _builtins.str action_type: The type of resource action.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "action_type", action_type)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        The action to take when autoscaling is triggered.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="actionType")
    def action_type(self) -> _builtins.str:
        """
        The type of resource action.
        """
        return pulumi.get(self, "action_type")


@pulumi.output_type
class GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleResult(dict):
    def __init__(__self__, *,
                 actions: Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleActionResult'],
                 display_name: _builtins.str,
                 id: _builtins.str,
                 metrics: Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleMetricResult']):
        """
        :param Sequence['GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleActionArgs'] actions: The action to take when autoscaling is triggered.
        :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.
        :param _builtins.str id: ID of the condition that is assigned after creation.
        :param Sequence['GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleMetricArgs'] metrics: Metric and threshold details for triggering an autoscaling action.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "metrics", metrics)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleActionResult']:
        """
        The action to take when autoscaling is triggered.
        """
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the condition that is assigned after creation.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def metrics(self) -> Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleMetricResult']:
        """
        Metric and threshold details for triggering an autoscaling action.
        """
        return pulumi.get(self, "metrics")


@pulumi.output_type
class GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleActionResult(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 value: _builtins.int):
        """
        :param _builtins.str type: The type of action to take.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of action to take.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.int:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleMetricResult(dict):
    def __init__(__self__, *,
                 metric_type: _builtins.str,
                 thresholds: Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleMetricThresholdResult']):
        pulumi.set(__self__, "metric_type", metric_type)
        pulumi.set(__self__, "thresholds", thresholds)

    @_builtins.property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> _builtins.str:
        return pulumi.get(self, "metric_type")

    @_builtins.property
    @pulumi.getter
    def thresholds(self) -> Sequence['outputs.GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleMetricThresholdResult']:
        return pulumi.get(self, "thresholds")


@pulumi.output_type
class GetAutoScalingConfigurationsAutoScalingConfigurationPolicyRuleMetricThresholdResult(dict):
    def __init__(__self__, *,
                 operator: _builtins.str,
                 value: _builtins.int):
        """
        :param _builtins.str operator: The comparison operator to use. Options are greater than (`GT`), greater than or equal to (`GTE`), less than (`LT`), and less than or equal to (`LTE`).
        """
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        The comparison operator to use. Options are greater than (`GT`), greater than or equal to (`GTE`), less than (`LT`), and less than or equal to (`LTE`).
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.int:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAutoScalingConfigurationsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


