# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetInstancesResult',
    'AwaitableGetInstancesResult',
    'get_instances',
    'get_instances_output',
]

@pulumi.output_type
class GetInstancesResult:
    """
    A collection of values returned by getInstances.
    """
    def __init__(__self__, availability_domain=None, capacity_reservation_id=None, compartment_id=None, compute_cluster_id=None, display_name=None, filters=None, id=None, instances=None, state=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if capacity_reservation_id and not isinstance(capacity_reservation_id, str):
            raise TypeError("Expected argument 'capacity_reservation_id' to be a str")
        pulumi.set(__self__, "capacity_reservation_id", capacity_reservation_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_cluster_id and not isinstance(compute_cluster_id, str):
            raise TypeError("Expected argument 'compute_cluster_id' to be a str")
        pulumi.set(__self__, "compute_cluster_id", compute_cluster_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instances and not isinstance(instances, list):
            raise TypeError("Expected argument 'instances' to be a list")
        pulumi.set(__self__, "instances", instances)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[_builtins.str]:
        """
        The availability domain the instance is running in.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="capacityReservationId")
    def capacity_reservation_id(self) -> Optional[_builtins.str]:
        """
        The OCID of the compute capacity reservation this instance is launched under. When this field contains an empty string or is null, the instance is not currently in a capacity reservation. For more information, see [Capacity Reservations](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/reserve-capacity.htm#default).
        """
        return pulumi.get(self, "capacity_reservation_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment containing images to search
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="computeClusterId")
    def compute_cluster_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "compute_cluster_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetInstancesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.GetInstancesInstanceResult']:
        """
        The list of instances.
        """
        return pulumi.get(self, "instances")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the instance.
        """
        return pulumi.get(self, "state")


class AwaitableGetInstancesResult(GetInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstancesResult(
            availability_domain=self.availability_domain,
            capacity_reservation_id=self.capacity_reservation_id,
            compartment_id=self.compartment_id,
            compute_cluster_id=self.compute_cluster_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            instances=self.instances,
            state=self.state)


def get_instances(availability_domain: Optional[_builtins.str] = None,
                  capacity_reservation_id: Optional[_builtins.str] = None,
                  compartment_id: Optional[_builtins.str] = None,
                  compute_cluster_id: Optional[_builtins.str] = None,
                  display_name: Optional[_builtins.str] = None,
                  filters: Optional[Sequence[Union['GetInstancesFilterArgs', 'GetInstancesFilterArgsDict']]] = None,
                  state: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstancesResult:
    """
    This data source provides the list of Instances in Oracle Cloud Infrastructure Core service.

    Lists the instances in the specified compartment and the specified availability domain.
    You can filter the results by specifying an instance name (the list will include all the identically-named
    instances in the compartment).

    **Note:** To retrieve public and private IP addresses for an instance, use the [ListVnicAttachments](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/VnicAttachment/ListVnicAttachments)
    operation to get the VNIC ID for the instance, and then call [GetVnic](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Vnic/GetVnic) with the VNIC ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_instances = oci.Core.get_instances(compartment_id=compartment_id,
        availability_domain=instance_availability_domain,
        capacity_reservation_id=test_capacity_reservation["id"],
        compute_cluster_id=test_compute_cluster["id"],
        display_name=instance_display_name,
        state=instance_state)
    ```


    :param _builtins.str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
    :param _builtins.str capacity_reservation_id: The OCID of the compute capacity reservation.
    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str compute_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute cluster. A [compute cluster](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/compute-clusters.htm) is a remote direct memory access (RDMA) network group.
    :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.
    :param _builtins.str state: A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['capacityReservationId'] = capacity_reservation_id
    __args__['compartmentId'] = compartment_id
    __args__['computeClusterId'] = compute_cluster_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getInstances:getInstances', __args__, opts=opts, typ=GetInstancesResult).value

    return AwaitableGetInstancesResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        capacity_reservation_id=pulumi.get(__ret__, 'capacity_reservation_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compute_cluster_id=pulumi.get(__ret__, 'compute_cluster_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        instances=pulumi.get(__ret__, 'instances'),
        state=pulumi.get(__ret__, 'state'))
def get_instances_output(availability_domain: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         capacity_reservation_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                         compute_cluster_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         filters: Optional[pulumi.Input[Optional[Sequence[Union['GetInstancesFilterArgs', 'GetInstancesFilterArgsDict']]]]] = None,
                         state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInstancesResult]:
    """
    This data source provides the list of Instances in Oracle Cloud Infrastructure Core service.

    Lists the instances in the specified compartment and the specified availability domain.
    You can filter the results by specifying an instance name (the list will include all the identically-named
    instances in the compartment).

    **Note:** To retrieve public and private IP addresses for an instance, use the [ListVnicAttachments](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/VnicAttachment/ListVnicAttachments)
    operation to get the VNIC ID for the instance, and then call [GetVnic](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Vnic/GetVnic) with the VNIC ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_instances = oci.Core.get_instances(compartment_id=compartment_id,
        availability_domain=instance_availability_domain,
        capacity_reservation_id=test_capacity_reservation["id"],
        compute_cluster_id=test_compute_cluster["id"],
        display_name=instance_display_name,
        state=instance_state)
    ```


    :param _builtins.str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
    :param _builtins.str capacity_reservation_id: The OCID of the compute capacity reservation.
    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param _builtins.str compute_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute cluster. A [compute cluster](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/compute-clusters.htm) is a remote direct memory access (RDMA) network group.
    :param _builtins.str display_name: A filter to return only resources that match the given display name exactly.
    :param _builtins.str state: A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['capacityReservationId'] = capacity_reservation_id
    __args__['compartmentId'] = compartment_id
    __args__['computeClusterId'] = compute_cluster_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getInstances:getInstances', __args__, opts=opts, typ=GetInstancesResult)
    return __ret__.apply(lambda __response__: GetInstancesResult(
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        capacity_reservation_id=pulumi.get(__response__, 'capacity_reservation_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compute_cluster_id=pulumi.get(__response__, 'compute_cluster_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        instances=pulumi.get(__response__, 'instances'),
        state=pulumi.get(__response__, 'state')))
