# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDbSystemShapesResult',
    'AwaitableGetDbSystemShapesResult',
    'get_db_system_shapes',
    'get_db_system_shapes_output',
]

@pulumi.output_type
class GetDbSystemShapesResult:
    """
    A collection of values returned by getDbSystemShapes.
    """
    def __init__(__self__, availability_domain=None, compartment_id=None, db_system_shapes=None, filters=None, id=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if db_system_shapes and not isinstance(db_system_shapes, list):
            raise TypeError("Expected argument 'db_system_shapes' to be a list")
        pulumi.set(__self__, "db_system_shapes", db_system_shapes)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="dbSystemShapes")
    def db_system_shapes(self) -> Sequence['outputs.GetDbSystemShapesDbSystemShapeResult']:
        """
        The list of db_system_shapes.
        """
        return pulumi.get(self, "db_system_shapes")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDbSystemShapesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetDbSystemShapesResult(GetDbSystemShapesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbSystemShapesResult(
            availability_domain=self.availability_domain,
            compartment_id=self.compartment_id,
            db_system_shapes=self.db_system_shapes,
            filters=self.filters,
            id=self.id)


def get_db_system_shapes(availability_domain: Optional[_builtins.str] = None,
                         compartment_id: Optional[_builtins.str] = None,
                         filters: Optional[Sequence[Union['GetDbSystemShapesFilterArgs', 'GetDbSystemShapesFilterArgsDict']]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbSystemShapesResult:
    """
    This data source provides the list of Db System Shapes in Oracle Cloud Infrastructure Database service.

    Gets a list of the shapes that can be used to launch a new DB system. The shape determines resources to allocate to the DB system - CPU cores and memory for VM shapes; CPU cores, memory and storage for non-VM (or bare metal) shapes.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_system_shapes = oci.Database.get_db_system_shapes(compartment_id=compartment_id,
        availability_domain=db_system_shape_availability_domain)
    ```


    :param _builtins.str availability_domain: The name of the Availability Domain.
    :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getDbSystemShapes:getDbSystemShapes', __args__, opts=opts, typ=GetDbSystemShapesResult).value

    return AwaitableGetDbSystemShapesResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        db_system_shapes=pulumi.get(__ret__, 'db_system_shapes'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))
def get_db_system_shapes_output(availability_domain: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDbSystemShapesFilterArgs', 'GetDbSystemShapesFilterArgsDict']]]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDbSystemShapesResult]:
    """
    This data source provides the list of Db System Shapes in Oracle Cloud Infrastructure Database service.

    Gets a list of the shapes that can be used to launch a new DB system. The shape determines resources to allocate to the DB system - CPU cores and memory for VM shapes; CPU cores, memory and storage for non-VM (or bare metal) shapes.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_system_shapes = oci.Database.get_db_system_shapes(compartment_id=compartment_id,
        availability_domain=db_system_shape_availability_domain)
    ```


    :param _builtins.str availability_domain: The name of the Availability Domain.
    :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getDbSystemShapes:getDbSystemShapes', __args__, opts=opts, typ=GetDbSystemShapesResult)
    return __ret__.apply(lambda __response__: GetDbSystemShapesResult(
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        db_system_shapes=pulumi.get(__response__, 'db_system_shapes'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id')))
