# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetPluggableDatabaseResult',
    'AwaitableGetPluggableDatabaseResult',
    'get_pluggable_database',
    'get_pluggable_database_output',
]

@pulumi.output_type
class GetPluggableDatabaseResult:
    """
    A collection of values returned by getPluggableDatabase.
    """
    def __init__(__self__, compartment_id=None, connection_strings=None, container_database_admin_password=None, container_database_id=None, convert_to_regular_trigger=None, defined_tags=None, freeform_tags=None, id=None, is_restricted=None, kms_key_version_id=None, lifecycle_details=None, open_mode=None, pdb_admin_password=None, pdb_creation_type_details=None, pdb_name=None, pdb_node_level_details=None, pluggable_database_id=None, pluggable_database_management_configs=None, refresh_trigger=None, refreshable_clone_configs=None, rotate_key_trigger=None, should_create_pdb_backup=None, should_pdb_admin_account_be_locked=None, state=None, system_tags=None, tde_wallet_password=None, time_created=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if connection_strings and not isinstance(connection_strings, list):
            raise TypeError("Expected argument 'connection_strings' to be a list")
        pulumi.set(__self__, "connection_strings", connection_strings)
        if container_database_admin_password and not isinstance(container_database_admin_password, str):
            raise TypeError("Expected argument 'container_database_admin_password' to be a str")
        pulumi.set(__self__, "container_database_admin_password", container_database_admin_password)
        if container_database_id and not isinstance(container_database_id, str):
            raise TypeError("Expected argument 'container_database_id' to be a str")
        pulumi.set(__self__, "container_database_id", container_database_id)
        if convert_to_regular_trigger and not isinstance(convert_to_regular_trigger, int):
            raise TypeError("Expected argument 'convert_to_regular_trigger' to be a int")
        pulumi.set(__self__, "convert_to_regular_trigger", convert_to_regular_trigger)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_restricted and not isinstance(is_restricted, bool):
            raise TypeError("Expected argument 'is_restricted' to be a bool")
        pulumi.set(__self__, "is_restricted", is_restricted)
        if kms_key_version_id and not isinstance(kms_key_version_id, str):
            raise TypeError("Expected argument 'kms_key_version_id' to be a str")
        pulumi.set(__self__, "kms_key_version_id", kms_key_version_id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if open_mode and not isinstance(open_mode, str):
            raise TypeError("Expected argument 'open_mode' to be a str")
        pulumi.set(__self__, "open_mode", open_mode)
        if pdb_admin_password and not isinstance(pdb_admin_password, str):
            raise TypeError("Expected argument 'pdb_admin_password' to be a str")
        pulumi.set(__self__, "pdb_admin_password", pdb_admin_password)
        if pdb_creation_type_details and not isinstance(pdb_creation_type_details, list):
            raise TypeError("Expected argument 'pdb_creation_type_details' to be a list")
        pulumi.set(__self__, "pdb_creation_type_details", pdb_creation_type_details)
        if pdb_name and not isinstance(pdb_name, str):
            raise TypeError("Expected argument 'pdb_name' to be a str")
        pulumi.set(__self__, "pdb_name", pdb_name)
        if pdb_node_level_details and not isinstance(pdb_node_level_details, list):
            raise TypeError("Expected argument 'pdb_node_level_details' to be a list")
        pulumi.set(__self__, "pdb_node_level_details", pdb_node_level_details)
        if pluggable_database_id and not isinstance(pluggable_database_id, str):
            raise TypeError("Expected argument 'pluggable_database_id' to be a str")
        pulumi.set(__self__, "pluggable_database_id", pluggable_database_id)
        if pluggable_database_management_configs and not isinstance(pluggable_database_management_configs, list):
            raise TypeError("Expected argument 'pluggable_database_management_configs' to be a list")
        pulumi.set(__self__, "pluggable_database_management_configs", pluggable_database_management_configs)
        if refresh_trigger and not isinstance(refresh_trigger, int):
            raise TypeError("Expected argument 'refresh_trigger' to be a int")
        pulumi.set(__self__, "refresh_trigger", refresh_trigger)
        if refreshable_clone_configs and not isinstance(refreshable_clone_configs, list):
            raise TypeError("Expected argument 'refreshable_clone_configs' to be a list")
        pulumi.set(__self__, "refreshable_clone_configs", refreshable_clone_configs)
        if rotate_key_trigger and not isinstance(rotate_key_trigger, int):
            raise TypeError("Expected argument 'rotate_key_trigger' to be a int")
        pulumi.set(__self__, "rotate_key_trigger", rotate_key_trigger)
        if should_create_pdb_backup and not isinstance(should_create_pdb_backup, bool):
            raise TypeError("Expected argument 'should_create_pdb_backup' to be a bool")
        pulumi.set(__self__, "should_create_pdb_backup", should_create_pdb_backup)
        if should_pdb_admin_account_be_locked and not isinstance(should_pdb_admin_account_be_locked, bool):
            raise TypeError("Expected argument 'should_pdb_admin_account_be_locked' to be a bool")
        pulumi.set(__self__, "should_pdb_admin_account_be_locked", should_pdb_admin_account_be_locked)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if tde_wallet_password and not isinstance(tde_wallet_password, str):
            raise TypeError("Expected argument 'tde_wallet_password' to be a str")
        pulumi.set(__self__, "tde_wallet_password", tde_wallet_password)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> Sequence['outputs.GetPluggableDatabaseConnectionStringResult']:
        """
        Connection strings to connect to an Oracle Pluggable Database.
        """
        return pulumi.get(self, "connection_strings")

    @_builtins.property
    @pulumi.getter(name="containerDatabaseAdminPassword")
    def container_database_admin_password(self) -> _builtins.str:
        return pulumi.get(self, "container_database_admin_password")

    @_builtins.property
    @pulumi.getter(name="containerDatabaseId")
    def container_database_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the CDB.
        """
        return pulumi.get(self, "container_database_id")

    @_builtins.property
    @pulumi.getter(name="convertToRegularTrigger")
    def convert_to_regular_trigger(self) -> _builtins.int:
        return pulumi.get(self, "convert_to_regular_trigger")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the pluggable database.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isRestricted")
    def is_restricted(self) -> _builtins.bool:
        """
        The restricted mode of the pluggable database. If a pluggable database is opened in restricted mode, the user needs both create a session and have restricted session privileges to connect to it.
        """
        return pulumi.get(self, "is_restricted")

    @_builtins.property
    @pulumi.getter(name="kmsKeyVersionId")
    def kms_key_version_id(self) -> _builtins.str:
        return pulumi.get(self, "kms_key_version_id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        Detailed message for the lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="openMode")
    def open_mode(self) -> _builtins.str:
        """
        The mode that pluggable database is in. Open mode can only be changed to READ_ONLY or MIGRATE directly from the backend (within the Oracle Database software).
        """
        return pulumi.get(self, "open_mode")

    @_builtins.property
    @pulumi.getter(name="pdbAdminPassword")
    def pdb_admin_password(self) -> _builtins.str:
        return pulumi.get(self, "pdb_admin_password")

    @_builtins.property
    @pulumi.getter(name="pdbCreationTypeDetails")
    def pdb_creation_type_details(self) -> Sequence['outputs.GetPluggableDatabasePdbCreationTypeDetailResult']:
        return pulumi.get(self, "pdb_creation_type_details")

    @_builtins.property
    @pulumi.getter(name="pdbName")
    def pdb_name(self) -> _builtins.str:
        """
        The name for the pluggable database (PDB). The name is unique in the context of a [container database](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/Database/). The name must begin with an alphabetic character and can contain a maximum of thirty alphanumeric characters. Special characters are not permitted. The pluggable database name should not be same as the container database name.
        """
        return pulumi.get(self, "pdb_name")

    @_builtins.property
    @pulumi.getter(name="pdbNodeLevelDetails")
    def pdb_node_level_details(self) -> Sequence['outputs.GetPluggableDatabasePdbNodeLevelDetailResult']:
        """
        Pluggable Database Node Level Details. Example: [{"nodeName" : "node1", "openMode" : "READ_WRITE"}, {"nodeName" : "node2", "openMode" : "READ_ONLY"}]
        """
        return pulumi.get(self, "pdb_node_level_details")

    @_builtins.property
    @pulumi.getter(name="pluggableDatabaseId")
    def pluggable_database_id(self) -> _builtins.str:
        return pulumi.get(self, "pluggable_database_id")

    @_builtins.property
    @pulumi.getter(name="pluggableDatabaseManagementConfigs")
    def pluggable_database_management_configs(self) -> Sequence['outputs.GetPluggableDatabasePluggableDatabaseManagementConfigResult']:
        """
        The configuration of the Pluggable Database Management service.
        """
        return pulumi.get(self, "pluggable_database_management_configs")

    @_builtins.property
    @pulumi.getter(name="refreshTrigger")
    def refresh_trigger(self) -> _builtins.int:
        return pulumi.get(self, "refresh_trigger")

    @_builtins.property
    @pulumi.getter(name="refreshableCloneConfigs")
    def refreshable_clone_configs(self) -> Sequence['outputs.GetPluggableDatabaseRefreshableCloneConfigResult']:
        """
        Pluggable Database Refreshable Clone Configuration.
        """
        return pulumi.get(self, "refreshable_clone_configs")

    @_builtins.property
    @pulumi.getter(name="rotateKeyTrigger")
    def rotate_key_trigger(self) -> _builtins.int:
        return pulumi.get(self, "rotate_key_trigger")

    @_builtins.property
    @pulumi.getter(name="shouldCreatePdbBackup")
    def should_create_pdb_backup(self) -> _builtins.bool:
        return pulumi.get(self, "should_create_pdb_backup")

    @_builtins.property
    @pulumi.getter(name="shouldPdbAdminAccountBeLocked")
    def should_pdb_admin_account_be_locked(self) -> _builtins.bool:
        return pulumi.get(self, "should_pdb_admin_account_be_locked")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the pluggable database.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="tdeWalletPassword")
    def tde_wallet_password(self) -> _builtins.str:
        return pulumi.get(self, "tde_wallet_password")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the pluggable database was created.
        """
        return pulumi.get(self, "time_created")


class AwaitableGetPluggableDatabaseResult(GetPluggableDatabaseResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPluggableDatabaseResult(
            compartment_id=self.compartment_id,
            connection_strings=self.connection_strings,
            container_database_admin_password=self.container_database_admin_password,
            container_database_id=self.container_database_id,
            convert_to_regular_trigger=self.convert_to_regular_trigger,
            defined_tags=self.defined_tags,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_restricted=self.is_restricted,
            kms_key_version_id=self.kms_key_version_id,
            lifecycle_details=self.lifecycle_details,
            open_mode=self.open_mode,
            pdb_admin_password=self.pdb_admin_password,
            pdb_creation_type_details=self.pdb_creation_type_details,
            pdb_name=self.pdb_name,
            pdb_node_level_details=self.pdb_node_level_details,
            pluggable_database_id=self.pluggable_database_id,
            pluggable_database_management_configs=self.pluggable_database_management_configs,
            refresh_trigger=self.refresh_trigger,
            refreshable_clone_configs=self.refreshable_clone_configs,
            rotate_key_trigger=self.rotate_key_trigger,
            should_create_pdb_backup=self.should_create_pdb_backup,
            should_pdb_admin_account_be_locked=self.should_pdb_admin_account_be_locked,
            state=self.state,
            system_tags=self.system_tags,
            tde_wallet_password=self.tde_wallet_password,
            time_created=self.time_created)


def get_pluggable_database(pluggable_database_id: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPluggableDatabaseResult:
    """
    This data source provides details about a specific Pluggable Database resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified pluggable database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_pluggable_database = oci.Database.get_pluggable_database(pluggable_database_id=test_pluggable_database_oci_database_pluggable_database["id"])
    ```


    :param _builtins.str pluggable_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['pluggableDatabaseId'] = pluggable_database_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getPluggableDatabase:getPluggableDatabase', __args__, opts=opts, typ=GetPluggableDatabaseResult).value

    return AwaitableGetPluggableDatabaseResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        connection_strings=pulumi.get(__ret__, 'connection_strings'),
        container_database_admin_password=pulumi.get(__ret__, 'container_database_admin_password'),
        container_database_id=pulumi.get(__ret__, 'container_database_id'),
        convert_to_regular_trigger=pulumi.get(__ret__, 'convert_to_regular_trigger'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_restricted=pulumi.get(__ret__, 'is_restricted'),
        kms_key_version_id=pulumi.get(__ret__, 'kms_key_version_id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        open_mode=pulumi.get(__ret__, 'open_mode'),
        pdb_admin_password=pulumi.get(__ret__, 'pdb_admin_password'),
        pdb_creation_type_details=pulumi.get(__ret__, 'pdb_creation_type_details'),
        pdb_name=pulumi.get(__ret__, 'pdb_name'),
        pdb_node_level_details=pulumi.get(__ret__, 'pdb_node_level_details'),
        pluggable_database_id=pulumi.get(__ret__, 'pluggable_database_id'),
        pluggable_database_management_configs=pulumi.get(__ret__, 'pluggable_database_management_configs'),
        refresh_trigger=pulumi.get(__ret__, 'refresh_trigger'),
        refreshable_clone_configs=pulumi.get(__ret__, 'refreshable_clone_configs'),
        rotate_key_trigger=pulumi.get(__ret__, 'rotate_key_trigger'),
        should_create_pdb_backup=pulumi.get(__ret__, 'should_create_pdb_backup'),
        should_pdb_admin_account_be_locked=pulumi.get(__ret__, 'should_pdb_admin_account_be_locked'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        tde_wallet_password=pulumi.get(__ret__, 'tde_wallet_password'),
        time_created=pulumi.get(__ret__, 'time_created'))
def get_pluggable_database_output(pluggable_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPluggableDatabaseResult]:
    """
    This data source provides details about a specific Pluggable Database resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified pluggable database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_pluggable_database = oci.Database.get_pluggable_database(pluggable_database_id=test_pluggable_database_oci_database_pluggable_database["id"])
    ```


    :param _builtins.str pluggable_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['pluggableDatabaseId'] = pluggable_database_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getPluggableDatabase:getPluggableDatabase', __args__, opts=opts, typ=GetPluggableDatabaseResult)
    return __ret__.apply(lambda __response__: GetPluggableDatabaseResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        connection_strings=pulumi.get(__response__, 'connection_strings'),
        container_database_admin_password=pulumi.get(__response__, 'container_database_admin_password'),
        container_database_id=pulumi.get(__response__, 'container_database_id'),
        convert_to_regular_trigger=pulumi.get(__response__, 'convert_to_regular_trigger'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_restricted=pulumi.get(__response__, 'is_restricted'),
        kms_key_version_id=pulumi.get(__response__, 'kms_key_version_id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        open_mode=pulumi.get(__response__, 'open_mode'),
        pdb_admin_password=pulumi.get(__response__, 'pdb_admin_password'),
        pdb_creation_type_details=pulumi.get(__response__, 'pdb_creation_type_details'),
        pdb_name=pulumi.get(__response__, 'pdb_name'),
        pdb_node_level_details=pulumi.get(__response__, 'pdb_node_level_details'),
        pluggable_database_id=pulumi.get(__response__, 'pluggable_database_id'),
        pluggable_database_management_configs=pulumi.get(__response__, 'pluggable_database_management_configs'),
        refresh_trigger=pulumi.get(__response__, 'refresh_trigger'),
        refreshable_clone_configs=pulumi.get(__response__, 'refreshable_clone_configs'),
        rotate_key_trigger=pulumi.get(__response__, 'rotate_key_trigger'),
        should_create_pdb_backup=pulumi.get(__response__, 'should_create_pdb_backup'),
        should_pdb_admin_account_be_locked=pulumi.get(__response__, 'should_pdb_admin_account_be_locked'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        tde_wallet_password=pulumi.get(__response__, 'tde_wallet_password'),
        time_created=pulumi.get(__response__, 'time_created')))
