# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SensitiveDataModelArgs', 'SensitiveDataModel']

@pulumi.input_type
class SensitiveDataModelArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 target_id: pulumi.Input[_builtins.str],
                 app_suite_name: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_app_defined_relation_discovery_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_include_all_schemas: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_include_all_sensitive_types: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_sample_data_collection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 schemas_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sensitive_type_group_ids_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sensitive_type_ids_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tables_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input['SensitiveDataModelTablesForDiscoveryArgs']]]] = None):
        """
        The set of arguments for constructing a SensitiveDataModel resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment where the sensitive data model should be created.
        :param pulumi.Input[_builtins.str] target_id: (Updatable) The OCID of the reference target database to be associated with the sensitive data model. All operations such as performing data discovery and adding columns manually are done in the context of the associated target database. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] app_suite_name: (Updatable) The application suite name identifying a collection of applications. It's useful only if maintaining a sensitive data model for a suite of applications.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the sensitive data model.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the sensitive data model. The name does not have to be unique, and it's changeable.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_app_defined_relation_discovery_enabled: (Updatable) Indicates if data discovery jobs should identify potential application-level (non-dictionary) referential relationships between columns. Note that data discovery automatically identifies and adds database-level (dictionary-defined) relationships. This option helps identify application-level relationships that are not defined in the database dictionary, which in turn, helps identify additional sensitive columns and preserve referential integrity during data masking. It's disabled by default and should be used only if there is a need to identify application-level relationships.
        :param pulumi.Input[_builtins.bool] is_include_all_schemas: Indicates if all the schemas in the associated target database should be scanned by data discovery jobs. If it is set to true, sensitive data is discovered in all schemas (except for schemas maintained by Oracle).
        :param pulumi.Input[_builtins.bool] is_include_all_sensitive_types: Indicates if all the existing sensitive types should be used by data discovery jobs. If it's set to true, the sensitiveTypeIdsForDiscovery attribute is ignored and all sensitive types are used for data discovery.
        :param pulumi.Input[_builtins.bool] is_sample_data_collection_enabled: (Updatable) Indicates if data discovery jobs should collect and store sample data values for the discovered columns. Sample data helps review the discovered columns and ensure that they actually contain sensitive data. As it collects original data from the target database, it's disabled by default and should be used only if it's acceptable to store sample data in Data Safe's repository in Oracle Cloud. Note that sample data values are not collected for columns with the following data types: LONG, LOB, RAW, XMLTYPE and BFILE.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] schemas_for_discoveries: (Updatable) The schemas to be scanned by data discovery jobs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sensitive_type_group_ids_for_discoveries: (Updatable) The OCIDs of the sensitive type groups to be used by data discovery jobs. All the sensitive types present in sensitive type group will be used for discovery.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sensitive_type_ids_for_discoveries: (Updatable) The OCIDs of the sensitive types to be used by data discovery jobs. If OCID of a sensitive category is provided, all its child sensitive types are used for data discovery.
        :param pulumi.Input[Sequence[pulumi.Input['SensitiveDataModelTablesForDiscoveryArgs']]] tables_for_discoveries: (Updatable) The data discovery jobs will scan the tables specified here, including both schemas and tables. For instance, the input could be in the format: [{schemaName: "HR", tableName: ["T1", "T2"]}, {schemaName:  "OE", tableName : ["T3", "T4"]}].
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "target_id", target_id)
        if app_suite_name is not None:
            pulumi.set(__self__, "app_suite_name", app_suite_name)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_app_defined_relation_discovery_enabled is not None:
            pulumi.set(__self__, "is_app_defined_relation_discovery_enabled", is_app_defined_relation_discovery_enabled)
        if is_include_all_schemas is not None:
            pulumi.set(__self__, "is_include_all_schemas", is_include_all_schemas)
        if is_include_all_sensitive_types is not None:
            pulumi.set(__self__, "is_include_all_sensitive_types", is_include_all_sensitive_types)
        if is_sample_data_collection_enabled is not None:
            pulumi.set(__self__, "is_sample_data_collection_enabled", is_sample_data_collection_enabled)
        if schemas_for_discoveries is not None:
            pulumi.set(__self__, "schemas_for_discoveries", schemas_for_discoveries)
        if sensitive_type_group_ids_for_discoveries is not None:
            pulumi.set(__self__, "sensitive_type_group_ids_for_discoveries", sensitive_type_group_ids_for_discoveries)
        if sensitive_type_ids_for_discoveries is not None:
            pulumi.set(__self__, "sensitive_type_ids_for_discoveries", sensitive_type_ids_for_discoveries)
        if tables_for_discoveries is not None:
            pulumi.set(__self__, "tables_for_discoveries", tables_for_discoveries)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The OCID of the compartment where the sensitive data model should be created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The OCID of the reference target database to be associated with the sensitive data model. All operations such as performing data discovery and adding columns manually are done in the context of the associated target database. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_id", value)

    @_builtins.property
    @pulumi.getter(name="appSuiteName")
    def app_suite_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The application suite name identifying a collection of applications. It's useful only if maintaining a sensitive data model for a suite of applications.
        """
        return pulumi.get(self, "app_suite_name")

    @app_suite_name.setter
    def app_suite_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_suite_name", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The description of the sensitive data model.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The display name of the sensitive data model. The name does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="isAppDefinedRelationDiscoveryEnabled")
    def is_app_defined_relation_discovery_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Indicates if data discovery jobs should identify potential application-level (non-dictionary) referential relationships between columns. Note that data discovery automatically identifies and adds database-level (dictionary-defined) relationships. This option helps identify application-level relationships that are not defined in the database dictionary, which in turn, helps identify additional sensitive columns and preserve referential integrity during data masking. It's disabled by default and should be used only if there is a need to identify application-level relationships.
        """
        return pulumi.get(self, "is_app_defined_relation_discovery_enabled")

    @is_app_defined_relation_discovery_enabled.setter
    def is_app_defined_relation_discovery_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_app_defined_relation_discovery_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isIncludeAllSchemas")
    def is_include_all_schemas(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if all the schemas in the associated target database should be scanned by data discovery jobs. If it is set to true, sensitive data is discovered in all schemas (except for schemas maintained by Oracle).
        """
        return pulumi.get(self, "is_include_all_schemas")

    @is_include_all_schemas.setter
    def is_include_all_schemas(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_include_all_schemas", value)

    @_builtins.property
    @pulumi.getter(name="isIncludeAllSensitiveTypes")
    def is_include_all_sensitive_types(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if all the existing sensitive types should be used by data discovery jobs. If it's set to true, the sensitiveTypeIdsForDiscovery attribute is ignored and all sensitive types are used for data discovery.
        """
        return pulumi.get(self, "is_include_all_sensitive_types")

    @is_include_all_sensitive_types.setter
    def is_include_all_sensitive_types(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_include_all_sensitive_types", value)

    @_builtins.property
    @pulumi.getter(name="isSampleDataCollectionEnabled")
    def is_sample_data_collection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Indicates if data discovery jobs should collect and store sample data values for the discovered columns. Sample data helps review the discovered columns and ensure that they actually contain sensitive data. As it collects original data from the target database, it's disabled by default and should be used only if it's acceptable to store sample data in Data Safe's repository in Oracle Cloud. Note that sample data values are not collected for columns with the following data types: LONG, LOB, RAW, XMLTYPE and BFILE.
        """
        return pulumi.get(self, "is_sample_data_collection_enabled")

    @is_sample_data_collection_enabled.setter
    def is_sample_data_collection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_sample_data_collection_enabled", value)

    @_builtins.property
    @pulumi.getter(name="schemasForDiscoveries")
    def schemas_for_discoveries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) The schemas to be scanned by data discovery jobs.
        """
        return pulumi.get(self, "schemas_for_discoveries")

    @schemas_for_discoveries.setter
    def schemas_for_discoveries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "schemas_for_discoveries", value)

    @_builtins.property
    @pulumi.getter(name="sensitiveTypeGroupIdsForDiscoveries")
    def sensitive_type_group_ids_for_discoveries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) The OCIDs of the sensitive type groups to be used by data discovery jobs. All the sensitive types present in sensitive type group will be used for discovery.
        """
        return pulumi.get(self, "sensitive_type_group_ids_for_discoveries")

    @sensitive_type_group_ids_for_discoveries.setter
    def sensitive_type_group_ids_for_discoveries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sensitive_type_group_ids_for_discoveries", value)

    @_builtins.property
    @pulumi.getter(name="sensitiveTypeIdsForDiscoveries")
    def sensitive_type_ids_for_discoveries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) The OCIDs of the sensitive types to be used by data discovery jobs. If OCID of a sensitive category is provided, all its child sensitive types are used for data discovery.
        """
        return pulumi.get(self, "sensitive_type_ids_for_discoveries")

    @sensitive_type_ids_for_discoveries.setter
    def sensitive_type_ids_for_discoveries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sensitive_type_ids_for_discoveries", value)

    @_builtins.property
    @pulumi.getter(name="tablesForDiscoveries")
    def tables_for_discoveries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SensitiveDataModelTablesForDiscoveryArgs']]]]:
        """
        (Updatable) The data discovery jobs will scan the tables specified here, including both schemas and tables. For instance, the input could be in the format: [{schemaName: "HR", tableName: ["T1", "T2"]}, {schemaName:  "OE", tableName : ["T3", "T4"]}].
        """
        return pulumi.get(self, "tables_for_discoveries")

    @tables_for_discoveries.setter
    def tables_for_discoveries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SensitiveDataModelTablesForDiscoveryArgs']]]]):
        pulumi.set(self, "tables_for_discoveries", value)


@pulumi.input_type
class _SensitiveDataModelState:
    def __init__(__self__, *,
                 app_suite_name: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_app_defined_relation_discovery_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_include_all_schemas: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_include_all_sensitive_types: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_sample_data_collection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 schemas_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sensitive_type_group_ids_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sensitive_type_ids_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tables_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input['SensitiveDataModelTablesForDiscoveryArgs']]]] = None,
                 target_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SensitiveDataModel resources.
        :param pulumi.Input[_builtins.str] app_suite_name: (Updatable) The application suite name identifying a collection of applications. It's useful only if maintaining a sensitive data model for a suite of applications.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment where the sensitive data model should be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the sensitive data model.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the sensitive data model. The name does not have to be unique, and it's changeable.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_app_defined_relation_discovery_enabled: (Updatable) Indicates if data discovery jobs should identify potential application-level (non-dictionary) referential relationships between columns. Note that data discovery automatically identifies and adds database-level (dictionary-defined) relationships. This option helps identify application-level relationships that are not defined in the database dictionary, which in turn, helps identify additional sensitive columns and preserve referential integrity during data masking. It's disabled by default and should be used only if there is a need to identify application-level relationships.
        :param pulumi.Input[_builtins.bool] is_include_all_schemas: Indicates if all the schemas in the associated target database should be scanned by data discovery jobs. If it is set to true, sensitive data is discovered in all schemas (except for schemas maintained by Oracle).
        :param pulumi.Input[_builtins.bool] is_include_all_sensitive_types: Indicates if all the existing sensitive types should be used by data discovery jobs. If it's set to true, the sensitiveTypeIdsForDiscovery attribute is ignored and all sensitive types are used for data discovery.
        :param pulumi.Input[_builtins.bool] is_sample_data_collection_enabled: (Updatable) Indicates if data discovery jobs should collect and store sample data values for the discovered columns. Sample data helps review the discovered columns and ensure that they actually contain sensitive data. As it collects original data from the target database, it's disabled by default and should be used only if it's acceptable to store sample data in Data Safe's repository in Oracle Cloud. Note that sample data values are not collected for columns with the following data types: LONG, LOB, RAW, XMLTYPE and BFILE.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] schemas_for_discoveries: (Updatable) The schemas to be scanned by data discovery jobs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sensitive_type_group_ids_for_discoveries: (Updatable) The OCIDs of the sensitive type groups to be used by data discovery jobs. All the sensitive types present in sensitive type group will be used for discovery.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sensitive_type_ids_for_discoveries: (Updatable) The OCIDs of the sensitive types to be used by data discovery jobs. If OCID of a sensitive category is provided, all its child sensitive types are used for data discovery.
        :param pulumi.Input[_builtins.str] state: The current state of the sensitive data model.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[Sequence[pulumi.Input['SensitiveDataModelTablesForDiscoveryArgs']]] tables_for_discoveries: (Updatable) The data discovery jobs will scan the tables specified here, including both schemas and tables. For instance, the input could be in the format: [{schemaName: "HR", tableName: ["T1", "T2"]}, {schemaName:  "OE", tableName : ["T3", "T4"]}].
        :param pulumi.Input[_builtins.str] target_id: (Updatable) The OCID of the reference target database to be associated with the sensitive data model. All operations such as performing data discovery and adding columns manually are done in the context of the associated target database. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] time_created: The date and time the sensitive data model was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[_builtins.str] time_updated: The date and time the sensitive data model was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        if app_suite_name is not None:
            pulumi.set(__self__, "app_suite_name", app_suite_name)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_app_defined_relation_discovery_enabled is not None:
            pulumi.set(__self__, "is_app_defined_relation_discovery_enabled", is_app_defined_relation_discovery_enabled)
        if is_include_all_schemas is not None:
            pulumi.set(__self__, "is_include_all_schemas", is_include_all_schemas)
        if is_include_all_sensitive_types is not None:
            pulumi.set(__self__, "is_include_all_sensitive_types", is_include_all_sensitive_types)
        if is_sample_data_collection_enabled is not None:
            pulumi.set(__self__, "is_sample_data_collection_enabled", is_sample_data_collection_enabled)
        if schemas_for_discoveries is not None:
            pulumi.set(__self__, "schemas_for_discoveries", schemas_for_discoveries)
        if sensitive_type_group_ids_for_discoveries is not None:
            pulumi.set(__self__, "sensitive_type_group_ids_for_discoveries", sensitive_type_group_ids_for_discoveries)
        if sensitive_type_ids_for_discoveries is not None:
            pulumi.set(__self__, "sensitive_type_ids_for_discoveries", sensitive_type_ids_for_discoveries)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if tables_for_discoveries is not None:
            pulumi.set(__self__, "tables_for_discoveries", tables_for_discoveries)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="appSuiteName")
    def app_suite_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The application suite name identifying a collection of applications. It's useful only if maintaining a sensitive data model for a suite of applications.
        """
        return pulumi.get(self, "app_suite_name")

    @app_suite_name.setter
    def app_suite_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_suite_name", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The OCID of the compartment where the sensitive data model should be created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The description of the sensitive data model.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The display name of the sensitive data model. The name does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="isAppDefinedRelationDiscoveryEnabled")
    def is_app_defined_relation_discovery_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Indicates if data discovery jobs should identify potential application-level (non-dictionary) referential relationships between columns. Note that data discovery automatically identifies and adds database-level (dictionary-defined) relationships. This option helps identify application-level relationships that are not defined in the database dictionary, which in turn, helps identify additional sensitive columns and preserve referential integrity during data masking. It's disabled by default and should be used only if there is a need to identify application-level relationships.
        """
        return pulumi.get(self, "is_app_defined_relation_discovery_enabled")

    @is_app_defined_relation_discovery_enabled.setter
    def is_app_defined_relation_discovery_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_app_defined_relation_discovery_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isIncludeAllSchemas")
    def is_include_all_schemas(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if all the schemas in the associated target database should be scanned by data discovery jobs. If it is set to true, sensitive data is discovered in all schemas (except for schemas maintained by Oracle).
        """
        return pulumi.get(self, "is_include_all_schemas")

    @is_include_all_schemas.setter
    def is_include_all_schemas(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_include_all_schemas", value)

    @_builtins.property
    @pulumi.getter(name="isIncludeAllSensitiveTypes")
    def is_include_all_sensitive_types(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if all the existing sensitive types should be used by data discovery jobs. If it's set to true, the sensitiveTypeIdsForDiscovery attribute is ignored and all sensitive types are used for data discovery.
        """
        return pulumi.get(self, "is_include_all_sensitive_types")

    @is_include_all_sensitive_types.setter
    def is_include_all_sensitive_types(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_include_all_sensitive_types", value)

    @_builtins.property
    @pulumi.getter(name="isSampleDataCollectionEnabled")
    def is_sample_data_collection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Indicates if data discovery jobs should collect and store sample data values for the discovered columns. Sample data helps review the discovered columns and ensure that they actually contain sensitive data. As it collects original data from the target database, it's disabled by default and should be used only if it's acceptable to store sample data in Data Safe's repository in Oracle Cloud. Note that sample data values are not collected for columns with the following data types: LONG, LOB, RAW, XMLTYPE and BFILE.
        """
        return pulumi.get(self, "is_sample_data_collection_enabled")

    @is_sample_data_collection_enabled.setter
    def is_sample_data_collection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_sample_data_collection_enabled", value)

    @_builtins.property
    @pulumi.getter(name="schemasForDiscoveries")
    def schemas_for_discoveries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) The schemas to be scanned by data discovery jobs.
        """
        return pulumi.get(self, "schemas_for_discoveries")

    @schemas_for_discoveries.setter
    def schemas_for_discoveries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "schemas_for_discoveries", value)

    @_builtins.property
    @pulumi.getter(name="sensitiveTypeGroupIdsForDiscoveries")
    def sensitive_type_group_ids_for_discoveries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) The OCIDs of the sensitive type groups to be used by data discovery jobs. All the sensitive types present in sensitive type group will be used for discovery.
        """
        return pulumi.get(self, "sensitive_type_group_ids_for_discoveries")

    @sensitive_type_group_ids_for_discoveries.setter
    def sensitive_type_group_ids_for_discoveries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sensitive_type_group_ids_for_discoveries", value)

    @_builtins.property
    @pulumi.getter(name="sensitiveTypeIdsForDiscoveries")
    def sensitive_type_ids_for_discoveries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) The OCIDs of the sensitive types to be used by data discovery jobs. If OCID of a sensitive category is provided, all its child sensitive types are used for data discovery.
        """
        return pulumi.get(self, "sensitive_type_ids_for_discoveries")

    @sensitive_type_ids_for_discoveries.setter
    def sensitive_type_ids_for_discoveries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sensitive_type_ids_for_discoveries", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the sensitive data model.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="tablesForDiscoveries")
    def tables_for_discoveries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SensitiveDataModelTablesForDiscoveryArgs']]]]:
        """
        (Updatable) The data discovery jobs will scan the tables specified here, including both schemas and tables. For instance, the input could be in the format: [{schemaName: "HR", tableName: ["T1", "T2"]}, {schemaName:  "OE", tableName : ["T3", "T4"]}].
        """
        return pulumi.get(self, "tables_for_discoveries")

    @tables_for_discoveries.setter
    def tables_for_discoveries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SensitiveDataModelTablesForDiscoveryArgs']]]]):
        pulumi.set(self, "tables_for_discoveries", value)

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The OCID of the reference target database to be associated with the sensitive data model. All operations such as performing data discovery and adding columns manually are done in the context of the associated target database. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_id", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the sensitive data model was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the sensitive data model was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:DataSafe/sensitiveDataModel:SensitiveDataModel")
class SensitiveDataModel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_suite_name: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_app_defined_relation_discovery_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_include_all_schemas: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_include_all_sensitive_types: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_sample_data_collection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 schemas_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sensitive_type_group_ids_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sensitive_type_ids_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tables_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SensitiveDataModelTablesForDiscoveryArgs', 'SensitiveDataModelTablesForDiscoveryArgsDict']]]]] = None,
                 target_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Sensitive Data Model resource in Oracle Cloud Infrastructure Data Safe service.

        Creates a new sensitive data model. If schemas and sensitive types are provided, it automatically runs data discovery
        and adds the discovered columns to the sensitive data model. Otherwise, it creates an empty sensitive data model
        that can be updated later.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_sensitive_data_model = oci.datasafe.SensitiveDataModel("test_sensitive_data_model",
            compartment_id=compartment_id,
            target_id=test_target["id"],
            app_suite_name=sensitive_data_model_app_suite_name,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=sensitive_data_model_description,
            display_name=sensitive_data_model_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            is_app_defined_relation_discovery_enabled=sensitive_data_model_is_app_defined_relation_discovery_enabled,
            is_include_all_schemas=sensitive_data_model_is_include_all_schemas,
            is_include_all_sensitive_types=sensitive_data_model_is_include_all_sensitive_types,
            is_sample_data_collection_enabled=sensitive_data_model_is_sample_data_collection_enabled,
            schemas_for_discoveries=sensitive_data_model_schemas_for_discovery,
            sensitive_type_group_ids_for_discoveries=sensitive_data_model_sensitive_type_group_ids_for_discovery,
            sensitive_type_ids_for_discoveries=sensitive_data_model_sensitive_type_ids_for_discovery,
            tables_for_discoveries=[{
                "schema_name": sensitive_data_model_tables_for_discovery_schema_name,
                "table_names": sensitive_data_model_tables_for_discovery_table_names,
            }])
        ```

        ## Import

        SensitiveDataModels can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/sensitiveDataModel:SensitiveDataModel test_sensitive_data_model "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_suite_name: (Updatable) The application suite name identifying a collection of applications. It's useful only if maintaining a sensitive data model for a suite of applications.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment where the sensitive data model should be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the sensitive data model.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the sensitive data model. The name does not have to be unique, and it's changeable.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_app_defined_relation_discovery_enabled: (Updatable) Indicates if data discovery jobs should identify potential application-level (non-dictionary) referential relationships between columns. Note that data discovery automatically identifies and adds database-level (dictionary-defined) relationships. This option helps identify application-level relationships that are not defined in the database dictionary, which in turn, helps identify additional sensitive columns and preserve referential integrity during data masking. It's disabled by default and should be used only if there is a need to identify application-level relationships.
        :param pulumi.Input[_builtins.bool] is_include_all_schemas: Indicates if all the schemas in the associated target database should be scanned by data discovery jobs. If it is set to true, sensitive data is discovered in all schemas (except for schemas maintained by Oracle).
        :param pulumi.Input[_builtins.bool] is_include_all_sensitive_types: Indicates if all the existing sensitive types should be used by data discovery jobs. If it's set to true, the sensitiveTypeIdsForDiscovery attribute is ignored and all sensitive types are used for data discovery.
        :param pulumi.Input[_builtins.bool] is_sample_data_collection_enabled: (Updatable) Indicates if data discovery jobs should collect and store sample data values for the discovered columns. Sample data helps review the discovered columns and ensure that they actually contain sensitive data. As it collects original data from the target database, it's disabled by default and should be used only if it's acceptable to store sample data in Data Safe's repository in Oracle Cloud. Note that sample data values are not collected for columns with the following data types: LONG, LOB, RAW, XMLTYPE and BFILE.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] schemas_for_discoveries: (Updatable) The schemas to be scanned by data discovery jobs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sensitive_type_group_ids_for_discoveries: (Updatable) The OCIDs of the sensitive type groups to be used by data discovery jobs. All the sensitive types present in sensitive type group will be used for discovery.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sensitive_type_ids_for_discoveries: (Updatable) The OCIDs of the sensitive types to be used by data discovery jobs. If OCID of a sensitive category is provided, all its child sensitive types are used for data discovery.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SensitiveDataModelTablesForDiscoveryArgs', 'SensitiveDataModelTablesForDiscoveryArgsDict']]]] tables_for_discoveries: (Updatable) The data discovery jobs will scan the tables specified here, including both schemas and tables. For instance, the input could be in the format: [{schemaName: "HR", tableName: ["T1", "T2"]}, {schemaName:  "OE", tableName : ["T3", "T4"]}].
        :param pulumi.Input[_builtins.str] target_id: (Updatable) The OCID of the reference target database to be associated with the sensitive data model. All operations such as performing data discovery and adding columns manually are done in the context of the associated target database. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SensitiveDataModelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Sensitive Data Model resource in Oracle Cloud Infrastructure Data Safe service.

        Creates a new sensitive data model. If schemas and sensitive types are provided, it automatically runs data discovery
        and adds the discovered columns to the sensitive data model. Otherwise, it creates an empty sensitive data model
        that can be updated later.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_sensitive_data_model = oci.datasafe.SensitiveDataModel("test_sensitive_data_model",
            compartment_id=compartment_id,
            target_id=test_target["id"],
            app_suite_name=sensitive_data_model_app_suite_name,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=sensitive_data_model_description,
            display_name=sensitive_data_model_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            is_app_defined_relation_discovery_enabled=sensitive_data_model_is_app_defined_relation_discovery_enabled,
            is_include_all_schemas=sensitive_data_model_is_include_all_schemas,
            is_include_all_sensitive_types=sensitive_data_model_is_include_all_sensitive_types,
            is_sample_data_collection_enabled=sensitive_data_model_is_sample_data_collection_enabled,
            schemas_for_discoveries=sensitive_data_model_schemas_for_discovery,
            sensitive_type_group_ids_for_discoveries=sensitive_data_model_sensitive_type_group_ids_for_discovery,
            sensitive_type_ids_for_discoveries=sensitive_data_model_sensitive_type_ids_for_discovery,
            tables_for_discoveries=[{
                "schema_name": sensitive_data_model_tables_for_discovery_schema_name,
                "table_names": sensitive_data_model_tables_for_discovery_table_names,
            }])
        ```

        ## Import

        SensitiveDataModels can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/sensitiveDataModel:SensitiveDataModel test_sensitive_data_model "id"
        ```

        :param str resource_name: The name of the resource.
        :param SensitiveDataModelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SensitiveDataModelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_suite_name: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_app_defined_relation_discovery_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_include_all_schemas: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_include_all_sensitive_types: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_sample_data_collection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 schemas_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sensitive_type_group_ids_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sensitive_type_ids_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tables_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SensitiveDataModelTablesForDiscoveryArgs', 'SensitiveDataModelTablesForDiscoveryArgsDict']]]]] = None,
                 target_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SensitiveDataModelArgs.__new__(SensitiveDataModelArgs)

            __props__.__dict__["app_suite_name"] = app_suite_name
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_app_defined_relation_discovery_enabled"] = is_app_defined_relation_discovery_enabled
            __props__.__dict__["is_include_all_schemas"] = is_include_all_schemas
            __props__.__dict__["is_include_all_sensitive_types"] = is_include_all_sensitive_types
            __props__.__dict__["is_sample_data_collection_enabled"] = is_sample_data_collection_enabled
            __props__.__dict__["schemas_for_discoveries"] = schemas_for_discoveries
            __props__.__dict__["sensitive_type_group_ids_for_discoveries"] = sensitive_type_group_ids_for_discoveries
            __props__.__dict__["sensitive_type_ids_for_discoveries"] = sensitive_type_ids_for_discoveries
            __props__.__dict__["tables_for_discoveries"] = tables_for_discoveries
            if target_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_id'")
            __props__.__dict__["target_id"] = target_id
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(SensitiveDataModel, __self__).__init__(
            'oci:DataSafe/sensitiveDataModel:SensitiveDataModel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_suite_name: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            is_app_defined_relation_discovery_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            is_include_all_schemas: Optional[pulumi.Input[_builtins.bool]] = None,
            is_include_all_sensitive_types: Optional[pulumi.Input[_builtins.bool]] = None,
            is_sample_data_collection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            schemas_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            sensitive_type_group_ids_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            sensitive_type_ids_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tables_for_discoveries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SensitiveDataModelTablesForDiscoveryArgs', 'SensitiveDataModelTablesForDiscoveryArgsDict']]]]] = None,
            target_id: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'SensitiveDataModel':
        """
        Get an existing SensitiveDataModel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_suite_name: (Updatable) The application suite name identifying a collection of applications. It's useful only if maintaining a sensitive data model for a suite of applications.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment where the sensitive data model should be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) The description of the sensitive data model.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) The display name of the sensitive data model. The name does not have to be unique, and it's changeable.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.bool] is_app_defined_relation_discovery_enabled: (Updatable) Indicates if data discovery jobs should identify potential application-level (non-dictionary) referential relationships between columns. Note that data discovery automatically identifies and adds database-level (dictionary-defined) relationships. This option helps identify application-level relationships that are not defined in the database dictionary, which in turn, helps identify additional sensitive columns and preserve referential integrity during data masking. It's disabled by default and should be used only if there is a need to identify application-level relationships.
        :param pulumi.Input[_builtins.bool] is_include_all_schemas: Indicates if all the schemas in the associated target database should be scanned by data discovery jobs. If it is set to true, sensitive data is discovered in all schemas (except for schemas maintained by Oracle).
        :param pulumi.Input[_builtins.bool] is_include_all_sensitive_types: Indicates if all the existing sensitive types should be used by data discovery jobs. If it's set to true, the sensitiveTypeIdsForDiscovery attribute is ignored and all sensitive types are used for data discovery.
        :param pulumi.Input[_builtins.bool] is_sample_data_collection_enabled: (Updatable) Indicates if data discovery jobs should collect and store sample data values for the discovered columns. Sample data helps review the discovered columns and ensure that they actually contain sensitive data. As it collects original data from the target database, it's disabled by default and should be used only if it's acceptable to store sample data in Data Safe's repository in Oracle Cloud. Note that sample data values are not collected for columns with the following data types: LONG, LOB, RAW, XMLTYPE and BFILE.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] schemas_for_discoveries: (Updatable) The schemas to be scanned by data discovery jobs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sensitive_type_group_ids_for_discoveries: (Updatable) The OCIDs of the sensitive type groups to be used by data discovery jobs. All the sensitive types present in sensitive type group will be used for discovery.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] sensitive_type_ids_for_discoveries: (Updatable) The OCIDs of the sensitive types to be used by data discovery jobs. If OCID of a sensitive category is provided, all its child sensitive types are used for data discovery.
        :param pulumi.Input[_builtins.str] state: The current state of the sensitive data model.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['SensitiveDataModelTablesForDiscoveryArgs', 'SensitiveDataModelTablesForDiscoveryArgsDict']]]] tables_for_discoveries: (Updatable) The data discovery jobs will scan the tables specified here, including both schemas and tables. For instance, the input could be in the format: [{schemaName: "HR", tableName: ["T1", "T2"]}, {schemaName:  "OE", tableName : ["T3", "T4"]}].
        :param pulumi.Input[_builtins.str] target_id: (Updatable) The OCID of the reference target database to be associated with the sensitive data model. All operations such as performing data discovery and adding columns manually are done in the context of the associated target database. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] time_created: The date and time the sensitive data model was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[_builtins.str] time_updated: The date and time the sensitive data model was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SensitiveDataModelState.__new__(_SensitiveDataModelState)

        __props__.__dict__["app_suite_name"] = app_suite_name
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_app_defined_relation_discovery_enabled"] = is_app_defined_relation_discovery_enabled
        __props__.__dict__["is_include_all_schemas"] = is_include_all_schemas
        __props__.__dict__["is_include_all_sensitive_types"] = is_include_all_sensitive_types
        __props__.__dict__["is_sample_data_collection_enabled"] = is_sample_data_collection_enabled
        __props__.__dict__["schemas_for_discoveries"] = schemas_for_discoveries
        __props__.__dict__["sensitive_type_group_ids_for_discoveries"] = sensitive_type_group_ids_for_discoveries
        __props__.__dict__["sensitive_type_ids_for_discoveries"] = sensitive_type_ids_for_discoveries
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["tables_for_discoveries"] = tables_for_discoveries
        __props__.__dict__["target_id"] = target_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return SensitiveDataModel(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="appSuiteName")
    def app_suite_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The application suite name identifying a collection of applications. It's useful only if maintaining a sensitive data model for a suite of applications.
        """
        return pulumi.get(self, "app_suite_name")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The OCID of the compartment where the sensitive data model should be created.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The description of the sensitive data model.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The display name of the sensitive data model. The name does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="isAppDefinedRelationDiscoveryEnabled")
    def is_app_defined_relation_discovery_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Indicates if data discovery jobs should identify potential application-level (non-dictionary) referential relationships between columns. Note that data discovery automatically identifies and adds database-level (dictionary-defined) relationships. This option helps identify application-level relationships that are not defined in the database dictionary, which in turn, helps identify additional sensitive columns and preserve referential integrity during data masking. It's disabled by default and should be used only if there is a need to identify application-level relationships.
        """
        return pulumi.get(self, "is_app_defined_relation_discovery_enabled")

    @_builtins.property
    @pulumi.getter(name="isIncludeAllSchemas")
    def is_include_all_schemas(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates if all the schemas in the associated target database should be scanned by data discovery jobs. If it is set to true, sensitive data is discovered in all schemas (except for schemas maintained by Oracle).
        """
        return pulumi.get(self, "is_include_all_schemas")

    @_builtins.property
    @pulumi.getter(name="isIncludeAllSensitiveTypes")
    def is_include_all_sensitive_types(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates if all the existing sensitive types should be used by data discovery jobs. If it's set to true, the sensitiveTypeIdsForDiscovery attribute is ignored and all sensitive types are used for data discovery.
        """
        return pulumi.get(self, "is_include_all_sensitive_types")

    @_builtins.property
    @pulumi.getter(name="isSampleDataCollectionEnabled")
    def is_sample_data_collection_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Indicates if data discovery jobs should collect and store sample data values for the discovered columns. Sample data helps review the discovered columns and ensure that they actually contain sensitive data. As it collects original data from the target database, it's disabled by default and should be used only if it's acceptable to store sample data in Data Safe's repository in Oracle Cloud. Note that sample data values are not collected for columns with the following data types: LONG, LOB, RAW, XMLTYPE and BFILE.
        """
        return pulumi.get(self, "is_sample_data_collection_enabled")

    @_builtins.property
    @pulumi.getter(name="schemasForDiscoveries")
    def schemas_for_discoveries(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        (Updatable) The schemas to be scanned by data discovery jobs.
        """
        return pulumi.get(self, "schemas_for_discoveries")

    @_builtins.property
    @pulumi.getter(name="sensitiveTypeGroupIdsForDiscoveries")
    def sensitive_type_group_ids_for_discoveries(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        (Updatable) The OCIDs of the sensitive type groups to be used by data discovery jobs. All the sensitive types present in sensitive type group will be used for discovery.
        """
        return pulumi.get(self, "sensitive_type_group_ids_for_discoveries")

    @_builtins.property
    @pulumi.getter(name="sensitiveTypeIdsForDiscoveries")
    def sensitive_type_ids_for_discoveries(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        (Updatable) The OCIDs of the sensitive types to be used by data discovery jobs. If OCID of a sensitive category is provided, all its child sensitive types are used for data discovery.
        """
        return pulumi.get(self, "sensitive_type_ids_for_discoveries")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the sensitive data model.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="tablesForDiscoveries")
    def tables_for_discoveries(self) -> pulumi.Output[Sequence['outputs.SensitiveDataModelTablesForDiscovery']]:
        """
        (Updatable) The data discovery jobs will scan the tables specified here, including both schemas and tables. For instance, the input could be in the format: [{schemaName: "HR", tableName: ["T1", "T2"]}, {schemaName:  "OE", tableName : ["T3", "T4"]}].
        """
        return pulumi.get(self, "tables_for_discoveries")

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The OCID of the reference target database to be associated with the sensitive data model. All operations such as performing data discovery and adding columns manually are done in the context of the associated target database. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "target_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the sensitive data model was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the sensitive data model was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

