# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetOnboardingsResult',
    'AwaitableGetOnboardingsResult',
    'get_onboardings',
    'get_onboardings_output',
]

@pulumi.output_type
class GetOnboardingsResult:
    """
    A collection of values returned by getOnboardings.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, onboarding_collections=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if onboarding_collections and not isinstance(onboarding_collections, list):
            raise TypeError("Expected argument 'onboarding_collections' to be a list")
        pulumi.set(__self__, "onboarding_collections", onboarding_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        Tenancy OCID
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetOnboardingsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The unique id of the resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="onboardingCollections")
    def onboarding_collections(self) -> Sequence['outputs.GetOnboardingsOnboardingCollectionResult']:
        """
        The list of onboarding_collection.
        """
        return pulumi.get(self, "onboarding_collections")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the Onboarding.
        """
        return pulumi.get(self, "state")


class AwaitableGetOnboardingsResult(GetOnboardingsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOnboardingsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            onboarding_collections=self.onboarding_collections,
            state=self.state)


def get_onboardings(compartment_id: Optional[_builtins.str] = None,
                    filters: Optional[Sequence[Union['GetOnboardingsFilterArgs', 'GetOnboardingsFilterArgsDict']]] = None,
                    id: Optional[_builtins.str] = None,
                    state: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOnboardingsResult:
    """
    This data source provides the list of Onboardings in Oracle Cloud Infrastructure Fleet Apps Management service.

    Returns a list of all the onboardings in the specified root compartment (tenancy).
    The query parameter `compartmentId` is required unless the query parameter `id` is specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_onboardings = oci.FleetAppsManagement.get_onboardings(compartment_id=compartment_id,
        id=onboarding_id,
        state=onboarding_state)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources. Empty only if the resource OCID query param is not specified.
    :param _builtins.str id: Unique identifier or OCID for listing a single onboarding by id. Either compartmentId or id must be provided.
    :param _builtins.str state: A filter to return only resources whose lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getOnboardings:getOnboardings', __args__, opts=opts, typ=GetOnboardingsResult).value

    return AwaitableGetOnboardingsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        onboarding_collections=pulumi.get(__ret__, 'onboarding_collections'),
        state=pulumi.get(__ret__, 'state'))
def get_onboardings_output(compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           filters: Optional[pulumi.Input[Optional[Sequence[Union['GetOnboardingsFilterArgs', 'GetOnboardingsFilterArgsDict']]]]] = None,
                           id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOnboardingsResult]:
    """
    This data source provides the list of Onboardings in Oracle Cloud Infrastructure Fleet Apps Management service.

    Returns a list of all the onboardings in the specified root compartment (tenancy).
    The query parameter `compartmentId` is required unless the query parameter `id` is specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_onboardings = oci.FleetAppsManagement.get_onboardings(compartment_id=compartment_id,
        id=onboarding_id,
        state=onboarding_state)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources. Empty only if the resource OCID query param is not specified.
    :param _builtins.str id: Unique identifier or OCID for listing a single onboarding by id. Either compartmentId or id must be provided.
    :param _builtins.str state: A filter to return only resources whose lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getOnboardings:getOnboardings', __args__, opts=opts, typ=GetOnboardingsResult)
    return __ret__.apply(lambda __response__: GetOnboardingsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        onboarding_collections=pulumi.get(__response__, 'onboarding_collections'),
        state=pulumi.get(__response__, 'state')))
