# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSchedulerDefinitionsResult',
    'AwaitableGetSchedulerDefinitionsResult',
    'get_scheduler_definitions',
    'get_scheduler_definitions_output',
]

@pulumi.output_type
class GetSchedulerDefinitionsResult:
    """
    A collection of values returned by getSchedulerDefinitions.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, fleet_id=None, id=None, maintenance_window_id=None, product=None, runbook_id=None, runbook_version_name=None, scheduler_definition_collections=None, state=None, time_scheduled_greater_than_or_equal_to=None, time_scheduled_less_than=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if maintenance_window_id and not isinstance(maintenance_window_id, str):
            raise TypeError("Expected argument 'maintenance_window_id' to be a str")
        pulumi.set(__self__, "maintenance_window_id", maintenance_window_id)
        if product and not isinstance(product, str):
            raise TypeError("Expected argument 'product' to be a str")
        pulumi.set(__self__, "product", product)
        if runbook_id and not isinstance(runbook_id, str):
            raise TypeError("Expected argument 'runbook_id' to be a str")
        pulumi.set(__self__, "runbook_id", runbook_id)
        if runbook_version_name and not isinstance(runbook_version_name, str):
            raise TypeError("Expected argument 'runbook_version_name' to be a str")
        pulumi.set(__self__, "runbook_version_name", runbook_version_name)
        if scheduler_definition_collections and not isinstance(scheduler_definition_collections, list):
            raise TypeError("Expected argument 'scheduler_definition_collections' to be a list")
        pulumi.set(__self__, "scheduler_definition_collections", scheduler_definition_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_scheduled_greater_than_or_equal_to and not isinstance(time_scheduled_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_scheduled_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_scheduled_greater_than_or_equal_to", time_scheduled_greater_than_or_equal_to)
        if time_scheduled_less_than and not isinstance(time_scheduled_less_than, str):
            raise TypeError("Expected argument 'time_scheduled_less_than' to be a str")
        pulumi.set(__self__, "time_scheduled_less_than", time_scheduled_less_than)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        Compartment OCID
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSchedulerDefinitionsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> Optional[_builtins.str]:
        """
        ID of the fleet
        """
        return pulumi.get(self, "fleet_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The OCID of the resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindowId")
    def maintenance_window_id(self) -> Optional[_builtins.str]:
        """
        Provide MaintenanceWindowId
        """
        return pulumi.get(self, "maintenance_window_id")

    @_builtins.property
    @pulumi.getter
    def product(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "product")

    @_builtins.property
    @pulumi.getter(name="runbookId")
    def runbook_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Runbook
        """
        return pulumi.get(self, "runbook_id")

    @_builtins.property
    @pulumi.getter(name="runbookVersionName")
    def runbook_version_name(self) -> Optional[_builtins.str]:
        """
        The runbook version name
        """
        return pulumi.get(self, "runbook_version_name")

    @_builtins.property
    @pulumi.getter(name="schedulerDefinitionCollections")
    def scheduler_definition_collections(self) -> Sequence['outputs.GetSchedulerDefinitionsSchedulerDefinitionCollectionResult']:
        """
        The list of scheduler_definition_collection.
        """
        return pulumi.get(self, "scheduler_definition_collections")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the SchedulerDefinition.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeScheduledGreaterThanOrEqualTo")
    def time_scheduled_greater_than_or_equal_to(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "time_scheduled_greater_than_or_equal_to")

    @_builtins.property
    @pulumi.getter(name="timeScheduledLessThan")
    def time_scheduled_less_than(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "time_scheduled_less_than")


class AwaitableGetSchedulerDefinitionsResult(GetSchedulerDefinitionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSchedulerDefinitionsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            fleet_id=self.fleet_id,
            id=self.id,
            maintenance_window_id=self.maintenance_window_id,
            product=self.product,
            runbook_id=self.runbook_id,
            runbook_version_name=self.runbook_version_name,
            scheduler_definition_collections=self.scheduler_definition_collections,
            state=self.state,
            time_scheduled_greater_than_or_equal_to=self.time_scheduled_greater_than_or_equal_to,
            time_scheduled_less_than=self.time_scheduled_less_than)


def get_scheduler_definitions(compartment_id: Optional[_builtins.str] = None,
                              display_name: Optional[_builtins.str] = None,
                              filters: Optional[Sequence[Union['GetSchedulerDefinitionsFilterArgs', 'GetSchedulerDefinitionsFilterArgsDict']]] = None,
                              fleet_id: Optional[_builtins.str] = None,
                              id: Optional[_builtins.str] = None,
                              maintenance_window_id: Optional[_builtins.str] = None,
                              product: Optional[_builtins.str] = None,
                              runbook_id: Optional[_builtins.str] = None,
                              runbook_version_name: Optional[_builtins.str] = None,
                              state: Optional[_builtins.str] = None,
                              time_scheduled_greater_than_or_equal_to: Optional[_builtins.str] = None,
                              time_scheduled_less_than: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSchedulerDefinitionsResult:
    """
    This data source provides the list of Scheduler Definitions in Oracle Cloud Infrastructure Fleet Apps Management service.

    Returns a list of all the Schedule Definitions in the specified compartment.
    The query parameter `compartmentId` is required unless the query parameter `id` is specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_scheduler_definitions = oci.FleetAppsManagement.get_scheduler_definitions(compartment_id=compartment_id,
        display_name=scheduler_definition_display_name,
        fleet_id=test_fleet["id"],
        id=scheduler_definition_id,
        maintenance_window_id=test_maintenance_window["id"],
        product=scheduler_definition_product,
        runbook_id=test_runbook["id"],
        runbook_version_name=test_runbook_version["name"],
        state=scheduler_definition_state,
        time_scheduled_greater_than_or_equal_to=scheduler_definition_time_scheduled_greater_than_or_equal_to,
        time_scheduled_less_than=scheduler_definition_time_scheduled_less_than)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources. Empty only if the resource OCID query param is not specified.
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param _builtins.str fleet_id: unique Fleet identifier
    :param _builtins.str id: Unique identifier or OCID for listing a single Schedule Definition by id. Either compartmentId or id must be provided.
    :param _builtins.str maintenance_window_id: A filter to return only schedule definitions whose associated maintenanceWindowId matches the given maintenanceWindowId.
    :param _builtins.str product: A filter to return only dchedule definitions whose assocaited product matches the given product
    :param _builtins.str runbook_id: A filter to return only schedule definitions whose associated runbookId matches the given runbookId.
    :param _builtins.str runbook_version_name: RunbookVersion Name filter
    :param _builtins.str state: A filter to return only scheduleDefinitions whose lifecycleState matches the given lifecycleState.
    :param _builtins.str time_scheduled_greater_than_or_equal_to: Scheduled Time
    :param _builtins.str time_scheduled_less_than: Scheduled Time
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['id'] = id
    __args__['maintenanceWindowId'] = maintenance_window_id
    __args__['product'] = product
    __args__['runbookId'] = runbook_id
    __args__['runbookVersionName'] = runbook_version_name
    __args__['state'] = state
    __args__['timeScheduledGreaterThanOrEqualTo'] = time_scheduled_greater_than_or_equal_to
    __args__['timeScheduledLessThan'] = time_scheduled_less_than
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getSchedulerDefinitions:getSchedulerDefinitions', __args__, opts=opts, typ=GetSchedulerDefinitionsResult).value

    return AwaitableGetSchedulerDefinitionsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        id=pulumi.get(__ret__, 'id'),
        maintenance_window_id=pulumi.get(__ret__, 'maintenance_window_id'),
        product=pulumi.get(__ret__, 'product'),
        runbook_id=pulumi.get(__ret__, 'runbook_id'),
        runbook_version_name=pulumi.get(__ret__, 'runbook_version_name'),
        scheduler_definition_collections=pulumi.get(__ret__, 'scheduler_definition_collections'),
        state=pulumi.get(__ret__, 'state'),
        time_scheduled_greater_than_or_equal_to=pulumi.get(__ret__, 'time_scheduled_greater_than_or_equal_to'),
        time_scheduled_less_than=pulumi.get(__ret__, 'time_scheduled_less_than'))
def get_scheduler_definitions_output(compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSchedulerDefinitionsFilterArgs', 'GetSchedulerDefinitionsFilterArgsDict']]]]] = None,
                                     fleet_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     maintenance_window_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     product: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     runbook_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     runbook_version_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     time_scheduled_greater_than_or_equal_to: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     time_scheduled_less_than: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSchedulerDefinitionsResult]:
    """
    This data source provides the list of Scheduler Definitions in Oracle Cloud Infrastructure Fleet Apps Management service.

    Returns a list of all the Schedule Definitions in the specified compartment.
    The query parameter `compartmentId` is required unless the query parameter `id` is specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_scheduler_definitions = oci.FleetAppsManagement.get_scheduler_definitions(compartment_id=compartment_id,
        display_name=scheduler_definition_display_name,
        fleet_id=test_fleet["id"],
        id=scheduler_definition_id,
        maintenance_window_id=test_maintenance_window["id"],
        product=scheduler_definition_product,
        runbook_id=test_runbook["id"],
        runbook_version_name=test_runbook_version["name"],
        state=scheduler_definition_state,
        time_scheduled_greater_than_or_equal_to=scheduler_definition_time_scheduled_greater_than_or_equal_to,
        time_scheduled_less_than=scheduler_definition_time_scheduled_less_than)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources. Empty only if the resource OCID query param is not specified.
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param _builtins.str fleet_id: unique Fleet identifier
    :param _builtins.str id: Unique identifier or OCID for listing a single Schedule Definition by id. Either compartmentId or id must be provided.
    :param _builtins.str maintenance_window_id: A filter to return only schedule definitions whose associated maintenanceWindowId matches the given maintenanceWindowId.
    :param _builtins.str product: A filter to return only dchedule definitions whose assocaited product matches the given product
    :param _builtins.str runbook_id: A filter to return only schedule definitions whose associated runbookId matches the given runbookId.
    :param _builtins.str runbook_version_name: RunbookVersion Name filter
    :param _builtins.str state: A filter to return only scheduleDefinitions whose lifecycleState matches the given lifecycleState.
    :param _builtins.str time_scheduled_greater_than_or_equal_to: Scheduled Time
    :param _builtins.str time_scheduled_less_than: Scheduled Time
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['id'] = id
    __args__['maintenanceWindowId'] = maintenance_window_id
    __args__['product'] = product
    __args__['runbookId'] = runbook_id
    __args__['runbookVersionName'] = runbook_version_name
    __args__['state'] = state
    __args__['timeScheduledGreaterThanOrEqualTo'] = time_scheduled_greater_than_or_equal_to
    __args__['timeScheduledLessThan'] = time_scheduled_less_than
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getSchedulerDefinitions:getSchedulerDefinitions', __args__, opts=opts, typ=GetSchedulerDefinitionsResult)
    return __ret__.apply(lambda __response__: GetSchedulerDefinitionsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        fleet_id=pulumi.get(__response__, 'fleet_id'),
        id=pulumi.get(__response__, 'id'),
        maintenance_window_id=pulumi.get(__response__, 'maintenance_window_id'),
        product=pulumi.get(__response__, 'product'),
        runbook_id=pulumi.get(__response__, 'runbook_id'),
        runbook_version_name=pulumi.get(__response__, 'runbook_version_name'),
        scheduler_definition_collections=pulumi.get(__response__, 'scheduler_definition_collections'),
        state=pulumi.get(__response__, 'state'),
        time_scheduled_greater_than_or_equal_to=pulumi.get(__response__, 'time_scheduled_greater_than_or_equal_to'),
        time_scheduled_less_than=pulumi.get(__response__, 'time_scheduled_less_than')))
