# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetListingResult',
    'AwaitableGetListingResult',
    'get_listing',
    'get_listing_output',
]

@pulumi.output_type
class GetListingResult:
    """
    A collection of values returned by getListing.
    """
    def __init__(__self__, banners=None, categories=None, compartment_id=None, compatible_architectures=None, default_package_version=None, documentation_links=None, icons=None, id=None, is_featured=None, keywords=None, languages=None, license_model_description=None, links=None, listing_id=None, listing_type=None, long_description=None, name=None, package_type=None, publishers=None, regions=None, release_notes=None, screenshots=None, short_description=None, support_contacts=None, support_links=None, supported_operating_systems=None, system_requirements=None, tagline=None, time_released=None, usage_information=None, version=None, videos=None):
        if banners and not isinstance(banners, list):
            raise TypeError("Expected argument 'banners' to be a list")
        pulumi.set(__self__, "banners", banners)
        if categories and not isinstance(categories, list):
            raise TypeError("Expected argument 'categories' to be a list")
        pulumi.set(__self__, "categories", categories)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compatible_architectures and not isinstance(compatible_architectures, list):
            raise TypeError("Expected argument 'compatible_architectures' to be a list")
        pulumi.set(__self__, "compatible_architectures", compatible_architectures)
        if default_package_version and not isinstance(default_package_version, str):
            raise TypeError("Expected argument 'default_package_version' to be a str")
        pulumi.set(__self__, "default_package_version", default_package_version)
        if documentation_links and not isinstance(documentation_links, list):
            raise TypeError("Expected argument 'documentation_links' to be a list")
        pulumi.set(__self__, "documentation_links", documentation_links)
        if icons and not isinstance(icons, list):
            raise TypeError("Expected argument 'icons' to be a list")
        pulumi.set(__self__, "icons", icons)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_featured and not isinstance(is_featured, bool):
            raise TypeError("Expected argument 'is_featured' to be a bool")
        pulumi.set(__self__, "is_featured", is_featured)
        if keywords and not isinstance(keywords, str):
            raise TypeError("Expected argument 'keywords' to be a str")
        pulumi.set(__self__, "keywords", keywords)
        if languages and not isinstance(languages, list):
            raise TypeError("Expected argument 'languages' to be a list")
        pulumi.set(__self__, "languages", languages)
        if license_model_description and not isinstance(license_model_description, str):
            raise TypeError("Expected argument 'license_model_description' to be a str")
        pulumi.set(__self__, "license_model_description", license_model_description)
        if links and not isinstance(links, list):
            raise TypeError("Expected argument 'links' to be a list")
        pulumi.set(__self__, "links", links)
        if listing_id and not isinstance(listing_id, str):
            raise TypeError("Expected argument 'listing_id' to be a str")
        pulumi.set(__self__, "listing_id", listing_id)
        if listing_type and not isinstance(listing_type, str):
            raise TypeError("Expected argument 'listing_type' to be a str")
        pulumi.set(__self__, "listing_type", listing_type)
        if long_description and not isinstance(long_description, str):
            raise TypeError("Expected argument 'long_description' to be a str")
        pulumi.set(__self__, "long_description", long_description)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if package_type and not isinstance(package_type, str):
            raise TypeError("Expected argument 'package_type' to be a str")
        pulumi.set(__self__, "package_type", package_type)
        if publishers and not isinstance(publishers, list):
            raise TypeError("Expected argument 'publishers' to be a list")
        pulumi.set(__self__, "publishers", publishers)
        if regions and not isinstance(regions, list):
            raise TypeError("Expected argument 'regions' to be a list")
        pulumi.set(__self__, "regions", regions)
        if release_notes and not isinstance(release_notes, str):
            raise TypeError("Expected argument 'release_notes' to be a str")
        pulumi.set(__self__, "release_notes", release_notes)
        if screenshots and not isinstance(screenshots, list):
            raise TypeError("Expected argument 'screenshots' to be a list")
        pulumi.set(__self__, "screenshots", screenshots)
        if short_description and not isinstance(short_description, str):
            raise TypeError("Expected argument 'short_description' to be a str")
        pulumi.set(__self__, "short_description", short_description)
        if support_contacts and not isinstance(support_contacts, list):
            raise TypeError("Expected argument 'support_contacts' to be a list")
        pulumi.set(__self__, "support_contacts", support_contacts)
        if support_links and not isinstance(support_links, list):
            raise TypeError("Expected argument 'support_links' to be a list")
        pulumi.set(__self__, "support_links", support_links)
        if supported_operating_systems and not isinstance(supported_operating_systems, list):
            raise TypeError("Expected argument 'supported_operating_systems' to be a list")
        pulumi.set(__self__, "supported_operating_systems", supported_operating_systems)
        if system_requirements and not isinstance(system_requirements, str):
            raise TypeError("Expected argument 'system_requirements' to be a str")
        pulumi.set(__self__, "system_requirements", system_requirements)
        if tagline and not isinstance(tagline, str):
            raise TypeError("Expected argument 'tagline' to be a str")
        pulumi.set(__self__, "tagline", tagline)
        if time_released and not isinstance(time_released, str):
            raise TypeError("Expected argument 'time_released' to be a str")
        pulumi.set(__self__, "time_released", time_released)
        if usage_information and not isinstance(usage_information, str):
            raise TypeError("Expected argument 'usage_information' to be a str")
        pulumi.set(__self__, "usage_information", usage_information)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)
        if videos and not isinstance(videos, list):
            raise TypeError("Expected argument 'videos' to be a list")
        pulumi.set(__self__, "videos", videos)

    @_builtins.property
    @pulumi.getter
    def banners(self) -> Sequence['outputs.GetListingBannerResult']:
        """
        The model for upload data for images and icons.
        """
        return pulumi.get(self, "banners")

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Sequence[_builtins.str]:
        """
        Product categories that the listing belongs to.
        """
        return pulumi.get(self, "categories")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="compatibleArchitectures")
    def compatible_architectures(self) -> Sequence[_builtins.str]:
        """
        The list of compatible architectures supported by the listing
        """
        return pulumi.get(self, "compatible_architectures")

    @_builtins.property
    @pulumi.getter(name="defaultPackageVersion")
    def default_package_version(self) -> _builtins.str:
        """
        The default package version.
        """
        return pulumi.get(self, "default_package_version")

    @_builtins.property
    @pulumi.getter(name="documentationLinks")
    def documentation_links(self) -> Sequence['outputs.GetListingDocumentationLinkResult']:
        """
        Links to additional documentation provided by the publisher specifically for the listing.
        """
        return pulumi.get(self, "documentation_links")

    @_builtins.property
    @pulumi.getter
    def icons(self) -> Sequence['outputs.GetListingIconResult']:
        """
        The model for upload data for images and icons.
        """
        return pulumi.get(self, "icons")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isFeatured")
    def is_featured(self) -> _builtins.bool:
        """
        Indicates whether the listing is included in Featured Listings.
        """
        return pulumi.get(self, "is_featured")

    @_builtins.property
    @pulumi.getter
    def keywords(self) -> _builtins.str:
        """
        Keywords associated with the listing.
        """
        return pulumi.get(self, "keywords")

    @_builtins.property
    @pulumi.getter
    def languages(self) -> Sequence['outputs.GetListingLanguageResult']:
        """
        Languages supported by the listing.
        """
        return pulumi.get(self, "languages")

    @_builtins.property
    @pulumi.getter(name="licenseModelDescription")
    def license_model_description(self) -> _builtins.str:
        """
        A description of the publisher's licensing model for the listing.
        """
        return pulumi.get(self, "license_model_description")

    @_builtins.property
    @pulumi.getter
    def links(self) -> Sequence['outputs.GetListingLinkResult']:
        """
        Reference links.
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter(name="listingId")
    def listing_id(self) -> _builtins.str:
        return pulumi.get(self, "listing_id")

    @_builtins.property
    @pulumi.getter(name="listingType")
    def listing_type(self) -> _builtins.str:
        """
        The publisher category to which the listing belongs. The publisher category informs where the listing appears for use.
        """
        return pulumi.get(self, "listing_type")

    @_builtins.property
    @pulumi.getter(name="longDescription")
    def long_description(self) -> _builtins.str:
        """
        A long description of the listing.
        """
        return pulumi.get(self, "long_description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Text that describes the resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="packageType")
    def package_type(self) -> _builtins.str:
        """
        The listing's package type.
        """
        return pulumi.get(self, "package_type")

    @_builtins.property
    @pulumi.getter
    def publishers(self) -> Sequence['outputs.GetListingPublisherResult']:
        """
        Summary details about the publisher of the listing.
        """
        return pulumi.get(self, "publishers")

    @_builtins.property
    @pulumi.getter
    def regions(self) -> Sequence['outputs.GetListingRegionResult']:
        """
        The regions where the listing is eligible to be deployed.
        """
        return pulumi.get(self, "regions")

    @_builtins.property
    @pulumi.getter(name="releaseNotes")
    def release_notes(self) -> _builtins.str:
        """
        Release notes for the listing.
        """
        return pulumi.get(self, "release_notes")

    @_builtins.property
    @pulumi.getter
    def screenshots(self) -> Sequence['outputs.GetListingScreenshotResult']:
        """
        Screenshots of the listing.
        """
        return pulumi.get(self, "screenshots")

    @_builtins.property
    @pulumi.getter(name="shortDescription")
    def short_description(self) -> _builtins.str:
        """
        A short description of the listing.
        """
        return pulumi.get(self, "short_description")

    @_builtins.property
    @pulumi.getter(name="supportContacts")
    def support_contacts(self) -> Sequence['outputs.GetListingSupportContactResult']:
        """
        Contact information to use to get support from the publisher for the listing.
        """
        return pulumi.get(self, "support_contacts")

    @_builtins.property
    @pulumi.getter(name="supportLinks")
    def support_links(self) -> Sequence['outputs.GetListingSupportLinkResult']:
        """
        Links to support resources for the listing.
        """
        return pulumi.get(self, "support_links")

    @_builtins.property
    @pulumi.getter(name="supportedOperatingSystems")
    def supported_operating_systems(self) -> Sequence['outputs.GetListingSupportedOperatingSystemResult']:
        """
        The list of operating systems supported by the listing.
        """
        return pulumi.get(self, "supported_operating_systems")

    @_builtins.property
    @pulumi.getter(name="systemRequirements")
    def system_requirements(self) -> _builtins.str:
        """
        System requirements for the listing.
        """
        return pulumi.get(self, "system_requirements")

    @_builtins.property
    @pulumi.getter
    def tagline(self) -> _builtins.str:
        """
        The tagline of the listing.
        """
        return pulumi.get(self, "tagline")

    @_builtins.property
    @pulumi.getter(name="timeReleased")
    def time_released(self) -> _builtins.str:
        """
        The release date of the listing.
        """
        return pulumi.get(self, "time_released")

    @_builtins.property
    @pulumi.getter(name="usageInformation")
    def usage_information(self) -> _builtins.str:
        """
        Usage information for the listing.
        """
        return pulumi.get(self, "usage_information")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The version of the listing.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter
    def videos(self) -> Sequence['outputs.GetListingVideoResult']:
        """
        Videos of the listing.
        """
        return pulumi.get(self, "videos")


class AwaitableGetListingResult(GetListingResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetListingResult(
            banners=self.banners,
            categories=self.categories,
            compartment_id=self.compartment_id,
            compatible_architectures=self.compatible_architectures,
            default_package_version=self.default_package_version,
            documentation_links=self.documentation_links,
            icons=self.icons,
            id=self.id,
            is_featured=self.is_featured,
            keywords=self.keywords,
            languages=self.languages,
            license_model_description=self.license_model_description,
            links=self.links,
            listing_id=self.listing_id,
            listing_type=self.listing_type,
            long_description=self.long_description,
            name=self.name,
            package_type=self.package_type,
            publishers=self.publishers,
            regions=self.regions,
            release_notes=self.release_notes,
            screenshots=self.screenshots,
            short_description=self.short_description,
            support_contacts=self.support_contacts,
            support_links=self.support_links,
            supported_operating_systems=self.supported_operating_systems,
            system_requirements=self.system_requirements,
            tagline=self.tagline,
            time_released=self.time_released,
            usage_information=self.usage_information,
            version=self.version,
            videos=self.videos)


def get_listing(compartment_id: Optional[_builtins.str] = None,
                listing_id: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetListingResult:
    """
    This data source provides details about a specific Listing resource in Oracle Cloud Infrastructure Marketplace service.

    Gets detailed information about a listing, including the listing's name, version, description, and
    resources.

    If you plan to launch an instance from an image listing, you must first subscribe to the listing. When
    you launch the instance, you also need to provide the image ID of the listing resource version that you want.

    Subscribing to the listing requires you to first get a signature from the terms of use agreement for the
    listing resource version. To get the signature, issue a [GetAppCatalogListingAgreements](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/latest/AppCatalogListingResourceVersionAgreements/GetAppCatalogListingAgreements) API call.
    The [AppCatalogListingResourceVersionAgreements](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/latest/AppCatalogListingResourceVersionAgreements) object, including
    its signature, is returned in the response. With the signature for the terms of use agreement for the desired
    listing resource version, create a subscription by issuing a
    [CreateAppCatalogSubscription](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/latest/AppCatalogSubscription/CreateAppCatalogSubscription) API call.

    To get the image ID to launch an instance, issue a [GetAppCatalogListingResourceVersion](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/latest/AppCatalogListingResourceVersion/GetAppCatalogListingResourceVersion) API call.
    Lastly, to launch the instance, use the image ID of the listing resource version to issue a [LaunchInstance](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/latest/Instance/LaunchInstance) API call.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_listing = oci.Marketplace.get_listing(listing_id=test_listing_oci_marketplace_listing["id"],
        compartment_id=compartment_id)
    ```


    :param _builtins.str compartment_id: The unique identifier for the compartment. It is mandatory when used in non-commercial realms.
    :param _builtins.str listing_id: The unique identifier for the listing.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['listingId'] = listing_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Marketplace/getListing:getListing', __args__, opts=opts, typ=GetListingResult).value

    return AwaitableGetListingResult(
        banners=pulumi.get(__ret__, 'banners'),
        categories=pulumi.get(__ret__, 'categories'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compatible_architectures=pulumi.get(__ret__, 'compatible_architectures'),
        default_package_version=pulumi.get(__ret__, 'default_package_version'),
        documentation_links=pulumi.get(__ret__, 'documentation_links'),
        icons=pulumi.get(__ret__, 'icons'),
        id=pulumi.get(__ret__, 'id'),
        is_featured=pulumi.get(__ret__, 'is_featured'),
        keywords=pulumi.get(__ret__, 'keywords'),
        languages=pulumi.get(__ret__, 'languages'),
        license_model_description=pulumi.get(__ret__, 'license_model_description'),
        links=pulumi.get(__ret__, 'links'),
        listing_id=pulumi.get(__ret__, 'listing_id'),
        listing_type=pulumi.get(__ret__, 'listing_type'),
        long_description=pulumi.get(__ret__, 'long_description'),
        name=pulumi.get(__ret__, 'name'),
        package_type=pulumi.get(__ret__, 'package_type'),
        publishers=pulumi.get(__ret__, 'publishers'),
        regions=pulumi.get(__ret__, 'regions'),
        release_notes=pulumi.get(__ret__, 'release_notes'),
        screenshots=pulumi.get(__ret__, 'screenshots'),
        short_description=pulumi.get(__ret__, 'short_description'),
        support_contacts=pulumi.get(__ret__, 'support_contacts'),
        support_links=pulumi.get(__ret__, 'support_links'),
        supported_operating_systems=pulumi.get(__ret__, 'supported_operating_systems'),
        system_requirements=pulumi.get(__ret__, 'system_requirements'),
        tagline=pulumi.get(__ret__, 'tagline'),
        time_released=pulumi.get(__ret__, 'time_released'),
        usage_information=pulumi.get(__ret__, 'usage_information'),
        version=pulumi.get(__ret__, 'version'),
        videos=pulumi.get(__ret__, 'videos'))
def get_listing_output(compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       listing_id: Optional[pulumi.Input[_builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetListingResult]:
    """
    This data source provides details about a specific Listing resource in Oracle Cloud Infrastructure Marketplace service.

    Gets detailed information about a listing, including the listing's name, version, description, and
    resources.

    If you plan to launch an instance from an image listing, you must first subscribe to the listing. When
    you launch the instance, you also need to provide the image ID of the listing resource version that you want.

    Subscribing to the listing requires you to first get a signature from the terms of use agreement for the
    listing resource version. To get the signature, issue a [GetAppCatalogListingAgreements](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/latest/AppCatalogListingResourceVersionAgreements/GetAppCatalogListingAgreements) API call.
    The [AppCatalogListingResourceVersionAgreements](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/latest/AppCatalogListingResourceVersionAgreements) object, including
    its signature, is returned in the response. With the signature for the terms of use agreement for the desired
    listing resource version, create a subscription by issuing a
    [CreateAppCatalogSubscription](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/latest/AppCatalogSubscription/CreateAppCatalogSubscription) API call.

    To get the image ID to launch an instance, issue a [GetAppCatalogListingResourceVersion](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/latest/AppCatalogListingResourceVersion/GetAppCatalogListingResourceVersion) API call.
    Lastly, to launch the instance, use the image ID of the listing resource version to issue a [LaunchInstance](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/latest/Instance/LaunchInstance) API call.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_listing = oci.Marketplace.get_listing(listing_id=test_listing_oci_marketplace_listing["id"],
        compartment_id=compartment_id)
    ```


    :param _builtins.str compartment_id: The unique identifier for the compartment. It is mandatory when used in non-commercial realms.
    :param _builtins.str listing_id: The unique identifier for the listing.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['listingId'] = listing_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Marketplace/getListing:getListing', __args__, opts=opts, typ=GetListingResult)
    return __ret__.apply(lambda __response__: GetListingResult(
        banners=pulumi.get(__response__, 'banners'),
        categories=pulumi.get(__response__, 'categories'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compatible_architectures=pulumi.get(__response__, 'compatible_architectures'),
        default_package_version=pulumi.get(__response__, 'default_package_version'),
        documentation_links=pulumi.get(__response__, 'documentation_links'),
        icons=pulumi.get(__response__, 'icons'),
        id=pulumi.get(__response__, 'id'),
        is_featured=pulumi.get(__response__, 'is_featured'),
        keywords=pulumi.get(__response__, 'keywords'),
        languages=pulumi.get(__response__, 'languages'),
        license_model_description=pulumi.get(__response__, 'license_model_description'),
        links=pulumi.get(__response__, 'links'),
        listing_id=pulumi.get(__response__, 'listing_id'),
        listing_type=pulumi.get(__response__, 'listing_type'),
        long_description=pulumi.get(__response__, 'long_description'),
        name=pulumi.get(__response__, 'name'),
        package_type=pulumi.get(__response__, 'package_type'),
        publishers=pulumi.get(__response__, 'publishers'),
        regions=pulumi.get(__response__, 'regions'),
        release_notes=pulumi.get(__response__, 'release_notes'),
        screenshots=pulumi.get(__response__, 'screenshots'),
        short_description=pulumi.get(__response__, 'short_description'),
        support_contacts=pulumi.get(__response__, 'support_contacts'),
        support_links=pulumi.get(__response__, 'support_links'),
        supported_operating_systems=pulumi.get(__response__, 'supported_operating_systems'),
        system_requirements=pulumi.get(__response__, 'system_requirements'),
        tagline=pulumi.get(__response__, 'tagline'),
        time_released=pulumi.get(__response__, 'time_released'),
        usage_information=pulumi.get(__response__, 'usage_information'),
        version=pulumi.get(__response__, 'version'),
        videos=pulumi.get(__response__, 'videos')))
