# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetNetworkFirewallPolicyNatRuleResult',
    'AwaitableGetNetworkFirewallPolicyNatRuleResult',
    'get_network_firewall_policy_nat_rule',
    'get_network_firewall_policy_nat_rule_output',
]

@pulumi.output_type
class GetNetworkFirewallPolicyNatRuleResult:
    """
    A collection of values returned by getNetworkFirewallPolicyNatRule.
    """
    def __init__(__self__, action=None, conditions=None, description=None, id=None, name=None, nat_rule_name=None, network_firewall_policy_id=None, parent_resource_id=None, positions=None, priority_order=None, type=None):
        if action and not isinstance(action, str):
            raise TypeError("Expected argument 'action' to be a str")
        pulumi.set(__self__, "action", action)
        if conditions and not isinstance(conditions, list):
            raise TypeError("Expected argument 'conditions' to be a list")
        pulumi.set(__self__, "conditions", conditions)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if nat_rule_name and not isinstance(nat_rule_name, str):
            raise TypeError("Expected argument 'nat_rule_name' to be a str")
        pulumi.set(__self__, "nat_rule_name", nat_rule_name)
        if network_firewall_policy_id and not isinstance(network_firewall_policy_id, str):
            raise TypeError("Expected argument 'network_firewall_policy_id' to be a str")
        pulumi.set(__self__, "network_firewall_policy_id", network_firewall_policy_id)
        if parent_resource_id and not isinstance(parent_resource_id, str):
            raise TypeError("Expected argument 'parent_resource_id' to be a str")
        pulumi.set(__self__, "parent_resource_id", parent_resource_id)
        if positions and not isinstance(positions, list):
            raise TypeError("Expected argument 'positions' to be a list")
        pulumi.set(__self__, "positions", positions)
        if priority_order and not isinstance(priority_order, str):
            raise TypeError("Expected argument 'priority_order' to be a str")
        pulumi.set(__self__, "priority_order", priority_order)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        action:
        * DIPP_SRC_NAT - Dynamic-ip-port source NAT.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.GetNetworkFirewallPolicyNatRuleConditionResult']:
        """
        Match criteria used in NAT Rule used on the firewall policy.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of a NAT rule. This field can be used to add additional info.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name for the NAT rule, must be unique within the policy.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="natRuleName")
    def nat_rule_name(self) -> _builtins.str:
        return pulumi.get(self, "nat_rule_name")

    @_builtins.property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> _builtins.str:
        return pulumi.get(self, "network_firewall_policy_id")

    @_builtins.property
    @pulumi.getter(name="parentResourceId")
    def parent_resource_id(self) -> _builtins.str:
        """
        OCID of the Network Firewall Policy this decryption profile belongs to.
        """
        return pulumi.get(self, "parent_resource_id")

    @_builtins.property
    @pulumi.getter
    def positions(self) -> Sequence['outputs.GetNetworkFirewallPolicyNatRulePositionResult']:
        """
        An object which defines the position of the rule.
        """
        return pulumi.get(self, "positions")

    @_builtins.property
    @pulumi.getter(name="priorityOrder")
    def priority_order(self) -> _builtins.str:
        """
        The priority order in which this rule should be evaluated
        """
        return pulumi.get(self, "priority_order")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        NAT type:
        * NATV4 - NATV4 type NAT.
        """
        return pulumi.get(self, "type")


class AwaitableGetNetworkFirewallPolicyNatRuleResult(GetNetworkFirewallPolicyNatRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkFirewallPolicyNatRuleResult(
            action=self.action,
            conditions=self.conditions,
            description=self.description,
            id=self.id,
            name=self.name,
            nat_rule_name=self.nat_rule_name,
            network_firewall_policy_id=self.network_firewall_policy_id,
            parent_resource_id=self.parent_resource_id,
            positions=self.positions,
            priority_order=self.priority_order,
            type=self.type)


def get_network_firewall_policy_nat_rule(nat_rule_name: Optional[_builtins.str] = None,
                                         network_firewall_policy_id: Optional[_builtins.str] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkFirewallPolicyNatRuleResult:
    """
    This data source provides details about a specific Network Firewall Policy Nat Rule resource in Oracle Cloud Infrastructure Network Firewall service.

    Get NAT Rule by the given name in the context of network firewall policy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_network_firewall_policy_nat_rule = oci.NetworkFirewall.get_network_firewall_policy_nat_rule(nat_rule_name=test_rule["name"],
        network_firewall_policy_id=test_network_firewall_policy["id"])
    ```


    :param _builtins.str nat_rule_name: Unique identifier for NAT Rules in the network firewall policy.
    :param _builtins.str network_firewall_policy_id: Unique Network Firewall Policy identifier
    """
    __args__ = dict()
    __args__['natRuleName'] = nat_rule_name
    __args__['networkFirewallPolicyId'] = network_firewall_policy_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:NetworkFirewall/getNetworkFirewallPolicyNatRule:getNetworkFirewallPolicyNatRule', __args__, opts=opts, typ=GetNetworkFirewallPolicyNatRuleResult).value

    return AwaitableGetNetworkFirewallPolicyNatRuleResult(
        action=pulumi.get(__ret__, 'action'),
        conditions=pulumi.get(__ret__, 'conditions'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        nat_rule_name=pulumi.get(__ret__, 'nat_rule_name'),
        network_firewall_policy_id=pulumi.get(__ret__, 'network_firewall_policy_id'),
        parent_resource_id=pulumi.get(__ret__, 'parent_resource_id'),
        positions=pulumi.get(__ret__, 'positions'),
        priority_order=pulumi.get(__ret__, 'priority_order'),
        type=pulumi.get(__ret__, 'type'))
def get_network_firewall_policy_nat_rule_output(nat_rule_name: Optional[pulumi.Input[_builtins.str]] = None,
                                                network_firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworkFirewallPolicyNatRuleResult]:
    """
    This data source provides details about a specific Network Firewall Policy Nat Rule resource in Oracle Cloud Infrastructure Network Firewall service.

    Get NAT Rule by the given name in the context of network firewall policy.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_network_firewall_policy_nat_rule = oci.NetworkFirewall.get_network_firewall_policy_nat_rule(nat_rule_name=test_rule["name"],
        network_firewall_policy_id=test_network_firewall_policy["id"])
    ```


    :param _builtins.str nat_rule_name: Unique identifier for NAT Rules in the network firewall policy.
    :param _builtins.str network_firewall_policy_id: Unique Network Firewall Policy identifier
    """
    __args__ = dict()
    __args__['natRuleName'] = nat_rule_name
    __args__['networkFirewallPolicyId'] = network_firewall_policy_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:NetworkFirewall/getNetworkFirewallPolicyNatRule:getNetworkFirewallPolicyNatRule', __args__, opts=opts, typ=GetNetworkFirewallPolicyNatRuleResult)
    return __ret__.apply(lambda __response__: GetNetworkFirewallPolicyNatRuleResult(
        action=pulumi.get(__response__, 'action'),
        conditions=pulumi.get(__response__, 'conditions'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        nat_rule_name=pulumi.get(__response__, 'nat_rule_name'),
        network_firewall_policy_id=pulumi.get(__response__, 'network_firewall_policy_id'),
        parent_resource_id=pulumi.get(__response__, 'parent_resource_id'),
        positions=pulumi.get(__response__, 'positions'),
        priority_order=pulumi.get(__response__, 'priority_order'),
        type=pulumi.get(__response__, 'type')))
