# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkFirewallPolicyDecryptionRuleArgs', 'NetworkFirewallPolicyDecryptionRule']

@pulumi.input_type
class NetworkFirewallPolicyDecryptionRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[_builtins.str],
                 condition: pulumi.Input['NetworkFirewallPolicyDecryptionRuleConditionArgs'],
                 network_firewall_policy_id: pulumi.Input[_builtins.str],
                 decryption_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 position: Optional[pulumi.Input['NetworkFirewallPolicyDecryptionRulePositionArgs']] = None,
                 priority_order: Optional[pulumi.Input[_builtins.str]] = None,
                 secret: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NetworkFirewallPolicyDecryptionRule resource.
        :param pulumi.Input[_builtins.str] action: (Updatable) Action:
               * NO_DECRYPT - Matching traffic is not decrypted.
               * DECRYPT - Matching traffic is decrypted with the specified `secret` according to the specified `decryptionProfile`.
        :param pulumi.Input['NetworkFirewallPolicyDecryptionRuleConditionArgs'] condition: (Updatable) Match criteria used in Decryption Rule used on the firewall policy rules. The resources mentioned must already be present in the policy before being referenced in the rule.
        :param pulumi.Input[_builtins.str] network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param pulumi.Input[_builtins.str] decryption_profile: (Updatable) The name of the decryption profile to use.
        :param pulumi.Input[_builtins.str] name: Name for the decryption rule, must be unique within the policy.
        :param pulumi.Input['NetworkFirewallPolicyDecryptionRulePositionArgs'] position: (Updatable) An object which defines the position of the rule. Only one of `after_rule` or `before_rule` should be provided.
        :param pulumi.Input[_builtins.str] secret: (Updatable) The name of a mapped secret. Its `type` must match that of the specified decryption profile.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "network_firewall_policy_id", network_firewall_policy_id)
        if decryption_profile is not None:
            pulumi.set(__self__, "decryption_profile", decryption_profile)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if priority_order is not None:
            pulumi.set(__self__, "priority_order", priority_order)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Action:
        * NO_DECRYPT - Matching traffic is not decrypted.
        * DECRYPT - Matching traffic is decrypted with the specified `secret` according to the specified `decryptionProfile`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> pulumi.Input['NetworkFirewallPolicyDecryptionRuleConditionArgs']:
        """
        (Updatable) Match criteria used in Decryption Rule used on the firewall policy rules. The resources mentioned must already be present in the policy before being referenced in the rule.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: pulumi.Input['NetworkFirewallPolicyDecryptionRuleConditionArgs']):
        pulumi.set(self, "condition", value)

    @_builtins.property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> pulumi.Input[_builtins.str]:
        """
        Unique Network Firewall Policy identifier
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @network_firewall_policy_id.setter
    def network_firewall_policy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_firewall_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="decryptionProfile")
    def decryption_profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The name of the decryption profile to use.
        """
        return pulumi.get(self, "decryption_profile")

    @decryption_profile.setter
    def decryption_profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "decryption_profile", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name for the decryption rule, must be unique within the policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input['NetworkFirewallPolicyDecryptionRulePositionArgs']]:
        """
        (Updatable) An object which defines the position of the rule. Only one of `after_rule` or `before_rule` should be provided.
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input['NetworkFirewallPolicyDecryptionRulePositionArgs']]):
        pulumi.set(self, "position", value)

    @_builtins.property
    @pulumi.getter(name="priorityOrder")
    def priority_order(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "priority_order")

    @priority_order.setter
    def priority_order(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "priority_order", value)

    @_builtins.property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The name of a mapped secret. Its `type` must match that of the specified decryption profile.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret", value)


@pulumi.input_type
class _NetworkFirewallPolicyDecryptionRuleState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 condition: Optional[pulumi.Input['NetworkFirewallPolicyDecryptionRuleConditionArgs']] = None,
                 decryption_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 position: Optional[pulumi.Input['NetworkFirewallPolicyDecryptionRulePositionArgs']] = None,
                 priority_order: Optional[pulumi.Input[_builtins.str]] = None,
                 secret: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NetworkFirewallPolicyDecryptionRule resources.
        :param pulumi.Input[_builtins.str] action: (Updatable) Action:
               * NO_DECRYPT - Matching traffic is not decrypted.
               * DECRYPT - Matching traffic is decrypted with the specified `secret` according to the specified `decryptionProfile`.
        :param pulumi.Input['NetworkFirewallPolicyDecryptionRuleConditionArgs'] condition: (Updatable) Match criteria used in Decryption Rule used on the firewall policy rules. The resources mentioned must already be present in the policy before being referenced in the rule.
        :param pulumi.Input[_builtins.str] decryption_profile: (Updatable) The name of the decryption profile to use.
        :param pulumi.Input[_builtins.str] name: Name for the decryption rule, must be unique within the policy.
        :param pulumi.Input[_builtins.str] network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param pulumi.Input[_builtins.str] parent_resource_id: OCID of the Network Firewall Policy this decryption rule belongs to.
        :param pulumi.Input['NetworkFirewallPolicyDecryptionRulePositionArgs'] position: (Updatable) An object which defines the position of the rule. Only one of `after_rule` or `before_rule` should be provided.
        :param pulumi.Input[_builtins.str] secret: (Updatable) The name of a mapped secret. Its `type` must match that of the specified decryption profile.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if decryption_profile is not None:
            pulumi.set(__self__, "decryption_profile", decryption_profile)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_firewall_policy_id is not None:
            pulumi.set(__self__, "network_firewall_policy_id", network_firewall_policy_id)
        if parent_resource_id is not None:
            pulumi.set(__self__, "parent_resource_id", parent_resource_id)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if priority_order is not None:
            pulumi.set(__self__, "priority_order", priority_order)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Action:
        * NO_DECRYPT - Matching traffic is not decrypted.
        * DECRYPT - Matching traffic is decrypted with the specified `secret` according to the specified `decryptionProfile`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['NetworkFirewallPolicyDecryptionRuleConditionArgs']]:
        """
        (Updatable) Match criteria used in Decryption Rule used on the firewall policy rules. The resources mentioned must already be present in the policy before being referenced in the rule.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['NetworkFirewallPolicyDecryptionRuleConditionArgs']]):
        pulumi.set(self, "condition", value)

    @_builtins.property
    @pulumi.getter(name="decryptionProfile")
    def decryption_profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The name of the decryption profile to use.
        """
        return pulumi.get(self, "decryption_profile")

    @decryption_profile.setter
    def decryption_profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "decryption_profile", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name for the decryption rule, must be unique within the policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique Network Firewall Policy identifier
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @network_firewall_policy_id.setter
    def network_firewall_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_firewall_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="parentResourceId")
    def parent_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OCID of the Network Firewall Policy this decryption rule belongs to.
        """
        return pulumi.get(self, "parent_resource_id")

    @parent_resource_id.setter
    def parent_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_resource_id", value)

    @_builtins.property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input['NetworkFirewallPolicyDecryptionRulePositionArgs']]:
        """
        (Updatable) An object which defines the position of the rule. Only one of `after_rule` or `before_rule` should be provided.
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input['NetworkFirewallPolicyDecryptionRulePositionArgs']]):
        pulumi.set(self, "position", value)

    @_builtins.property
    @pulumi.getter(name="priorityOrder")
    def priority_order(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "priority_order")

    @priority_order.setter
    def priority_order(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "priority_order", value)

    @_builtins.property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The name of a mapped secret. Its `type` must match that of the specified decryption profile.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret", value)


@pulumi.type_token("oci:NetworkFirewall/networkFirewallPolicyDecryptionRule:NetworkFirewallPolicyDecryptionRule")
class NetworkFirewallPolicyDecryptionRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 condition: Optional[pulumi.Input[Union['NetworkFirewallPolicyDecryptionRuleConditionArgs', 'NetworkFirewallPolicyDecryptionRuleConditionArgsDict']]] = None,
                 decryption_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 position: Optional[pulumi.Input[Union['NetworkFirewallPolicyDecryptionRulePositionArgs', 'NetworkFirewallPolicyDecryptionRulePositionArgsDict']]] = None,
                 priority_order: Optional[pulumi.Input[_builtins.str]] = None,
                 secret: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Network Firewall Policy Decryption Rule resource in Oracle Cloud Infrastructure Network Firewall service.

        Creates a new Decryption Rule for the Network Firewall Policy.

        ## Import

        NetworkFirewallPolicyDecryptionRules can be imported using the `name`, e.g.

        ```sh
        $ pulumi import oci:NetworkFirewall/networkFirewallPolicyDecryptionRule:NetworkFirewallPolicyDecryptionRule test_network_firewall_policy_decryption_rule "networkFirewallPolicies/{networkFirewallPolicyId}/decryptionRules/{decryptionRuleName}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: (Updatable) Action:
               * NO_DECRYPT - Matching traffic is not decrypted.
               * DECRYPT - Matching traffic is decrypted with the specified `secret` according to the specified `decryptionProfile`.
        :param pulumi.Input[Union['NetworkFirewallPolicyDecryptionRuleConditionArgs', 'NetworkFirewallPolicyDecryptionRuleConditionArgsDict']] condition: (Updatable) Match criteria used in Decryption Rule used on the firewall policy rules. The resources mentioned must already be present in the policy before being referenced in the rule.
        :param pulumi.Input[_builtins.str] decryption_profile: (Updatable) The name of the decryption profile to use.
        :param pulumi.Input[_builtins.str] name: Name for the decryption rule, must be unique within the policy.
        :param pulumi.Input[_builtins.str] network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param pulumi.Input[Union['NetworkFirewallPolicyDecryptionRulePositionArgs', 'NetworkFirewallPolicyDecryptionRulePositionArgsDict']] position: (Updatable) An object which defines the position of the rule. Only one of `after_rule` or `before_rule` should be provided.
        :param pulumi.Input[_builtins.str] secret: (Updatable) The name of a mapped secret. Its `type` must match that of the specified decryption profile.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkFirewallPolicyDecryptionRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Network Firewall Policy Decryption Rule resource in Oracle Cloud Infrastructure Network Firewall service.

        Creates a new Decryption Rule for the Network Firewall Policy.

        ## Import

        NetworkFirewallPolicyDecryptionRules can be imported using the `name`, e.g.

        ```sh
        $ pulumi import oci:NetworkFirewall/networkFirewallPolicyDecryptionRule:NetworkFirewallPolicyDecryptionRule test_network_firewall_policy_decryption_rule "networkFirewallPolicies/{networkFirewallPolicyId}/decryptionRules/{decryptionRuleName}"
        ```

        :param str resource_name: The name of the resource.
        :param NetworkFirewallPolicyDecryptionRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkFirewallPolicyDecryptionRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 condition: Optional[pulumi.Input[Union['NetworkFirewallPolicyDecryptionRuleConditionArgs', 'NetworkFirewallPolicyDecryptionRuleConditionArgsDict']]] = None,
                 decryption_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 position: Optional[pulumi.Input[Union['NetworkFirewallPolicyDecryptionRulePositionArgs', 'NetworkFirewallPolicyDecryptionRulePositionArgsDict']]] = None,
                 priority_order: Optional[pulumi.Input[_builtins.str]] = None,
                 secret: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkFirewallPolicyDecryptionRuleArgs.__new__(NetworkFirewallPolicyDecryptionRuleArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            if condition is None and not opts.urn:
                raise TypeError("Missing required property 'condition'")
            __props__.__dict__["condition"] = condition
            __props__.__dict__["decryption_profile"] = decryption_profile
            __props__.__dict__["name"] = name
            if network_firewall_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_firewall_policy_id'")
            __props__.__dict__["network_firewall_policy_id"] = network_firewall_policy_id
            __props__.__dict__["position"] = position
            __props__.__dict__["priority_order"] = priority_order
            __props__.__dict__["secret"] = secret
            __props__.__dict__["parent_resource_id"] = None
        super(NetworkFirewallPolicyDecryptionRule, __self__).__init__(
            'oci:NetworkFirewall/networkFirewallPolicyDecryptionRule:NetworkFirewallPolicyDecryptionRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[_builtins.str]] = None,
            condition: Optional[pulumi.Input[Union['NetworkFirewallPolicyDecryptionRuleConditionArgs', 'NetworkFirewallPolicyDecryptionRuleConditionArgsDict']]] = None,
            decryption_profile: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            parent_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            position: Optional[pulumi.Input[Union['NetworkFirewallPolicyDecryptionRulePositionArgs', 'NetworkFirewallPolicyDecryptionRulePositionArgsDict']]] = None,
            priority_order: Optional[pulumi.Input[_builtins.str]] = None,
            secret: Optional[pulumi.Input[_builtins.str]] = None) -> 'NetworkFirewallPolicyDecryptionRule':
        """
        Get an existing NetworkFirewallPolicyDecryptionRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: (Updatable) Action:
               * NO_DECRYPT - Matching traffic is not decrypted.
               * DECRYPT - Matching traffic is decrypted with the specified `secret` according to the specified `decryptionProfile`.
        :param pulumi.Input[Union['NetworkFirewallPolicyDecryptionRuleConditionArgs', 'NetworkFirewallPolicyDecryptionRuleConditionArgsDict']] condition: (Updatable) Match criteria used in Decryption Rule used on the firewall policy rules. The resources mentioned must already be present in the policy before being referenced in the rule.
        :param pulumi.Input[_builtins.str] decryption_profile: (Updatable) The name of the decryption profile to use.
        :param pulumi.Input[_builtins.str] name: Name for the decryption rule, must be unique within the policy.
        :param pulumi.Input[_builtins.str] network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param pulumi.Input[_builtins.str] parent_resource_id: OCID of the Network Firewall Policy this decryption rule belongs to.
        :param pulumi.Input[Union['NetworkFirewallPolicyDecryptionRulePositionArgs', 'NetworkFirewallPolicyDecryptionRulePositionArgsDict']] position: (Updatable) An object which defines the position of the rule. Only one of `after_rule` or `before_rule` should be provided.
        :param pulumi.Input[_builtins.str] secret: (Updatable) The name of a mapped secret. Its `type` must match that of the specified decryption profile.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkFirewallPolicyDecryptionRuleState.__new__(_NetworkFirewallPolicyDecryptionRuleState)

        __props__.__dict__["action"] = action
        __props__.__dict__["condition"] = condition
        __props__.__dict__["decryption_profile"] = decryption_profile
        __props__.__dict__["name"] = name
        __props__.__dict__["network_firewall_policy_id"] = network_firewall_policy_id
        __props__.__dict__["parent_resource_id"] = parent_resource_id
        __props__.__dict__["position"] = position
        __props__.__dict__["priority_order"] = priority_order
        __props__.__dict__["secret"] = secret
        return NetworkFirewallPolicyDecryptionRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Action:
        * NO_DECRYPT - Matching traffic is not decrypted.
        * DECRYPT - Matching traffic is decrypted with the specified `secret` according to the specified `decryptionProfile`.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def condition(self) -> pulumi.Output['outputs.NetworkFirewallPolicyDecryptionRuleCondition']:
        """
        (Updatable) Match criteria used in Decryption Rule used on the firewall policy rules. The resources mentioned must already be present in the policy before being referenced in the rule.
        """
        return pulumi.get(self, "condition")

    @_builtins.property
    @pulumi.getter(name="decryptionProfile")
    def decryption_profile(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Updatable) The name of the decryption profile to use.
        """
        return pulumi.get(self, "decryption_profile")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name for the decryption rule, must be unique within the policy.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique Network Firewall Policy identifier
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @_builtins.property
    @pulumi.getter(name="parentResourceId")
    def parent_resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        OCID of the Network Firewall Policy this decryption rule belongs to.
        """
        return pulumi.get(self, "parent_resource_id")

    @_builtins.property
    @pulumi.getter
    def position(self) -> pulumi.Output['outputs.NetworkFirewallPolicyDecryptionRulePosition']:
        """
        (Updatable) An object which defines the position of the rule. Only one of `after_rule` or `before_rule` should be provided.
        """
        return pulumi.get(self, "position")

    @_builtins.property
    @pulumi.getter(name="priorityOrder")
    def priority_order(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "priority_order")

    @_builtins.property
    @pulumi.getter
    def secret(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Updatable) The name of a mapped secret. Its `type` must match that of the specified decryption profile.
        """
        return pulumi.get(self, "secret")

