# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'BucketRetentionRule',
    'BucketRetentionRuleDuration',
    'ObjectLifecyclePolicyRule',
    'ObjectLifecyclePolicyRuleObjectNameFilter',
    'PrivateEndpointAccessTarget',
    'StorageObjectSourceUriDetails',
    'GetBucketRetentionRuleResult',
    'GetBucketRetentionRuleDurationResult',
    'GetBucketSummariesBucketSummaryResult',
    'GetBucketSummariesBucketSummaryRetentionRuleResult',
    'GetBucketSummariesBucketSummaryRetentionRuleDurationResult',
    'GetBucketSummariesFilterResult',
    'GetObjectLifecyclePolicyRuleResult',
    'GetObjectLifecyclePolicyRuleObjectNameFilterResult',
    'GetObjectVersionsFilterResult',
    'GetObjectVersionsItemResult',
    'GetObjectsFilterResult',
    'GetObjectsObjectResult',
    'GetPreauthrequestsFilterResult',
    'GetPreauthrequestsPreauthenticatedRequestResult',
    'GetPrivateEndpointAccessTargetResult',
    'GetPrivateEndpointSummariesFilterResult',
    'GetPrivateEndpointSummariesPrivateEndpointSummaryResult',
    'GetPrivateEndpointSummariesPrivateEndpointSummaryAccessTargetResult',
    'GetReplicationPoliciesFilterResult',
    'GetReplicationPoliciesReplicationPolicyResult',
    'GetReplicationSourcesFilterResult',
    'GetReplicationSourcesReplicationSourceResult',
]

@pulumi.output_type
class BucketRetentionRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "retentionRuleId":
            suggest = "retention_rule_id"
        elif key == "timeCreated":
            suggest = "time_created"
        elif key == "timeModified":
            suggest = "time_modified"
        elif key == "timeRuleLocked":
            suggest = "time_rule_locked"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketRetentionRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketRetentionRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketRetentionRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: _builtins.str,
                 duration: Optional['outputs.BucketRetentionRuleDuration'] = None,
                 retention_rule_id: Optional[_builtins.str] = None,
                 time_created: Optional[_builtins.str] = None,
                 time_modified: Optional[_builtins.str] = None,
                 time_rule_locked: Optional[_builtins.str] = None):
        """
        :param _builtins.str display_name: A user-specified name for the retention rule. Names can be helpful in identifying retention rules. The name should be unique. This attribute is a forcenew attribute
        :param 'BucketRetentionRuleDurationArgs' duration: (Updatable)
        :param _builtins.str retention_rule_id: Unique identifier for the retention rule.
        :param _builtins.str time_created: The date and time the bucket was created, as described in [RFC 2616](https://tools.ietf.org/html/rfc2616#section-14.29).
        :param _builtins.str time_modified: The date and time that the retention rule was modified as per [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param _builtins.str time_rule_locked: (Updatable) The date and time as per [RFC 3339](https://tools.ietf.org/html/rfc3339) after which this rule is locked and can only be deleted by deleting the bucket. Once a rule is locked, only increases in the duration are allowed and no other properties can be changed. This property cannot be updated for rules that are in a locked state. Specifying it when a duration is not specified is considered an error.
        """
        pulumi.set(__self__, "display_name", display_name)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if retention_rule_id is not None:
            pulumi.set(__self__, "retention_rule_id", retention_rule_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_modified is not None:
            pulumi.set(__self__, "time_modified", time_modified)
        if time_rule_locked is not None:
            pulumi.set(__self__, "time_rule_locked", time_rule_locked)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A user-specified name for the retention rule. Names can be helpful in identifying retention rules. The name should be unique. This attribute is a forcenew attribute
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def duration(self) -> Optional['outputs.BucketRetentionRuleDuration']:
        """
        (Updatable)
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter(name="retentionRuleId")
    def retention_rule_id(self) -> Optional[_builtins.str]:
        """
        Unique identifier for the retention rule.
        """
        return pulumi.get(self, "retention_rule_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[_builtins.str]:
        """
        The date and time the bucket was created, as described in [RFC 2616](https://tools.ietf.org/html/rfc2616#section-14.29).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeModified")
    def time_modified(self) -> Optional[_builtins.str]:
        """
        The date and time that the retention rule was modified as per [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_modified")

    @_builtins.property
    @pulumi.getter(name="timeRuleLocked")
    def time_rule_locked(self) -> Optional[_builtins.str]:
        """
        (Updatable) The date and time as per [RFC 3339](https://tools.ietf.org/html/rfc3339) after which this rule is locked and can only be deleted by deleting the bucket. Once a rule is locked, only increases in the duration are allowed and no other properties can be changed. This property cannot be updated for rules that are in a locked state. Specifying it when a duration is not specified is considered an error.
        """
        return pulumi.get(self, "time_rule_locked")


@pulumi.output_type
class BucketRetentionRuleDuration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeAmount":
            suggest = "time_amount"
        elif key == "timeUnit":
            suggest = "time_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketRetentionRuleDuration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketRetentionRuleDuration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketRetentionRuleDuration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 time_amount: _builtins.str,
                 time_unit: _builtins.str):
        """
        :param _builtins.str time_amount: (Updatable) The timeAmount is interpreted in units defined by the timeUnit parameter, and is calculated in relation to each object's Last-Modified timestamp.
        :param _builtins.str time_unit: (Updatable) The unit that should be used to interpret timeAmount.
        """
        pulumi.set(__self__, "time_amount", time_amount)
        pulumi.set(__self__, "time_unit", time_unit)

    @_builtins.property
    @pulumi.getter(name="timeAmount")
    def time_amount(self) -> _builtins.str:
        """
        (Updatable) The timeAmount is interpreted in units defined by the timeUnit parameter, and is calculated in relation to each object's Last-Modified timestamp.
        """
        return pulumi.get(self, "time_amount")

    @_builtins.property
    @pulumi.getter(name="timeUnit")
    def time_unit(self) -> _builtins.str:
        """
        (Updatable) The unit that should be used to interpret timeAmount.
        """
        return pulumi.get(self, "time_unit")


@pulumi.output_type
class ObjectLifecyclePolicyRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"
        elif key == "timeAmount":
            suggest = "time_amount"
        elif key == "timeUnit":
            suggest = "time_unit"
        elif key == "objectNameFilter":
            suggest = "object_name_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectLifecyclePolicyRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectLifecyclePolicyRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectLifecyclePolicyRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: _builtins.str,
                 is_enabled: _builtins.bool,
                 name: _builtins.str,
                 time_amount: _builtins.str,
                 time_unit: _builtins.str,
                 object_name_filter: Optional['outputs.ObjectLifecyclePolicyRuleObjectNameFilter'] = None,
                 target: Optional[_builtins.str] = None):
        """
        :param _builtins.str action: (Updatable) The action of the object lifecycle policy rule. Rules using the action 'ARCHIVE' move objects from Standard and InfrequentAccess storage tiers into the [Archive storage tier](https://docs.cloud.oracle.com/iaas/Content/Archive/Concepts/archivestorageoverview.htm). Rules using the action 'INFREQUENT_ACCESS' move objects from Standard storage tier into the Infrequent Access Storage tier. Objects that are already in InfrequentAccess tier or in Archive tier are left untouched. Rules using the action 'DELETE' permanently delete objects from buckets. Rules using 'ABORT' abort the uncommitted multipart-uploads and permanently delete their parts from buckets.
        :param _builtins.bool is_enabled: (Updatable) A Boolean that determines whether this rule is currently enabled.
        :param _builtins.str name: (Updatable) The name of the lifecycle rule to be applied.
        :param _builtins.str time_amount: (Updatable) Specifies the age of objects to apply the rule to. The timeAmount is interpreted in units defined by the timeUnit parameter, and is calculated in relation to each object's Last-Modified time.
        :param _builtins.str time_unit: (Updatable) The unit that should be used to interpret timeAmount.  Days are defined as starting and ending at midnight UTC. Years are defined as 365.2425 days long and likewise round up to the next midnight UTC. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param 'ObjectLifecyclePolicyRuleObjectNameFilterArgs' object_name_filter: (Updatable) A filter that compares object names to a set of prefixes or patterns to determine if a rule applies to a given object. The filter can contain include glob patterns, exclude glob patterns and inclusion prefixes. The inclusion prefixes property is kept for backward compatibility. It is recommended to use inclusion patterns instead of prefixes. Exclusions take precedence over inclusions.
        :param _builtins.str target: (Updatable) The target of the object lifecycle policy rule. The values of target can be either "objects", "multipart-uploads" or "previous-object-versions". This field when declared as "objects" is used to specify ARCHIVE, INFREQUENT_ACCESS or DELETE rule for objects. This field when declared as "previous-object-versions" is used to specify ARCHIVE, INFREQUENT_ACCESS or DELETE rule for previous versions of existing objects. This field when declared as "multipart-uploads" is used to specify the ABORT (only) rule for uncommitted multipart-uploads.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "time_amount", time_amount)
        pulumi.set(__self__, "time_unit", time_unit)
        if object_name_filter is not None:
            pulumi.set(__self__, "object_name_filter", object_name_filter)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        (Updatable) The action of the object lifecycle policy rule. Rules using the action 'ARCHIVE' move objects from Standard and InfrequentAccess storage tiers into the [Archive storage tier](https://docs.cloud.oracle.com/iaas/Content/Archive/Concepts/archivestorageoverview.htm). Rules using the action 'INFREQUENT_ACCESS' move objects from Standard storage tier into the Infrequent Access Storage tier. Objects that are already in InfrequentAccess tier or in Archive tier are left untouched. Rules using the action 'DELETE' permanently delete objects from buckets. Rules using 'ABORT' abort the uncommitted multipart-uploads and permanently delete their parts from buckets.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> _builtins.bool:
        """
        (Updatable) A Boolean that determines whether this rule is currently enabled.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        (Updatable) The name of the lifecycle rule to be applied.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="timeAmount")
    def time_amount(self) -> _builtins.str:
        """
        (Updatable) Specifies the age of objects to apply the rule to. The timeAmount is interpreted in units defined by the timeUnit parameter, and is calculated in relation to each object's Last-Modified time.
        """
        return pulumi.get(self, "time_amount")

    @_builtins.property
    @pulumi.getter(name="timeUnit")
    def time_unit(self) -> _builtins.str:
        """
        (Updatable) The unit that should be used to interpret timeAmount.  Days are defined as starting and ending at midnight UTC. Years are defined as 365.2425 days long and likewise round up to the next midnight UTC. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_unit")

    @_builtins.property
    @pulumi.getter(name="objectNameFilter")
    def object_name_filter(self) -> Optional['outputs.ObjectLifecyclePolicyRuleObjectNameFilter']:
        """
        (Updatable) A filter that compares object names to a set of prefixes or patterns to determine if a rule applies to a given object. The filter can contain include glob patterns, exclude glob patterns and inclusion prefixes. The inclusion prefixes property is kept for backward compatibility. It is recommended to use inclusion patterns instead of prefixes. Exclusions take precedence over inclusions.
        """
        return pulumi.get(self, "object_name_filter")

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional[_builtins.str]:
        """
        (Updatable) The target of the object lifecycle policy rule. The values of target can be either "objects", "multipart-uploads" or "previous-object-versions". This field when declared as "objects" is used to specify ARCHIVE, INFREQUENT_ACCESS or DELETE rule for objects. This field when declared as "previous-object-versions" is used to specify ARCHIVE, INFREQUENT_ACCESS or DELETE rule for previous versions of existing objects. This field when declared as "multipart-uploads" is used to specify the ABORT (only) rule for uncommitted multipart-uploads.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class ObjectLifecyclePolicyRuleObjectNameFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exclusionPatterns":
            suggest = "exclusion_patterns"
        elif key == "inclusionPatterns":
            suggest = "inclusion_patterns"
        elif key == "inclusionPrefixes":
            suggest = "inclusion_prefixes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectLifecyclePolicyRuleObjectNameFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectLifecyclePolicyRuleObjectNameFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectLifecyclePolicyRuleObjectNameFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exclusion_patterns: Optional[Sequence[_builtins.str]] = None,
                 inclusion_patterns: Optional[Sequence[_builtins.str]] = None,
                 inclusion_prefixes: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] exclusion_patterns: (Updatable) An array of glob patterns to match the object names to exclude. An empty array is ignored. Exclusion patterns take precedence over inclusion patterns. A Glob pattern is a sequence of characters to match text. Any character that appears in the pattern, other than the special pattern characters described below, matches itself. Glob patterns must be between 1 and 1024 characters.
               
               The special pattern characters have the following meanings:
               
               \\           Escapes the following character
               *           Matches any string of characters. ?           Matches any single character . [...]       Matches a group of characters. A group of characters can be: A set of characters, for example: [Zafg9@]. This matches any character in the brackets. A range of characters, for example: [a-z]. This matches any character in the range. [a-f] is equivalent to [abcdef]. For character ranges only the CHARACTER-CHARACTER pattern is supported. [ab-yz] is not valid [a-mn-z] is not valid Character ranges can not start with ^ or : To include a '-' in the range, make it the first or last character.
        :param Sequence[_builtins.str] inclusion_patterns: (Updatable) An array of glob patterns to match the object names to include. An empty array includes all objects in the bucket. Exclusion patterns take precedence over inclusion patterns. A Glob pattern is a sequence of characters to match text. Any character that appears in the pattern, other than the special pattern characters described below, matches itself. Glob patterns must be between 1 and 1024 characters.
               
               The special pattern characters have the following meanings:
               
               \\           Escapes the following character
               *           Matches any string of characters. ?           Matches any single character . [...]       Matches a group of characters. A group of characters can be: A set of characters, for example: [Zafg9@]. This matches any character in the brackets. A range of characters, for example: [a-z]. This matches any character in the range. [a-f] is equivalent to [abcdef]. For character ranges only the CHARACTER-CHARACTER pattern is supported. [ab-yz] is not valid [a-mn-z] is not valid Character ranges can not start with ^ or : To include a '-' in the range, make it the first or last character.
        :param Sequence[_builtins.str] inclusion_prefixes: (Updatable) An array of object name prefixes that the rule will apply to. An empty array means to include all objects.
        """
        if exclusion_patterns is not None:
            pulumi.set(__self__, "exclusion_patterns", exclusion_patterns)
        if inclusion_patterns is not None:
            pulumi.set(__self__, "inclusion_patterns", inclusion_patterns)
        if inclusion_prefixes is not None:
            pulumi.set(__self__, "inclusion_prefixes", inclusion_prefixes)

    @_builtins.property
    @pulumi.getter(name="exclusionPatterns")
    def exclusion_patterns(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Updatable) An array of glob patterns to match the object names to exclude. An empty array is ignored. Exclusion patterns take precedence over inclusion patterns. A Glob pattern is a sequence of characters to match text. Any character that appears in the pattern, other than the special pattern characters described below, matches itself. Glob patterns must be between 1 and 1024 characters.

        The special pattern characters have the following meanings:

        \\           Escapes the following character
        *           Matches any string of characters. ?           Matches any single character . [...]       Matches a group of characters. A group of characters can be: A set of characters, for example: [Zafg9@]. This matches any character in the brackets. A range of characters, for example: [a-z]. This matches any character in the range. [a-f] is equivalent to [abcdef]. For character ranges only the CHARACTER-CHARACTER pattern is supported. [ab-yz] is not valid [a-mn-z] is not valid Character ranges can not start with ^ or : To include a '-' in the range, make it the first or last character.
        """
        return pulumi.get(self, "exclusion_patterns")

    @_builtins.property
    @pulumi.getter(name="inclusionPatterns")
    def inclusion_patterns(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Updatable) An array of glob patterns to match the object names to include. An empty array includes all objects in the bucket. Exclusion patterns take precedence over inclusion patterns. A Glob pattern is a sequence of characters to match text. Any character that appears in the pattern, other than the special pattern characters described below, matches itself. Glob patterns must be between 1 and 1024 characters.

        The special pattern characters have the following meanings:

        \\           Escapes the following character
        *           Matches any string of characters. ?           Matches any single character . [...]       Matches a group of characters. A group of characters can be: A set of characters, for example: [Zafg9@]. This matches any character in the brackets. A range of characters, for example: [a-z]. This matches any character in the range. [a-f] is equivalent to [abcdef]. For character ranges only the CHARACTER-CHARACTER pattern is supported. [ab-yz] is not valid [a-mn-z] is not valid Character ranges can not start with ^ or : To include a '-' in the range, make it the first or last character.
        """
        return pulumi.get(self, "inclusion_patterns")

    @_builtins.property
    @pulumi.getter(name="inclusionPrefixes")
    def inclusion_prefixes(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Updatable) An array of object name prefixes that the rule will apply to. An empty array means to include all objects.
        """
        return pulumi.get(self, "inclusion_prefixes")


@pulumi.output_type
class PrivateEndpointAccessTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compartmentId":
            suggest = "compartment_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointAccessTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointAccessTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointAccessTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: _builtins.str,
                 compartment_id: _builtins.str,
                 namespace: _builtins.str):
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "namespace", namespace)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        return pulumi.get(self, "namespace")


@pulumi.output_type
class StorageObjectSourceUriDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationObjectIfMatchEtag":
            suggest = "destination_object_if_match_etag"
        elif key == "destinationObjectIfNoneMatchEtag":
            suggest = "destination_object_if_none_match_etag"
        elif key == "sourceObjectIfMatchEtag":
            suggest = "source_object_if_match_etag"
        elif key == "sourceVersionId":
            suggest = "source_version_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageObjectSourceUriDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageObjectSourceUriDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageObjectSourceUriDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: _builtins.str,
                 namespace: _builtins.str,
                 object: _builtins.str,
                 region: _builtins.str,
                 destination_object_if_match_etag: Optional[_builtins.str] = None,
                 destination_object_if_none_match_etag: Optional[_builtins.str] = None,
                 source_object_if_match_etag: Optional[_builtins.str] = None,
                 source_version_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str bucket: The name of the bucket for the source object.
        :param _builtins.str namespace: The top-level namespace of the source object.
        :param _builtins.str object: The name of the source object.
        :param _builtins.str region: The region of the source object.
        :param _builtins.str destination_object_if_match_etag: The entity tag to match the target object.
        :param _builtins.str destination_object_if_none_match_etag: The entity tag to not match the target object.
        :param _builtins.str source_object_if_match_etag: The entity tag to match the source object.
        :param _builtins.str source_version_id: The version id of the object to be restored.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)
        pulumi.set(__self__, "region", region)
        if destination_object_if_match_etag is not None:
            pulumi.set(__self__, "destination_object_if_match_etag", destination_object_if_match_etag)
        if destination_object_if_none_match_etag is not None:
            pulumi.set(__self__, "destination_object_if_none_match_etag", destination_object_if_none_match_etag)
        if source_object_if_match_etag is not None:
            pulumi.set(__self__, "source_object_if_match_etag", source_object_if_match_etag)
        if source_version_id is not None:
            pulumi.set(__self__, "source_version_id", source_version_id)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        The name of the bucket for the source object.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        The top-level namespace of the source object.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def object(self) -> _builtins.str:
        """
        The name of the source object.
        """
        return pulumi.get(self, "object")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region of the source object.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="destinationObjectIfMatchEtag")
    def destination_object_if_match_etag(self) -> Optional[_builtins.str]:
        """
        The entity tag to match the target object.
        """
        return pulumi.get(self, "destination_object_if_match_etag")

    @_builtins.property
    @pulumi.getter(name="destinationObjectIfNoneMatchEtag")
    def destination_object_if_none_match_etag(self) -> Optional[_builtins.str]:
        """
        The entity tag to not match the target object.
        """
        return pulumi.get(self, "destination_object_if_none_match_etag")

    @_builtins.property
    @pulumi.getter(name="sourceObjectIfMatchEtag")
    def source_object_if_match_etag(self) -> Optional[_builtins.str]:
        """
        The entity tag to match the source object.
        """
        return pulumi.get(self, "source_object_if_match_etag")

    @_builtins.property
    @pulumi.getter(name="sourceVersionId")
    def source_version_id(self) -> Optional[_builtins.str]:
        """
        The version id of the object to be restored.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "source_version_id")


@pulumi.output_type
class GetBucketRetentionRuleResult(dict):
    def __init__(__self__, *,
                 display_name: _builtins.str,
                 durations: Sequence['outputs.GetBucketRetentionRuleDurationResult'],
                 retention_rule_id: _builtins.str,
                 time_created: _builtins.str,
                 time_modified: _builtins.str,
                 time_rule_locked: _builtins.str):
        """
        :param _builtins.str display_name: User specified name for the retention rule.
        :param _builtins.str retention_rule_id: Unique identifier for the retention rule.
        :param _builtins.str time_created: The date and time the bucket was created, as described in [RFC 2616](https://tools.ietf.org/html/rfc2616#section-14.29).
        :param _builtins.str time_modified: The date and time that the retention rule was modified as per [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param _builtins.str time_rule_locked: The date and time as per [RFC 3339](https://tools.ietf.org/html/rfc3339) after which this rule becomes locked. and can only be deleted by deleting the bucket.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "durations", durations)
        pulumi.set(__self__, "retention_rule_id", retention_rule_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_modified", time_modified)
        pulumi.set(__self__, "time_rule_locked", time_rule_locked)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        User specified name for the retention rule.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def durations(self) -> Sequence['outputs.GetBucketRetentionRuleDurationResult']:
        return pulumi.get(self, "durations")

    @_builtins.property
    @pulumi.getter(name="retentionRuleId")
    def retention_rule_id(self) -> _builtins.str:
        """
        Unique identifier for the retention rule.
        """
        return pulumi.get(self, "retention_rule_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the bucket was created, as described in [RFC 2616](https://tools.ietf.org/html/rfc2616#section-14.29).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeModified")
    def time_modified(self) -> _builtins.str:
        """
        The date and time that the retention rule was modified as per [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_modified")

    @_builtins.property
    @pulumi.getter(name="timeRuleLocked")
    def time_rule_locked(self) -> _builtins.str:
        """
        The date and time as per [RFC 3339](https://tools.ietf.org/html/rfc3339) after which this rule becomes locked. and can only be deleted by deleting the bucket.
        """
        return pulumi.get(self, "time_rule_locked")


@pulumi.output_type
class GetBucketRetentionRuleDurationResult(dict):
    def __init__(__self__, *,
                 time_amount: _builtins.str,
                 time_unit: _builtins.str):
        """
        :param _builtins.str time_amount: The timeAmount is interpreted in units defined by the timeUnit parameter, and is calculated in relation to each object's Last-Modified timestamp.
        :param _builtins.str time_unit: The unit that should be used to interpret timeAmount.
        """
        pulumi.set(__self__, "time_amount", time_amount)
        pulumi.set(__self__, "time_unit", time_unit)

    @_builtins.property
    @pulumi.getter(name="timeAmount")
    def time_amount(self) -> _builtins.str:
        """
        The timeAmount is interpreted in units defined by the timeUnit parameter, and is calculated in relation to each object's Last-Modified timestamp.
        """
        return pulumi.get(self, "time_amount")

    @_builtins.property
    @pulumi.getter(name="timeUnit")
    def time_unit(self) -> _builtins.str:
        """
        The unit that should be used to interpret timeAmount.
        """
        return pulumi.get(self, "time_unit")


@pulumi.output_type
class GetBucketSummariesBucketSummaryResult(dict):
    def __init__(__self__, *,
                 access_type: _builtins.str,
                 approximate_count: _builtins.str,
                 approximate_size: _builtins.str,
                 auto_tiering: _builtins.str,
                 bucket_id: _builtins.str,
                 compartment_id: _builtins.str,
                 created_by: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 etag: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 is_read_only: _builtins.bool,
                 kms_key_id: _builtins.str,
                 metadata: Mapping[str, _builtins.str],
                 name: _builtins.str,
                 namespace: _builtins.str,
                 object_events_enabled: _builtins.bool,
                 object_lifecycle_policy_etag: _builtins.str,
                 replication_enabled: _builtins.bool,
                 retention_rules: Sequence['outputs.GetBucketSummariesBucketSummaryRetentionRuleResult'],
                 storage_tier: _builtins.str,
                 time_created: _builtins.str,
                 versioning: _builtins.str):
        """
        :param _builtins.str access_type: The type of public access enabled on this bucket. A bucket is set to `NoPublicAccess` by default, which only allows an authenticated caller to access the bucket and its contents. When `ObjectRead` is enabled on the bucket, public access is allowed for the `GetObject`, `HeadObject`, and `ListObjects` operations. When `ObjectReadWithoutList` is enabled on the bucket, public access is allowed for the `GetObject` and `HeadObject` operations.
        :param _builtins.str approximate_count: The approximate number of objects in the bucket. Count statistics are reported periodically. You will see a lag between what is displayed and the actual object count.
        :param _builtins.str approximate_size: The approximate total size in bytes of all objects in the bucket. Size statistics are reported periodically. You will see a lag between what is displayed and the actual size of the bucket.
        :param _builtins.str auto_tiering: The auto tiering status on the bucket. A bucket is created with auto tiering `Disabled` by default. For auto tiering `InfrequentAccess`, objects are transitioned automatically between the 'Standard' and 'InfrequentAccess' tiers based on the access pattern of the objects.
        :param _builtins.str compartment_id: The ID of the compartment in which to list buckets.
        :param _builtins.str created_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the bucket.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str etag: The entity tag (ETag) for the bucket.
        :param Mapping[str, _builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param _builtins.bool is_read_only: Whether or not this bucket is read only. By default, `isReadOnly` is set to `false`. This will be set to 'true' when this bucket is configured as a destination in a replication policy.
        :param _builtins.str kms_key_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a master encryption key used to call the Key Management service to generate a data encryption key or to encrypt or decrypt a data encryption key.
        :param Mapping[str, _builtins.str] metadata: Arbitrary string keys and values for user-defined metadata.
        :param _builtins.str name: The name of the bucket. Avoid entering confidential information. Example: my-new-bucket1
        :param _builtins.str namespace: The Object Storage namespace used for the request.
        :param _builtins.bool object_events_enabled: Whether or not events are emitted for object state changes in this bucket. By default, `objectEventsEnabled` is set to `false`. Set `objectEventsEnabled` to `true` to emit events for object state changes. For more information about events, see [Overview of Events](https://docs.cloud.oracle.com/iaas/Content/Events/Concepts/eventsoverview.htm).
        :param _builtins.str object_lifecycle_policy_etag: The entity tag (ETag) for the live object lifecycle policy on the bucket.
        :param _builtins.bool replication_enabled: Whether or not this bucket is a replication source. By default, `replicationEnabled` is set to `false`. This will be set to 'true' when you create a replication policy for the bucket.
        :param _builtins.str storage_tier: The storage tier type assigned to the bucket. A bucket is set to `Standard` tier by default, which means objects uploaded or copied to the bucket will be in the standard storage tier. When the `Archive` tier type is set explicitly for a bucket, objects uploaded or copied to the bucket will be stored in archive storage. The `storageTier` property is immutable after bucket is created.
        :param _builtins.str time_created: The date and time the bucket was created, as described in [RFC 2616](https://tools.ietf.org/html/rfc2616#section-14.29).
        :param _builtins.str versioning: The versioning status on the bucket. A bucket is created with versioning `Disabled` by default. For versioning `Enabled`, objects are protected from overwrites and deletes, by maintaining their version history. When versioning is `Suspended`, the previous versions will still remain but new versions will no longer be created when overwitten or deleted.
        """
        pulumi.set(__self__, "access_type", access_type)
        pulumi.set(__self__, "approximate_count", approximate_count)
        pulumi.set(__self__, "approximate_size", approximate_size)
        pulumi.set(__self__, "auto_tiering", auto_tiering)
        pulumi.set(__self__, "bucket_id", bucket_id)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "created_by", created_by)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_read_only", is_read_only)
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object_events_enabled", object_events_enabled)
        pulumi.set(__self__, "object_lifecycle_policy_etag", object_lifecycle_policy_etag)
        pulumi.set(__self__, "replication_enabled", replication_enabled)
        pulumi.set(__self__, "retention_rules", retention_rules)
        pulumi.set(__self__, "storage_tier", storage_tier)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "versioning", versioning)

    @_builtins.property
    @pulumi.getter(name="accessType")
    def access_type(self) -> _builtins.str:
        """
        The type of public access enabled on this bucket. A bucket is set to `NoPublicAccess` by default, which only allows an authenticated caller to access the bucket and its contents. When `ObjectRead` is enabled on the bucket, public access is allowed for the `GetObject`, `HeadObject`, and `ListObjects` operations. When `ObjectReadWithoutList` is enabled on the bucket, public access is allowed for the `GetObject` and `HeadObject` operations.
        """
        return pulumi.get(self, "access_type")

    @_builtins.property
    @pulumi.getter(name="approximateCount")
    def approximate_count(self) -> _builtins.str:
        """
        The approximate number of objects in the bucket. Count statistics are reported periodically. You will see a lag between what is displayed and the actual object count.
        """
        return pulumi.get(self, "approximate_count")

    @_builtins.property
    @pulumi.getter(name="approximateSize")
    def approximate_size(self) -> _builtins.str:
        """
        The approximate total size in bytes of all objects in the bucket. Size statistics are reported periodically. You will see a lag between what is displayed and the actual size of the bucket.
        """
        return pulumi.get(self, "approximate_size")

    @_builtins.property
    @pulumi.getter(name="autoTiering")
    def auto_tiering(self) -> _builtins.str:
        """
        The auto tiering status on the bucket. A bucket is created with auto tiering `Disabled` by default. For auto tiering `InfrequentAccess`, objects are transitioned automatically between the 'Standard' and 'InfrequentAccess' tiers based on the access pattern of the objects.
        """
        return pulumi.get(self, "auto_tiering")

    @_builtins.property
    @pulumi.getter(name="bucketId")
    def bucket_id(self) -> _builtins.str:
        return pulumi.get(self, "bucket_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The ID of the compartment in which to list buckets.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the bucket.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> _builtins.str:
        """
        The entity tag (ETag) for the bucket.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isReadOnly")
    def is_read_only(self) -> _builtins.bool:
        """
        Whether or not this bucket is read only. By default, `isReadOnly` is set to `false`. This will be set to 'true' when this bucket is configured as a destination in a replication policy.
        """
        return pulumi.get(self, "is_read_only")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a master encryption key used to call the Key Management service to generate a data encryption key or to encrypt or decrypt a data encryption key.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Mapping[str, _builtins.str]:
        """
        Arbitrary string keys and values for user-defined metadata.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the bucket. Avoid entering confidential information. Example: my-new-bucket1
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        The Object Storage namespace used for the request.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="objectEventsEnabled")
    def object_events_enabled(self) -> _builtins.bool:
        """
        Whether or not events are emitted for object state changes in this bucket. By default, `objectEventsEnabled` is set to `false`. Set `objectEventsEnabled` to `true` to emit events for object state changes. For more information about events, see [Overview of Events](https://docs.cloud.oracle.com/iaas/Content/Events/Concepts/eventsoverview.htm).
        """
        return pulumi.get(self, "object_events_enabled")

    @_builtins.property
    @pulumi.getter(name="objectLifecyclePolicyEtag")
    def object_lifecycle_policy_etag(self) -> _builtins.str:
        """
        The entity tag (ETag) for the live object lifecycle policy on the bucket.
        """
        return pulumi.get(self, "object_lifecycle_policy_etag")

    @_builtins.property
    @pulumi.getter(name="replicationEnabled")
    def replication_enabled(self) -> _builtins.bool:
        """
        Whether or not this bucket is a replication source. By default, `replicationEnabled` is set to `false`. This will be set to 'true' when you create a replication policy for the bucket.
        """
        return pulumi.get(self, "replication_enabled")

    @_builtins.property
    @pulumi.getter(name="retentionRules")
    def retention_rules(self) -> Sequence['outputs.GetBucketSummariesBucketSummaryRetentionRuleResult']:
        return pulumi.get(self, "retention_rules")

    @_builtins.property
    @pulumi.getter(name="storageTier")
    def storage_tier(self) -> _builtins.str:
        """
        The storage tier type assigned to the bucket. A bucket is set to `Standard` tier by default, which means objects uploaded or copied to the bucket will be in the standard storage tier. When the `Archive` tier type is set explicitly for a bucket, objects uploaded or copied to the bucket will be stored in archive storage. The `storageTier` property is immutable after bucket is created.
        """
        return pulumi.get(self, "storage_tier")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the bucket was created, as described in [RFC 2616](https://tools.ietf.org/html/rfc2616#section-14.29).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter
    def versioning(self) -> _builtins.str:
        """
        The versioning status on the bucket. A bucket is created with versioning `Disabled` by default. For versioning `Enabled`, objects are protected from overwrites and deletes, by maintaining their version history. When versioning is `Suspended`, the previous versions will still remain but new versions will no longer be created when overwitten or deleted.
        """
        return pulumi.get(self, "versioning")


@pulumi.output_type
class GetBucketSummariesBucketSummaryRetentionRuleResult(dict):
    def __init__(__self__, *,
                 display_name: _builtins.str,
                 durations: Sequence['outputs.GetBucketSummariesBucketSummaryRetentionRuleDurationResult'],
                 retention_rule_id: _builtins.str,
                 time_created: _builtins.str,
                 time_modified: _builtins.str,
                 time_rule_locked: _builtins.str):
        """
        :param _builtins.str time_created: The date and time the bucket was created, as described in [RFC 2616](https://tools.ietf.org/html/rfc2616#section-14.29).
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "durations", durations)
        pulumi.set(__self__, "retention_rule_id", retention_rule_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_modified", time_modified)
        pulumi.set(__self__, "time_rule_locked", time_rule_locked)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def durations(self) -> Sequence['outputs.GetBucketSummariesBucketSummaryRetentionRuleDurationResult']:
        return pulumi.get(self, "durations")

    @_builtins.property
    @pulumi.getter(name="retentionRuleId")
    def retention_rule_id(self) -> _builtins.str:
        return pulumi.get(self, "retention_rule_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the bucket was created, as described in [RFC 2616](https://tools.ietf.org/html/rfc2616#section-14.29).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeModified")
    def time_modified(self) -> _builtins.str:
        return pulumi.get(self, "time_modified")

    @_builtins.property
    @pulumi.getter(name="timeRuleLocked")
    def time_rule_locked(self) -> _builtins.str:
        return pulumi.get(self, "time_rule_locked")


@pulumi.output_type
class GetBucketSummariesBucketSummaryRetentionRuleDurationResult(dict):
    def __init__(__self__, *,
                 time_amount: _builtins.str,
                 time_unit: _builtins.str):
        pulumi.set(__self__, "time_amount", time_amount)
        pulumi.set(__self__, "time_unit", time_unit)

    @_builtins.property
    @pulumi.getter(name="timeAmount")
    def time_amount(self) -> _builtins.str:
        return pulumi.get(self, "time_amount")

    @_builtins.property
    @pulumi.getter(name="timeUnit")
    def time_unit(self) -> _builtins.str:
        return pulumi.get(self, "time_unit")


@pulumi.output_type
class GetBucketSummariesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: The name of the bucket. Avoid entering confidential information. Example: my-new-bucket1
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the bucket. Avoid entering confidential information. Example: my-new-bucket1
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetObjectLifecyclePolicyRuleResult(dict):
    def __init__(__self__, *,
                 action: _builtins.str,
                 is_enabled: _builtins.bool,
                 name: _builtins.str,
                 object_name_filters: Sequence['outputs.GetObjectLifecyclePolicyRuleObjectNameFilterResult'],
                 target: _builtins.str,
                 time_amount: _builtins.str,
                 time_unit: _builtins.str):
        """
        :param _builtins.str action: The action of the object lifecycle policy rule. Rules using the action 'ARCHIVE' move objects from Standard and InfrequentAccess storage tiers into the [Archive storage tier](https://docs.cloud.oracle.com/iaas/Content/Archive/Concepts/archivestorageoverview.htm). Rules using the action 'INFREQUENT_ACCESS' move objects from Standard storage tier into the Infrequent Access Storage tier. Objects that are already in InfrequentAccess tier or in Archive tier are left untouched. Rules using the action 'DELETE' permanently delete objects from buckets. Rules using 'ABORT' abort the uncommitted multipart-uploads and permanently delete their parts from buckets.
        :param _builtins.bool is_enabled: A Boolean that determines whether this rule is currently enabled.
        :param _builtins.str name: The name of the lifecycle rule to be applied.
        :param Sequence['GetObjectLifecyclePolicyRuleObjectNameFilterArgs'] object_name_filters: A filter that compares object names to a set of prefixes or patterns to determine if a rule applies to a given object. The filter can contain include glob patterns, exclude glob patterns and inclusion prefixes. The inclusion prefixes property is kept for backward compatibility. It is recommended to use inclusion patterns instead of prefixes. Exclusions take precedence over inclusions.
        :param _builtins.str target: The target of the object lifecycle policy rule. The values of target can be either "objects", "multipart-uploads" or "previous-object-versions". This field when declared as "objects" is used to specify ARCHIVE, INFREQUENT_ACCESS or DELETE rule for objects. This field when declared as "previous-object-versions" is used to specify ARCHIVE, INFREQUENT_ACCESS or DELETE rule for previous versions of existing objects. This field when declared as "multipart-uploads" is used to specify the ABORT (only) rule for uncommitted multipart-uploads.
        :param _builtins.str time_amount: Specifies the age of objects to apply the rule to. The timeAmount is interpreted in units defined by the timeUnit parameter, and is calculated in relation to each object's Last-Modified time.
        :param _builtins.str time_unit: The unit that should be used to interpret timeAmount.  Days are defined as starting and ending at midnight UTC. Years are defined as 365.2425 days long and likewise round up to the next midnight UTC.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "object_name_filters", object_name_filters)
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "time_amount", time_amount)
        pulumi.set(__self__, "time_unit", time_unit)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        The action of the object lifecycle policy rule. Rules using the action 'ARCHIVE' move objects from Standard and InfrequentAccess storage tiers into the [Archive storage tier](https://docs.cloud.oracle.com/iaas/Content/Archive/Concepts/archivestorageoverview.htm). Rules using the action 'INFREQUENT_ACCESS' move objects from Standard storage tier into the Infrequent Access Storage tier. Objects that are already in InfrequentAccess tier or in Archive tier are left untouched. Rules using the action 'DELETE' permanently delete objects from buckets. Rules using 'ABORT' abort the uncommitted multipart-uploads and permanently delete their parts from buckets.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> _builtins.bool:
        """
        A Boolean that determines whether this rule is currently enabled.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the lifecycle rule to be applied.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="objectNameFilters")
    def object_name_filters(self) -> Sequence['outputs.GetObjectLifecyclePolicyRuleObjectNameFilterResult']:
        """
        A filter that compares object names to a set of prefixes or patterns to determine if a rule applies to a given object. The filter can contain include glob patterns, exclude glob patterns and inclusion prefixes. The inclusion prefixes property is kept for backward compatibility. It is recommended to use inclusion patterns instead of prefixes. Exclusions take precedence over inclusions.
        """
        return pulumi.get(self, "object_name_filters")

    @_builtins.property
    @pulumi.getter
    def target(self) -> _builtins.str:
        """
        The target of the object lifecycle policy rule. The values of target can be either "objects", "multipart-uploads" or "previous-object-versions". This field when declared as "objects" is used to specify ARCHIVE, INFREQUENT_ACCESS or DELETE rule for objects. This field when declared as "previous-object-versions" is used to specify ARCHIVE, INFREQUENT_ACCESS or DELETE rule for previous versions of existing objects. This field when declared as "multipart-uploads" is used to specify the ABORT (only) rule for uncommitted multipart-uploads.
        """
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter(name="timeAmount")
    def time_amount(self) -> _builtins.str:
        """
        Specifies the age of objects to apply the rule to. The timeAmount is interpreted in units defined by the timeUnit parameter, and is calculated in relation to each object's Last-Modified time.
        """
        return pulumi.get(self, "time_amount")

    @_builtins.property
    @pulumi.getter(name="timeUnit")
    def time_unit(self) -> _builtins.str:
        """
        The unit that should be used to interpret timeAmount.  Days are defined as starting and ending at midnight UTC. Years are defined as 365.2425 days long and likewise round up to the next midnight UTC.
        """
        return pulumi.get(self, "time_unit")


@pulumi.output_type
class GetObjectLifecyclePolicyRuleObjectNameFilterResult(dict):
    def __init__(__self__, *,
                 exclusion_patterns: Sequence[_builtins.str],
                 inclusion_patterns: Sequence[_builtins.str],
                 inclusion_prefixes: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] exclusion_patterns: An array of glob patterns to match the object names to exclude. An empty array is ignored. Exclusion patterns take precedence over inclusion patterns. A Glob pattern is a sequence of characters to match text. Any character that appears in the pattern, other than the special pattern characters described below, matches itself. Glob patterns must be between 1 and 1024 characters.
        :param Sequence[_builtins.str] inclusion_patterns: An array of glob patterns to match the object names to include. An empty array includes all objects in the bucket. Exclusion patterns take precedence over inclusion patterns. A Glob pattern is a sequence of characters to match text. Any character that appears in the pattern, other than the special pattern characters described below, matches itself. Glob patterns must be between 1 and 1024 characters.
        :param Sequence[_builtins.str] inclusion_prefixes: An array of object name prefixes that the rule will apply to. An empty array means to include all objects.
        """
        pulumi.set(__self__, "exclusion_patterns", exclusion_patterns)
        pulumi.set(__self__, "inclusion_patterns", inclusion_patterns)
        pulumi.set(__self__, "inclusion_prefixes", inclusion_prefixes)

    @_builtins.property
    @pulumi.getter(name="exclusionPatterns")
    def exclusion_patterns(self) -> Sequence[_builtins.str]:
        """
        An array of glob patterns to match the object names to exclude. An empty array is ignored. Exclusion patterns take precedence over inclusion patterns. A Glob pattern is a sequence of characters to match text. Any character that appears in the pattern, other than the special pattern characters described below, matches itself. Glob patterns must be between 1 and 1024 characters.
        """
        return pulumi.get(self, "exclusion_patterns")

    @_builtins.property
    @pulumi.getter(name="inclusionPatterns")
    def inclusion_patterns(self) -> Sequence[_builtins.str]:
        """
        An array of glob patterns to match the object names to include. An empty array includes all objects in the bucket. Exclusion patterns take precedence over inclusion patterns. A Glob pattern is a sequence of characters to match text. Any character that appears in the pattern, other than the special pattern characters described below, matches itself. Glob patterns must be between 1 and 1024 characters.
        """
        return pulumi.get(self, "inclusion_patterns")

    @_builtins.property
    @pulumi.getter(name="inclusionPrefixes")
    def inclusion_prefixes(self) -> Sequence[_builtins.str]:
        """
        An array of object name prefixes that the rule will apply to. An empty array means to include all objects.
        """
        return pulumi.get(self, "inclusion_prefixes")


@pulumi.output_type
class GetObjectVersionsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: The name of the object. Avoid entering confidential information. Example: test/object1.log
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the object. Avoid entering confidential information. Example: test/object1.log
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetObjectVersionsItemResult(dict):
    def __init__(__self__, *,
                 archival_state: _builtins.str,
                 etag: _builtins.str,
                 is_delete_marker: _builtins.bool,
                 md5: _builtins.str,
                 name: _builtins.str,
                 size: _builtins.str,
                 storage_tier: _builtins.str,
                 time_created: _builtins.str,
                 time_modified: _builtins.str,
                 version_id: _builtins.str):
        """
        :param _builtins.str archival_state: Archival state of an object. This field is set only for objects in Archive tier.
        :param _builtins.str etag: The current entity tag (ETag) for the object.
        :param _builtins.bool is_delete_marker: This flag will indicate if the version is deleted or not.
        :param _builtins.str md5: Base64-encoded MD5 hash of the object data.
        :param _builtins.str name: The name of the object. Avoid entering confidential information. Example: test/object1.log
        :param _builtins.str size: Size of the object in bytes.
        :param _builtins.str storage_tier: The storage tier that the object is stored in.
        :param _builtins.str time_created: The date and time the object was created, as described in [RFC 2616](https://tools.ietf.org/html/rfc2616#section-14.29).
        :param _builtins.str time_modified: The date and time the object was modified, as described in [RFC 2616](https://tools.ietf.org/rfc/rfc2616#section-14.29).
        :param _builtins.str version_id: VersionId of the object.
        """
        pulumi.set(__self__, "archival_state", archival_state)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "is_delete_marker", is_delete_marker)
        pulumi.set(__self__, "md5", md5)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "storage_tier", storage_tier)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_modified", time_modified)
        pulumi.set(__self__, "version_id", version_id)

    @_builtins.property
    @pulumi.getter(name="archivalState")
    def archival_state(self) -> _builtins.str:
        """
        Archival state of an object. This field is set only for objects in Archive tier.
        """
        return pulumi.get(self, "archival_state")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> _builtins.str:
        """
        The current entity tag (ETag) for the object.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter(name="isDeleteMarker")
    def is_delete_marker(self) -> _builtins.bool:
        """
        This flag will indicate if the version is deleted or not.
        """
        return pulumi.get(self, "is_delete_marker")

    @_builtins.property
    @pulumi.getter
    def md5(self) -> _builtins.str:
        """
        Base64-encoded MD5 hash of the object data.
        """
        return pulumi.get(self, "md5")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the object. Avoid entering confidential information. Example: test/object1.log
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.str:
        """
        Size of the object in bytes.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="storageTier")
    def storage_tier(self) -> _builtins.str:
        """
        The storage tier that the object is stored in.
        """
        return pulumi.get(self, "storage_tier")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the object was created, as described in [RFC 2616](https://tools.ietf.org/html/rfc2616#section-14.29).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeModified")
    def time_modified(self) -> _builtins.str:
        """
        The date and time the object was modified, as described in [RFC 2616](https://tools.ietf.org/rfc/rfc2616#section-14.29).
        """
        return pulumi.get(self, "time_modified")

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> _builtins.str:
        """
        VersionId of the object.
        """
        return pulumi.get(self, "version_id")


@pulumi.output_type
class GetObjectsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: The name of the object.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the object.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetObjectsObjectResult(dict):
    def __init__(__self__, *,
                 archival_state: _builtins.str,
                 etag: _builtins.str,
                 md5: _builtins.str,
                 name: _builtins.str,
                 size: _builtins.str,
                 storage_tier: _builtins.str,
                 time_created: _builtins.str,
                 time_modified: _builtins.str):
        """
        :param _builtins.str etag: The current entity tag (ETag) for the object.
        :param _builtins.str md5: Base64-encoded MD5 hash of the object data.
        :param _builtins.str name: The name of the object.
        :param _builtins.str size: Size of the object in bytes.
        :param _builtins.str storage_tier: The storage tier that the object is stored in.
               * `archival-state` - Archival state of an object. This field is set only for objects in Archive tier.
        :param _builtins.str time_created: The date and time the object was created, as described in [RFC 2616](https://tools.ietf.org/html/rfc2616#section-14.29).
        :param _builtins.str time_modified: The date and time the object was modified, as described in [RFC 2616](https://tools.ietf.org/rfc/rfc2616#section-14.29).
        """
        pulumi.set(__self__, "archival_state", archival_state)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "md5", md5)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "storage_tier", storage_tier)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_modified", time_modified)

    @_builtins.property
    @pulumi.getter(name="archivalState")
    def archival_state(self) -> _builtins.str:
        return pulumi.get(self, "archival_state")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> _builtins.str:
        """
        The current entity tag (ETag) for the object.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def md5(self) -> _builtins.str:
        """
        Base64-encoded MD5 hash of the object data.
        """
        return pulumi.get(self, "md5")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the object.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.str:
        """
        Size of the object in bytes.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="storageTier")
    def storage_tier(self) -> _builtins.str:
        """
        The storage tier that the object is stored in.
        * `archival-state` - Archival state of an object. This field is set only for objects in Archive tier.
        """
        return pulumi.get(self, "storage_tier")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the object was created, as described in [RFC 2616](https://tools.ietf.org/html/rfc2616#section-14.29).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeModified")
    def time_modified(self) -> _builtins.str:
        """
        The date and time the object was modified, as described in [RFC 2616](https://tools.ietf.org/rfc/rfc2616#section-14.29).
        """
        return pulumi.get(self, "time_modified")


@pulumi.output_type
class GetPreauthrequestsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: The user-provided name of the pre-authenticated request.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The user-provided name of the pre-authenticated request.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetPreauthrequestsPreauthenticatedRequestResult(dict):
    def __init__(__self__, *,
                 access_type: _builtins.str,
                 access_uri: _builtins.str,
                 bucket: _builtins.str,
                 bucket_listing_action: _builtins.str,
                 full_path: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str,
                 namespace: _builtins.str,
                 object: _builtins.str,
                 object_name: _builtins.str,
                 par_id: _builtins.str,
                 time_created: _builtins.str,
                 time_expires: _builtins.str):
        """
        :param _builtins.str access_type: The operation that can be performed on this resource.
        :param _builtins.str access_uri: The URI to embed in the URL when using the pre-authenticated request.
        :param _builtins.str bucket: The name of the bucket. Avoid entering confidential information. Example: `my-new-bucket1`
        :param _builtins.str bucket_listing_action: Specifies whether a list operation is allowed on a PAR with accessType "AnyObjectRead" or "AnyObjectReadWrite". Deny: Prevents the user from performing a list operation. ListObjects: Authorizes the user to perform a list operation.
        :param _builtins.str id: The unique identifier to use when directly addressing the pre-authenticated request.
        :param _builtins.str name: The user-provided name of the pre-authenticated request.
        :param _builtins.str namespace: The Object Storage namespace used for the request.
        :param _builtins.str object: Deprecated. Instead use `object_name`.The name of the object that is being granted access to by the pre-authenticated request. Avoid entering confidential information. The object name can be null and if so, the pre-authenticated request grants access to the entire bucket. Example: test/object1.log
        :param _builtins.str object_name: The name of the object that is being granted access to by the pre-authenticated request. Avoid entering confidential information. The object name can be null and if so, the pre-authenticated request grants access to the entire bucket. Example: test/object1.log
        :param _builtins.str time_created: The date when the pre-authenticated request was created as per specification [RFC 3339](https://tools.ietf.org/html/rfc3339).
        :param _builtins.str time_expires: The expiration date for the pre-authenticated request as per [RFC 3339](https://tools.ietf.org/html/rfc3339). After this date the pre-authenticated request will no longer be valid.
        """
        pulumi.set(__self__, "access_type", access_type)
        pulumi.set(__self__, "access_uri", access_uri)
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "bucket_listing_action", bucket_listing_action)
        pulumi.set(__self__, "full_path", full_path)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)
        pulumi.set(__self__, "object_name", object_name)
        pulumi.set(__self__, "par_id", par_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_expires", time_expires)

    @_builtins.property
    @pulumi.getter(name="accessType")
    def access_type(self) -> _builtins.str:
        """
        The operation that can be performed on this resource.
        """
        return pulumi.get(self, "access_type")

    @_builtins.property
    @pulumi.getter(name="accessUri")
    def access_uri(self) -> _builtins.str:
        """
        The URI to embed in the URL when using the pre-authenticated request.
        """
        return pulumi.get(self, "access_uri")

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        The name of the bucket. Avoid entering confidential information. Example: `my-new-bucket1`
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="bucketListingAction")
    def bucket_listing_action(self) -> _builtins.str:
        """
        Specifies whether a list operation is allowed on a PAR with accessType "AnyObjectRead" or "AnyObjectReadWrite". Deny: Prevents the user from performing a list operation. ListObjects: Authorizes the user to perform a list operation.
        """
        return pulumi.get(self, "bucket_listing_action")

    @_builtins.property
    @pulumi.getter(name="fullPath")
    def full_path(self) -> _builtins.str:
        return pulumi.get(self, "full_path")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique identifier to use when directly addressing the pre-authenticated request.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The user-provided name of the pre-authenticated request.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        The Object Storage namespace used for the request.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""The 'object' field has been deprecated. Please use 'object_name' instead.""")
    def object(self) -> _builtins.str:
        """
        Deprecated. Instead use `object_name`.The name of the object that is being granted access to by the pre-authenticated request. Avoid entering confidential information. The object name can be null and if so, the pre-authenticated request grants access to the entire bucket. Example: test/object1.log
        """
        return pulumi.get(self, "object")

    @_builtins.property
    @pulumi.getter(name="objectName")
    def object_name(self) -> _builtins.str:
        """
        The name of the object that is being granted access to by the pre-authenticated request. Avoid entering confidential information. The object name can be null and if so, the pre-authenticated request grants access to the entire bucket. Example: test/object1.log
        """
        return pulumi.get(self, "object_name")

    @_builtins.property
    @pulumi.getter(name="parId")
    def par_id(self) -> _builtins.str:
        return pulumi.get(self, "par_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date when the pre-authenticated request was created as per specification [RFC 3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeExpires")
    def time_expires(self) -> _builtins.str:
        """
        The expiration date for the pre-authenticated request as per [RFC 3339](https://tools.ietf.org/html/rfc3339). After this date the pre-authenticated request will no longer be valid.
        """
        return pulumi.get(self, "time_expires")


@pulumi.output_type
class GetPrivateEndpointAccessTargetResult(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 compartment_id: _builtins.str,
                 namespace: _builtins.str):
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "namespace", namespace)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        return pulumi.get(self, "namespace")


@pulumi.output_type
class GetPrivateEndpointSummariesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetPrivateEndpointSummariesPrivateEndpointSummaryResult(dict):
    def __init__(__self__, *,
                 access_targets: Sequence['outputs.GetPrivateEndpointSummariesPrivateEndpointSummaryAccessTargetResult'],
                 additional_prefixes: Sequence[_builtins.str],
                 compartment_id: _builtins.str,
                 created_by: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 etag: _builtins.str,
                 fqdns: Mapping[str, Mapping[str, Mapping[str, _builtins.str]]],
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 name: _builtins.str,
                 namespace: _builtins.str,
                 nsg_ids: Sequence[_builtins.str],
                 prefix: _builtins.str,
                 private_endpoint_ip: _builtins.str,
                 state: _builtins.str,
                 subnet_id: _builtins.str,
                 time_created: _builtins.str,
                 time_modified: _builtins.str):
        pulumi.set(__self__, "access_targets", access_targets)
        pulumi.set(__self__, "additional_prefixes", additional_prefixes)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "created_by", created_by)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "fqdns", fqdns)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "prefix", prefix)
        pulumi.set(__self__, "private_endpoint_ip", private_endpoint_ip)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_modified", time_modified)

    @_builtins.property
    @pulumi.getter(name="accessTargets")
    def access_targets(self) -> Sequence['outputs.GetPrivateEndpointSummariesPrivateEndpointSummaryAccessTargetResult']:
        return pulumi.get(self, "access_targets")

    @_builtins.property
    @pulumi.getter(name="additionalPrefixes")
    def additional_prefixes(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "additional_prefixes")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> _builtins.str:
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> _builtins.str:
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def fqdns(self) -> Mapping[str, Mapping[str, Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "fqdns")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "nsg_ids")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> _builtins.str:
        return pulumi.get(self, "prefix")

    @_builtins.property
    @pulumi.getter(name="privateEndpointIp")
    def private_endpoint_ip(self) -> _builtins.str:
        return pulumi.get(self, "private_endpoint_ip")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeModified")
    def time_modified(self) -> _builtins.str:
        return pulumi.get(self, "time_modified")


@pulumi.output_type
class GetPrivateEndpointSummariesPrivateEndpointSummaryAccessTargetResult(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 compartment_id: _builtins.str,
                 namespace: _builtins.str):
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "namespace", namespace)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        return pulumi.get(self, "namespace")


@pulumi.output_type
class GetReplicationPoliciesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: The name of the policy.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the policy.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetReplicationPoliciesReplicationPolicyResult(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 delete_object_in_destination_bucket: _builtins.str,
                 destination_bucket_name: _builtins.str,
                 destination_region_name: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str,
                 namespace: _builtins.str,
                 status: _builtins.str,
                 status_message: _builtins.str,
                 time_created: _builtins.str,
                 time_last_sync: _builtins.str):
        """
        :param _builtins.str bucket: The name of the bucket. Avoid entering confidential information. Example: `my-new-bucket1`
        :param _builtins.str destination_bucket_name: The bucket to replicate to in the destination region. Replication policy creation does not automatically create a destination bucket. Create the destination bucket before creating the policy.
        :param _builtins.str destination_region_name: The destination region to replicate to, for example "us-ashburn-1".
        :param _builtins.str id: The id of the replication policy.
        :param _builtins.str name: The name of the policy.
        :param _builtins.str namespace: The Object Storage namespace used for the request.
        :param _builtins.str status: The replication status of the policy. If the status is CLIENT_ERROR, once the user fixes the issue described in the status message, the status will become ACTIVE.
        :param _builtins.str status_message: A human-readable description of the status.
        :param _builtins.str time_created: The date when the replication policy was created as per [RFC 3339](https://tools.ietf.org/html/rfc3339).
        :param _builtins.str time_last_sync: Changes made to the source bucket before this time has been replicated.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "delete_object_in_destination_bucket", delete_object_in_destination_bucket)
        pulumi.set(__self__, "destination_bucket_name", destination_bucket_name)
        pulumi.set(__self__, "destination_region_name", destination_region_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_message", status_message)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_last_sync", time_last_sync)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        The name of the bucket. Avoid entering confidential information. Example: `my-new-bucket1`
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="deleteObjectInDestinationBucket")
    @_utilities.deprecated("""The 'delete_object_in_destination_bucket' field has been deprecated. It is no longer supported.""")
    def delete_object_in_destination_bucket(self) -> _builtins.str:
        return pulumi.get(self, "delete_object_in_destination_bucket")

    @_builtins.property
    @pulumi.getter(name="destinationBucketName")
    def destination_bucket_name(self) -> _builtins.str:
        """
        The bucket to replicate to in the destination region. Replication policy creation does not automatically create a destination bucket. Create the destination bucket before creating the policy.
        """
        return pulumi.get(self, "destination_bucket_name")

    @_builtins.property
    @pulumi.getter(name="destinationRegionName")
    def destination_region_name(self) -> _builtins.str:
        """
        The destination region to replicate to, for example "us-ashburn-1".
        """
        return pulumi.get(self, "destination_region_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the replication policy.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the policy.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        The Object Storage namespace used for the request.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The replication status of the policy. If the status is CLIENT_ERROR, once the user fixes the issue described in the status message, the status will become ACTIVE.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> _builtins.str:
        """
        A human-readable description of the status.
        """
        return pulumi.get(self, "status_message")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date when the replication policy was created as per [RFC 3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeLastSync")
    def time_last_sync(self) -> _builtins.str:
        """
        Changes made to the source bucket before this time has been replicated.
        """
        return pulumi.get(self, "time_last_sync")


@pulumi.output_type
class GetReplicationSourcesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetReplicationSourcesReplicationSourceResult(dict):
    def __init__(__self__, *,
                 policy_name: _builtins.str,
                 source_bucket_name: _builtins.str,
                 source_region_name: _builtins.str):
        """
        :param _builtins.str policy_name: The name of the policy.
        :param _builtins.str source_bucket_name: The source bucket replicating data from.
        :param _builtins.str source_region_name: The source region replicating data from, for example "us-ashburn-1".
        """
        pulumi.set(__self__, "policy_name", policy_name)
        pulumi.set(__self__, "source_bucket_name", source_bucket_name)
        pulumi.set(__self__, "source_region_name", source_region_name)

    @_builtins.property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> _builtins.str:
        """
        The name of the policy.
        """
        return pulumi.get(self, "policy_name")

    @_builtins.property
    @pulumi.getter(name="sourceBucketName")
    def source_bucket_name(self) -> _builtins.str:
        """
        The source bucket replicating data from.
        """
        return pulumi.get(self, "source_bucket_name")

    @_builtins.property
    @pulumi.getter(name="sourceRegionName")
    def source_region_name(self) -> _builtins.str:
        """
        The source region replicating data from, for example "us-ashburn-1".
        """
        return pulumi.get(self, "source_region_name")


