# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'VbInstanceAlternateCustomEndpoint',
    'VbInstanceCustomEndpoint',
    'VbInstanceNetworkEndpointDetails',
    'VbInstanceNetworkEndpointDetailsAllowlistedHttpVcn',
    'GetVbInstanceAlternateCustomEndpointResult',
    'GetVbInstanceApplicationsApplicationSummaryCollectionResult',
    'GetVbInstanceApplicationsApplicationSummaryCollectionItemResult',
    'GetVbInstanceCustomEndpointResult',
    'GetVbInstanceNetworkEndpointDetailResult',
    'GetVbInstanceNetworkEndpointDetailAllowlistedHttpVcnResult',
    'GetVbInstancesFilterResult',
    'GetVbInstancesVbInstanceSummaryCollectionResult',
    'GetVbInstancesVbInstanceSummaryCollectionItemResult',
    'GetVbInstancesVbInstanceSummaryCollectionItemAlternateCustomEndpointResult',
    'GetVbInstancesVbInstanceSummaryCollectionItemCustomEndpointResult',
    'GetVbInstancesVbInstanceSummaryCollectionItemNetworkEndpointDetailResult',
    'GetVbInstancesVbInstanceSummaryCollectionItemNetworkEndpointDetailAllowlistedHttpVcnResult',
]

@pulumi.output_type
class VbInstanceAlternateCustomEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateSecretId":
            suggest = "certificate_secret_id"
        elif key == "certificateSecretVersion":
            suggest = "certificate_secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VbInstanceAlternateCustomEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VbInstanceAlternateCustomEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VbInstanceAlternateCustomEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hostname: _builtins.str,
                 certificate_secret_id: Optional[_builtins.str] = None,
                 certificate_secret_version: Optional[_builtins.int] = None):
        """
        :param _builtins.str hostname: (Updatable) A custom hostname to be used for the vb instance URL, in FQDN format.
        :param _builtins.str certificate_secret_id: (Updatable) Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname. All certificates should be stored in a single base64 encoded secret Note the update will fail if this is not a valid certificate.
        :param _builtins.int certificate_secret_version: The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        pulumi.set(__self__, "hostname", hostname)
        if certificate_secret_id is not None:
            pulumi.set(__self__, "certificate_secret_id", certificate_secret_id)
        if certificate_secret_version is not None:
            pulumi.set(__self__, "certificate_secret_version", certificate_secret_version)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        (Updatable) A custom hostname to be used for the vb instance URL, in FQDN format.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter(name="certificateSecretId")
    def certificate_secret_id(self) -> Optional[_builtins.str]:
        """
        (Updatable) Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname. All certificates should be stored in a single base64 encoded secret Note the update will fail if this is not a valid certificate.
        """
        return pulumi.get(self, "certificate_secret_id")

    @_builtins.property
    @pulumi.getter(name="certificateSecretVersion")
    def certificate_secret_version(self) -> Optional[_builtins.int]:
        """
        The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        return pulumi.get(self, "certificate_secret_version")


@pulumi.output_type
class VbInstanceCustomEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateSecretId":
            suggest = "certificate_secret_id"
        elif key == "certificateSecretVersion":
            suggest = "certificate_secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VbInstanceCustomEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VbInstanceCustomEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VbInstanceCustomEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hostname: _builtins.str,
                 certificate_secret_id: Optional[_builtins.str] = None,
                 certificate_secret_version: Optional[_builtins.int] = None):
        """
        :param _builtins.str hostname: (Updatable) A custom hostname to be used for the vb instance URL, in FQDN format.
        :param _builtins.str certificate_secret_id: (Updatable) Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname. All certificates should be stored in a single base64 encoded secret Note the update will fail if this is not a valid certificate.
        :param _builtins.int certificate_secret_version: The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        pulumi.set(__self__, "hostname", hostname)
        if certificate_secret_id is not None:
            pulumi.set(__self__, "certificate_secret_id", certificate_secret_id)
        if certificate_secret_version is not None:
            pulumi.set(__self__, "certificate_secret_version", certificate_secret_version)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        (Updatable) A custom hostname to be used for the vb instance URL, in FQDN format.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter(name="certificateSecretId")
    def certificate_secret_id(self) -> Optional[_builtins.str]:
        """
        (Updatable) Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname. All certificates should be stored in a single base64 encoded secret Note the update will fail if this is not a valid certificate.
        """
        return pulumi.get(self, "certificate_secret_id")

    @_builtins.property
    @pulumi.getter(name="certificateSecretVersion")
    def certificate_secret_version(self) -> Optional[_builtins.int]:
        """
        The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        return pulumi.get(self, "certificate_secret_version")


@pulumi.output_type
class VbInstanceNetworkEndpointDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkEndpointType":
            suggest = "network_endpoint_type"
        elif key == "allowlistedHttpIps":
            suggest = "allowlisted_http_ips"
        elif key == "allowlistedHttpVcns":
            suggest = "allowlisted_http_vcns"
        elif key == "networkSecurityGroupIds":
            suggest = "network_security_group_ids"
        elif key == "privateEndpointIp":
            suggest = "private_endpoint_ip"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VbInstanceNetworkEndpointDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VbInstanceNetworkEndpointDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VbInstanceNetworkEndpointDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_endpoint_type: _builtins.str,
                 allowlisted_http_ips: Optional[Sequence[_builtins.str]] = None,
                 allowlisted_http_vcns: Optional[Sequence['outputs.VbInstanceNetworkEndpointDetailsAllowlistedHttpVcn']] = None,
                 network_security_group_ids: Optional[Sequence[_builtins.str]] = None,
                 private_endpoint_ip: Optional[_builtins.str] = None,
                 subnet_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str network_endpoint_type: (Updatable) The type of network endpoint.
               
               For private endpoint access
        :param Sequence[_builtins.str] allowlisted_http_ips: (Updatable) Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5/32", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        :param Sequence['VbInstanceNetworkEndpointDetailsAllowlistedHttpVcnArgs'] allowlisted_http_vcns: (Updatable) Virtual Cloud Networks allowed to access this network endpoint.
        :param Sequence[_builtins.str] network_security_group_ids: (Updatable) Network Security Group OCIDs for the Private Endpoint.
        :param _builtins.str private_endpoint_ip: The IP address to be assigned to Private Endpoint
        :param _builtins.str subnet_id: (Updatable) The subnet OCID for the private endpoint.
               
               For public network access control
        """
        pulumi.set(__self__, "network_endpoint_type", network_endpoint_type)
        if allowlisted_http_ips is not None:
            pulumi.set(__self__, "allowlisted_http_ips", allowlisted_http_ips)
        if allowlisted_http_vcns is not None:
            pulumi.set(__self__, "allowlisted_http_vcns", allowlisted_http_vcns)
        if network_security_group_ids is not None:
            pulumi.set(__self__, "network_security_group_ids", network_security_group_ids)
        if private_endpoint_ip is not None:
            pulumi.set(__self__, "private_endpoint_ip", private_endpoint_ip)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="networkEndpointType")
    def network_endpoint_type(self) -> _builtins.str:
        """
        (Updatable) The type of network endpoint.

        For private endpoint access
        """
        return pulumi.get(self, "network_endpoint_type")

    @_builtins.property
    @pulumi.getter(name="allowlistedHttpIps")
    def allowlisted_http_ips(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Updatable) Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5/32", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        """
        return pulumi.get(self, "allowlisted_http_ips")

    @_builtins.property
    @pulumi.getter(name="allowlistedHttpVcns")
    def allowlisted_http_vcns(self) -> Optional[Sequence['outputs.VbInstanceNetworkEndpointDetailsAllowlistedHttpVcn']]:
        """
        (Updatable) Virtual Cloud Networks allowed to access this network endpoint.
        """
        return pulumi.get(self, "allowlisted_http_vcns")

    @_builtins.property
    @pulumi.getter(name="networkSecurityGroupIds")
    def network_security_group_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Updatable) Network Security Group OCIDs for the Private Endpoint.
        """
        return pulumi.get(self, "network_security_group_ids")

    @_builtins.property
    @pulumi.getter(name="privateEndpointIp")
    def private_endpoint_ip(self) -> Optional[_builtins.str]:
        """
        The IP address to be assigned to Private Endpoint
        """
        return pulumi.get(self, "private_endpoint_ip")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[_builtins.str]:
        """
        (Updatable) The subnet OCID for the private endpoint.

        For public network access control
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class VbInstanceNetworkEndpointDetailsAllowlistedHttpVcn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowlistedIpCidrs":
            suggest = "allowlisted_ip_cidrs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VbInstanceNetworkEndpointDetailsAllowlistedHttpVcn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VbInstanceNetworkEndpointDetailsAllowlistedHttpVcn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VbInstanceNetworkEndpointDetailsAllowlistedHttpVcn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: _builtins.str,
                 allowlisted_ip_cidrs: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str id: (Updatable) The Virtual Cloud Network OCID.
        :param Sequence[_builtins.str] allowlisted_ip_cidrs: (Updatable) Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5/32", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        """
        pulumi.set(__self__, "id", id)
        if allowlisted_ip_cidrs is not None:
            pulumi.set(__self__, "allowlisted_ip_cidrs", allowlisted_ip_cidrs)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        (Updatable) The Virtual Cloud Network OCID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="allowlistedIpCidrs")
    def allowlisted_ip_cidrs(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Updatable) Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5/32", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        """
        return pulumi.get(self, "allowlisted_ip_cidrs")


@pulumi.output_type
class GetVbInstanceAlternateCustomEndpointResult(dict):
    def __init__(__self__, *,
                 certificate_secret_id: _builtins.str,
                 certificate_secret_version: _builtins.int,
                 hostname: _builtins.str):
        """
        :param _builtins.str certificate_secret_id: Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        :param _builtins.int certificate_secret_version: The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        :param _builtins.str hostname: A custom hostname to be used for the vb instance URL, in FQDN format.
        """
        pulumi.set(__self__, "certificate_secret_id", certificate_secret_id)
        pulumi.set(__self__, "certificate_secret_version", certificate_secret_version)
        pulumi.set(__self__, "hostname", hostname)

    @_builtins.property
    @pulumi.getter(name="certificateSecretId")
    def certificate_secret_id(self) -> _builtins.str:
        """
        Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        """
        return pulumi.get(self, "certificate_secret_id")

    @_builtins.property
    @pulumi.getter(name="certificateSecretVersion")
    def certificate_secret_version(self) -> _builtins.int:
        """
        The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        return pulumi.get(self, "certificate_secret_version")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        A custom hostname to be used for the vb instance URL, in FQDN format.
        """
        return pulumi.get(self, "hostname")


@pulumi.output_type
class GetVbInstanceApplicationsApplicationSummaryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetVbInstanceApplicationsApplicationSummaryCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetVbInstanceApplicationsApplicationSummaryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetVbInstanceApplicationsApplicationSummaryCollectionItemResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 project_id: _builtins.str,
                 state: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str id: The Visual Builder application identifier.
        :param _builtins.str project_id: The Visual Builder application project identifier.
        :param _builtins.str state: The state of visual builder application. Either LIVE or STAGED
        :param _builtins.str version: The Visual Builder application version
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The Visual Builder application identifier.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        """
        The Visual Builder application project identifier.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The state of visual builder application. Either LIVE or STAGED
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The Visual Builder application version
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetVbInstanceCustomEndpointResult(dict):
    def __init__(__self__, *,
                 certificate_secret_id: _builtins.str,
                 certificate_secret_version: _builtins.int,
                 hostname: _builtins.str):
        """
        :param _builtins.str certificate_secret_id: Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        :param _builtins.int certificate_secret_version: The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        :param _builtins.str hostname: A custom hostname to be used for the vb instance URL, in FQDN format.
        """
        pulumi.set(__self__, "certificate_secret_id", certificate_secret_id)
        pulumi.set(__self__, "certificate_secret_version", certificate_secret_version)
        pulumi.set(__self__, "hostname", hostname)

    @_builtins.property
    @pulumi.getter(name="certificateSecretId")
    def certificate_secret_id(self) -> _builtins.str:
        """
        Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        """
        return pulumi.get(self, "certificate_secret_id")

    @_builtins.property
    @pulumi.getter(name="certificateSecretVersion")
    def certificate_secret_version(self) -> _builtins.int:
        """
        The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        return pulumi.get(self, "certificate_secret_version")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        A custom hostname to be used for the vb instance URL, in FQDN format.
        """
        return pulumi.get(self, "hostname")


@pulumi.output_type
class GetVbInstanceNetworkEndpointDetailResult(dict):
    def __init__(__self__, *,
                 allowlisted_http_ips: Sequence[_builtins.str],
                 allowlisted_http_vcns: Sequence['outputs.GetVbInstanceNetworkEndpointDetailAllowlistedHttpVcnResult'],
                 network_endpoint_type: _builtins.str,
                 network_security_group_ids: Sequence[_builtins.str],
                 private_endpoint_ip: _builtins.str,
                 subnet_id: _builtins.str):
        """
        :param Sequence[_builtins.str] allowlisted_http_ips: Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5/32", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        :param Sequence['GetVbInstanceNetworkEndpointDetailAllowlistedHttpVcnArgs'] allowlisted_http_vcns: Virtual Cloud Networks allowed to access this network endpoint.
        :param _builtins.str network_endpoint_type: The type of network endpoint.
        :param Sequence[_builtins.str] network_security_group_ids: Network Security Group OCIDs for the Private Endpoint.
        :param _builtins.str private_endpoint_ip: The IP address to be assigned to Private Endpoint
        :param _builtins.str subnet_id: The subnet OCID for the private endpoint.
        """
        pulumi.set(__self__, "allowlisted_http_ips", allowlisted_http_ips)
        pulumi.set(__self__, "allowlisted_http_vcns", allowlisted_http_vcns)
        pulumi.set(__self__, "network_endpoint_type", network_endpoint_type)
        pulumi.set(__self__, "network_security_group_ids", network_security_group_ids)
        pulumi.set(__self__, "private_endpoint_ip", private_endpoint_ip)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="allowlistedHttpIps")
    def allowlisted_http_ips(self) -> Sequence[_builtins.str]:
        """
        Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5/32", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        """
        return pulumi.get(self, "allowlisted_http_ips")

    @_builtins.property
    @pulumi.getter(name="allowlistedHttpVcns")
    def allowlisted_http_vcns(self) -> Sequence['outputs.GetVbInstanceNetworkEndpointDetailAllowlistedHttpVcnResult']:
        """
        Virtual Cloud Networks allowed to access this network endpoint.
        """
        return pulumi.get(self, "allowlisted_http_vcns")

    @_builtins.property
    @pulumi.getter(name="networkEndpointType")
    def network_endpoint_type(self) -> _builtins.str:
        """
        The type of network endpoint.
        """
        return pulumi.get(self, "network_endpoint_type")

    @_builtins.property
    @pulumi.getter(name="networkSecurityGroupIds")
    def network_security_group_ids(self) -> Sequence[_builtins.str]:
        """
        Network Security Group OCIDs for the Private Endpoint.
        """
        return pulumi.get(self, "network_security_group_ids")

    @_builtins.property
    @pulumi.getter(name="privateEndpointIp")
    def private_endpoint_ip(self) -> _builtins.str:
        """
        The IP address to be assigned to Private Endpoint
        """
        return pulumi.get(self, "private_endpoint_ip")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        The subnet OCID for the private endpoint.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetVbInstanceNetworkEndpointDetailAllowlistedHttpVcnResult(dict):
    def __init__(__self__, *,
                 allowlisted_ip_cidrs: Sequence[_builtins.str],
                 id: _builtins.str):
        """
        :param Sequence[_builtins.str] allowlisted_ip_cidrs: Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5/32", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        :param _builtins.str id: The Virtual Cloud Network OCID.
        """
        pulumi.set(__self__, "allowlisted_ip_cidrs", allowlisted_ip_cidrs)
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="allowlistedIpCidrs")
    def allowlisted_ip_cidrs(self) -> Sequence[_builtins.str]:
        """
        Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5/32", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        """
        return pulumi.get(self, "allowlisted_ip_cidrs")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The Virtual Cloud Network OCID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetVbInstancesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetVbInstancesVbInstanceSummaryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetVbInstancesVbInstanceSummaryCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetVbInstancesVbInstanceSummaryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetVbInstancesVbInstanceSummaryCollectionItemResult(dict):
    def __init__(__self__, *,
                 alternate_custom_endpoints: Sequence['outputs.GetVbInstancesVbInstanceSummaryCollectionItemAlternateCustomEndpointResult'],
                 compartment_id: _builtins.str,
                 consumption_model: _builtins.str,
                 custom_endpoints: Sequence['outputs.GetVbInstancesVbInstanceSummaryCollectionItemCustomEndpointResult'],
                 defined_tags: Mapping[str, _builtins.str],
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 idcs_open_id: _builtins.str,
                 instance_url: _builtins.str,
                 is_visual_builder_enabled: _builtins.bool,
                 management_nat_gateway_ip: _builtins.str,
                 management_vcn_id: _builtins.str,
                 network_endpoint_details: Sequence['outputs.GetVbInstancesVbInstanceSummaryCollectionItemNetworkEndpointDetailResult'],
                 node_count: _builtins.int,
                 service_nat_gateway_ip: _builtins.str,
                 service_vcn_id: _builtins.str,
                 state: _builtins.str,
                 state_message: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param Sequence['GetVbInstancesVbInstanceSummaryCollectionItemAlternateCustomEndpointArgs'] alternate_custom_endpoints: A list of alternate custom endpoints used for the vb instance URL.
        :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param _builtins.str consumption_model: The entitlement used for billing purposes.
        :param Sequence['GetVbInstancesVbInstanceSummaryCollectionItemCustomEndpointArgs'] custom_endpoints: Details for a custom endpoint for the vb instance.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param _builtins.str display_name: A user-friendly name. Does not have to be unique, and it's changeable.  Example: `My new resource`
        :param Mapping[str, _builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param _builtins.str id: The Virtual Cloud Network OCID.
        :param _builtins.str instance_url: The Vb Instance URL.
        :param _builtins.bool is_visual_builder_enabled: Visual Builder is enabled or not.
        :param _builtins.str management_nat_gateway_ip: The NAT gateway IP address for the VB management VCN
        :param _builtins.str management_vcn_id: The Oracle Cloud ID (OCID) of the Visual Builder management VCN
        :param Sequence['GetVbInstancesVbInstanceSummaryCollectionItemNetworkEndpointDetailArgs'] network_endpoint_details: Base representation of a network endpoint. In input payload to update an Visual Builder instance endpoint details, an empty payload will clear out any existing configuration for Public Visual Builder instance.
        :param _builtins.int node_count: The number of Nodes
        :param _builtins.str service_nat_gateway_ip: The NAT gateway IP address for the VB service VCN
        :param _builtins.str service_vcn_id: The Oracle Cloud ID (OCID) of the Visual Builder service VCN
        :param _builtins.str state: Life cycle state to query on.
        :param _builtins.str state_message: An message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param Mapping[str, _builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param _builtins.str time_created: The time the the VbInstance was created. An RFC3339 formatted datetime string.
        :param _builtins.str time_updated: The time the VbInstance was updated. An RFC3339 formatted datetime string.
        """
        pulumi.set(__self__, "alternate_custom_endpoints", alternate_custom_endpoints)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "consumption_model", consumption_model)
        pulumi.set(__self__, "custom_endpoints", custom_endpoints)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "idcs_open_id", idcs_open_id)
        pulumi.set(__self__, "instance_url", instance_url)
        pulumi.set(__self__, "is_visual_builder_enabled", is_visual_builder_enabled)
        pulumi.set(__self__, "management_nat_gateway_ip", management_nat_gateway_ip)
        pulumi.set(__self__, "management_vcn_id", management_vcn_id)
        pulumi.set(__self__, "network_endpoint_details", network_endpoint_details)
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "service_nat_gateway_ip", service_nat_gateway_ip)
        pulumi.set(__self__, "service_vcn_id", service_vcn_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "state_message", state_message)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="alternateCustomEndpoints")
    def alternate_custom_endpoints(self) -> Sequence['outputs.GetVbInstancesVbInstanceSummaryCollectionItemAlternateCustomEndpointResult']:
        """
        A list of alternate custom endpoints used for the vb instance URL.
        """
        return pulumi.get(self, "alternate_custom_endpoints")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="consumptionModel")
    def consumption_model(self) -> _builtins.str:
        """
        The entitlement used for billing purposes.
        """
        return pulumi.get(self, "consumption_model")

    @_builtins.property
    @pulumi.getter(name="customEndpoints")
    def custom_endpoints(self) -> Sequence['outputs.GetVbInstancesVbInstanceSummaryCollectionItemCustomEndpointResult']:
        """
        Details for a custom endpoint for the vb instance.
        """
        return pulumi.get(self, "custom_endpoints")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The Virtual Cloud Network OCID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="idcsOpenId")
    def idcs_open_id(self) -> _builtins.str:
        return pulumi.get(self, "idcs_open_id")

    @_builtins.property
    @pulumi.getter(name="instanceUrl")
    def instance_url(self) -> _builtins.str:
        """
        The Vb Instance URL.
        """
        return pulumi.get(self, "instance_url")

    @_builtins.property
    @pulumi.getter(name="isVisualBuilderEnabled")
    def is_visual_builder_enabled(self) -> _builtins.bool:
        """
        Visual Builder is enabled or not.
        """
        return pulumi.get(self, "is_visual_builder_enabled")

    @_builtins.property
    @pulumi.getter(name="managementNatGatewayIp")
    def management_nat_gateway_ip(self) -> _builtins.str:
        """
        The NAT gateway IP address for the VB management VCN
        """
        return pulumi.get(self, "management_nat_gateway_ip")

    @_builtins.property
    @pulumi.getter(name="managementVcnId")
    def management_vcn_id(self) -> _builtins.str:
        """
        The Oracle Cloud ID (OCID) of the Visual Builder management VCN
        """
        return pulumi.get(self, "management_vcn_id")

    @_builtins.property
    @pulumi.getter(name="networkEndpointDetails")
    def network_endpoint_details(self) -> Sequence['outputs.GetVbInstancesVbInstanceSummaryCollectionItemNetworkEndpointDetailResult']:
        """
        Base representation of a network endpoint. In input payload to update an Visual Builder instance endpoint details, an empty payload will clear out any existing configuration for Public Visual Builder instance.
        """
        return pulumi.get(self, "network_endpoint_details")

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> _builtins.int:
        """
        The number of Nodes
        """
        return pulumi.get(self, "node_count")

    @_builtins.property
    @pulumi.getter(name="serviceNatGatewayIp")
    def service_nat_gateway_ip(self) -> _builtins.str:
        """
        The NAT gateway IP address for the VB service VCN
        """
        return pulumi.get(self, "service_nat_gateway_ip")

    @_builtins.property
    @pulumi.getter(name="serviceVcnId")
    def service_vcn_id(self) -> _builtins.str:
        """
        The Oracle Cloud ID (OCID) of the Visual Builder service VCN
        """
        return pulumi.get(self, "service_vcn_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        Life cycle state to query on.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> _builtins.str:
        """
        An message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "state_message")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the the VbInstance was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time the VbInstance was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetVbInstancesVbInstanceSummaryCollectionItemAlternateCustomEndpointResult(dict):
    def __init__(__self__, *,
                 certificate_secret_id: _builtins.str,
                 certificate_secret_version: _builtins.int,
                 hostname: _builtins.str):
        """
        :param _builtins.str certificate_secret_id: Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        :param _builtins.int certificate_secret_version: The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        :param _builtins.str hostname: A custom hostname to be used for the vb instance URL, in FQDN format.
        """
        pulumi.set(__self__, "certificate_secret_id", certificate_secret_id)
        pulumi.set(__self__, "certificate_secret_version", certificate_secret_version)
        pulumi.set(__self__, "hostname", hostname)

    @_builtins.property
    @pulumi.getter(name="certificateSecretId")
    def certificate_secret_id(self) -> _builtins.str:
        """
        Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        """
        return pulumi.get(self, "certificate_secret_id")

    @_builtins.property
    @pulumi.getter(name="certificateSecretVersion")
    def certificate_secret_version(self) -> _builtins.int:
        """
        The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        return pulumi.get(self, "certificate_secret_version")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        A custom hostname to be used for the vb instance URL, in FQDN format.
        """
        return pulumi.get(self, "hostname")


@pulumi.output_type
class GetVbInstancesVbInstanceSummaryCollectionItemCustomEndpointResult(dict):
    def __init__(__self__, *,
                 certificate_secret_id: _builtins.str,
                 certificate_secret_version: _builtins.int,
                 hostname: _builtins.str):
        """
        :param _builtins.str certificate_secret_id: Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        :param _builtins.int certificate_secret_version: The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        :param _builtins.str hostname: A custom hostname to be used for the vb instance URL, in FQDN format.
        """
        pulumi.set(__self__, "certificate_secret_id", certificate_secret_id)
        pulumi.set(__self__, "certificate_secret_version", certificate_secret_version)
        pulumi.set(__self__, "hostname", hostname)

    @_builtins.property
    @pulumi.getter(name="certificateSecretId")
    def certificate_secret_id(self) -> _builtins.str:
        """
        Optional OCID of a vault/secret containing a private SSL certificate bundle to be used for the custom hostname.
        """
        return pulumi.get(self, "certificate_secret_id")

    @_builtins.property
    @pulumi.getter(name="certificateSecretVersion")
    def certificate_secret_version(self) -> _builtins.int:
        """
        The secret version used for the certificate-secret-id (if certificate-secret-id is specified).
        """
        return pulumi.get(self, "certificate_secret_version")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> _builtins.str:
        """
        A custom hostname to be used for the vb instance URL, in FQDN format.
        """
        return pulumi.get(self, "hostname")


@pulumi.output_type
class GetVbInstancesVbInstanceSummaryCollectionItemNetworkEndpointDetailResult(dict):
    def __init__(__self__, *,
                 allowlisted_http_ips: Sequence[_builtins.str],
                 allowlisted_http_vcns: Sequence['outputs.GetVbInstancesVbInstanceSummaryCollectionItemNetworkEndpointDetailAllowlistedHttpVcnResult'],
                 network_endpoint_type: _builtins.str,
                 network_security_group_ids: Sequence[_builtins.str],
                 private_endpoint_ip: _builtins.str,
                 subnet_id: _builtins.str):
        """
        :param Sequence[_builtins.str] allowlisted_http_ips: Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5/32", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        :param Sequence['GetVbInstancesVbInstanceSummaryCollectionItemNetworkEndpointDetailAllowlistedHttpVcnArgs'] allowlisted_http_vcns: Virtual Cloud Networks allowed to access this network endpoint.
        :param _builtins.str network_endpoint_type: The type of network endpoint.
        :param Sequence[_builtins.str] network_security_group_ids: Network Security Group OCIDs for the Private Endpoint.
        :param _builtins.str private_endpoint_ip: The IP address to be assigned to Private Endpoint
        :param _builtins.str subnet_id: The subnet OCID for the private endpoint.
        """
        pulumi.set(__self__, "allowlisted_http_ips", allowlisted_http_ips)
        pulumi.set(__self__, "allowlisted_http_vcns", allowlisted_http_vcns)
        pulumi.set(__self__, "network_endpoint_type", network_endpoint_type)
        pulumi.set(__self__, "network_security_group_ids", network_security_group_ids)
        pulumi.set(__self__, "private_endpoint_ip", private_endpoint_ip)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="allowlistedHttpIps")
    def allowlisted_http_ips(self) -> Sequence[_builtins.str]:
        """
        Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5/32", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        """
        return pulumi.get(self, "allowlisted_http_ips")

    @_builtins.property
    @pulumi.getter(name="allowlistedHttpVcns")
    def allowlisted_http_vcns(self) -> Sequence['outputs.GetVbInstancesVbInstanceSummaryCollectionItemNetworkEndpointDetailAllowlistedHttpVcnResult']:
        """
        Virtual Cloud Networks allowed to access this network endpoint.
        """
        return pulumi.get(self, "allowlisted_http_vcns")

    @_builtins.property
    @pulumi.getter(name="networkEndpointType")
    def network_endpoint_type(self) -> _builtins.str:
        """
        The type of network endpoint.
        """
        return pulumi.get(self, "network_endpoint_type")

    @_builtins.property
    @pulumi.getter(name="networkSecurityGroupIds")
    def network_security_group_ids(self) -> Sequence[_builtins.str]:
        """
        Network Security Group OCIDs for the Private Endpoint.
        """
        return pulumi.get(self, "network_security_group_ids")

    @_builtins.property
    @pulumi.getter(name="privateEndpointIp")
    def private_endpoint_ip(self) -> _builtins.str:
        """
        The IP address to be assigned to Private Endpoint
        """
        return pulumi.get(self, "private_endpoint_ip")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        The subnet OCID for the private endpoint.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetVbInstancesVbInstanceSummaryCollectionItemNetworkEndpointDetailAllowlistedHttpVcnResult(dict):
    def __init__(__self__, *,
                 allowlisted_ip_cidrs: Sequence[_builtins.str],
                 id: _builtins.str):
        """
        :param Sequence[_builtins.str] allowlisted_ip_cidrs: Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5/32", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        :param _builtins.str id: The Virtual Cloud Network OCID.
        """
        pulumi.set(__self__, "allowlisted_ip_cidrs", allowlisted_ip_cidrs)
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="allowlistedIpCidrs")
    def allowlisted_ip_cidrs(self) -> Sequence[_builtins.str]:
        """
        Source IP addresses or IP address ranges ingress rules. (ex: "168.122.59.5/32", "10.20.30.0/26") An invalid IP or CIDR block will result in a 400 response.
        """
        return pulumi.get(self, "allowlisted_ip_cidrs")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The Virtual Cloud Network OCID.
        """
        return pulumi.get(self, "id")


