"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lib_1 = require("../lib");
const lambda = require("aws-cdk-lib/aws-lambda");
const iam = require("aws-cdk-lib/aws-iam");
const defaults = require("@aws-solutions-constructs/core");
const core_1 = require("@aws-solutions-constructs/core");
// Setup
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, core_1.generateIntegStackName(__filename));
stack.templateOptions.description = 'Integration Test for aws-lambda-kendra';
stack.node.setContext("@aws-cdk/aws-s3:serverAccessLogsUseBucketPolicy", true);
const testBucket = defaults.CreateScrapBucket(stack, "scrapBucket");
const existingIamRole = new iam.Role(stack, 'existingRole', {
    assumedBy: new iam.ServicePrincipal('kendra.amazonaws.com')
});
const sourceProps = {
    urls: {
        seedUrlConfiguration: {
            seedUrls: ["https://aws.amazon.com"]
        }
    },
    crawlDepth: 1,
};
const webCrawlerSource = {
    name: "web-source",
    roleArn: existingIamRole.roleArn,
    type: "WEBCRAWLER",
    dataSourceConfiguration: {
        webCrawlerConfiguration: sourceProps
    }
};
new lib_1.LambdaToKendra(stack, 'minimal-arguments', {
    lambdaFunctionProps: {
        code: lambda.Code.fromAsset(`lambda`),
        runtime: lambda.Runtime.NODEJS_18_X,
        handler: 'index.handler',
    },
    kendraDataSourcesProps: [{
            type: 'S3',
            dataSourceConfiguration: {
                s3Configuration: {
                    bucketName: testBucket.bucketName,
                }
            }
        },
        webCrawlerSource],
});
core_1.suppressAutoDeleteHandlerWarnings(stack);
//# sourceMappingURL=data:application/json;base64,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