# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/database/glueConnection.json
#   timestamp: 2022-04-05T04:21:49+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, List, Optional

from pydantic import BaseModel, Extra, Field

from . import connectionBasicType


class SupportedPipelineType10(Enum):
    Metadata = 'Metadata'


class GlueType(Enum):
    Glue = 'Glue'


class GlueConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[GlueType] = Field('Glue', description='Service Type')
    hostPort: Optional[str] = Field(None, description='Host and port of the DynamoDB')
    endPointURL: Optional[str] = Field(
        None, description='EndPoint URL for the Dynamo DB'
    )
    awsAccessKeyId: Optional[Any] = Field(None, description='AWS Access key ID.')
    awsSecretAccessKey: Optional[str] = Field(
        None, description='AWS Secret Access Key.'
    )
    awsSessionToken: Optional[str] = Field(None, description='AWS Session Token.')
    awsRegion: Optional[str] = Field(None, description='AWS Region Name.')
    database: Optional[str] = Field(
        'DynamoDB',
        description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank , OpenMetadata Ingestion attempts to scan all the databases in Glue.',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = None
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = None
    supportedPipelineTypes: Optional[List[SupportedPipelineType10]] = Field(
        ['Metadata'], description='Supported Metadata Extraction Pipelines.'
    )
