# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/database/salesforceConnection.json
#   timestamp: 2022-04-05T04:21:49+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, Extra, Field, SecretStr

from . import connectionBasicType


class SupportedPipelineType3(Enum):
    Metadata = 'Metadata'


class SalesforceType(Enum):
    Salesforce = 'Salesforce'


class SalesforceScheme(Enum):
    salesforce = 'salesforce'


class SalesforceConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[SalesforceType] = Field('Salesforce', description='Service Type')
    scheme: Optional[SalesforceScheme] = Field(
        'salesforce', description='SQLAlchemy driver scheme options.'
    )
    username: Optional[str] = Field(
        None,
        description='username to connect  to the Redshift. This user should have privileges to read all the metadata in Redshift.',
    )
    password: Optional[SecretStr] = Field(
        None, description='password to connect  to the Redshift.'
    )
    securityToken: Optional[str] = Field(None, description='Salesforce Security Token.')
    hostPort: Optional[str] = Field(None, description='Host and port of the Redshift.')
    sobjectName: Optional[str] = Field(None, description='Salesforce Object Name.')
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = None
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = None
    supportedPipelineTypes: Optional[List[SupportedPipelineType3]] = Field(
        ['Metadata'], description='Supported Metadata Extraction Pipelines.'
    )
