# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/database/trinoConnection.json
#   timestamp: 2022-04-05T04:21:49+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, Extra, Field, SecretStr

from . import connectionBasicType


class SupportedPipelineType19(Enum):
    Metadata = 'Metadata'


class TrinoType(Enum):
    Trino = 'Trino'


class TrinoScheme(Enum):
    trino = 'trino'


class TrinoConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[TrinoType] = Field('Trino', description='Service Type')
    scheme: Optional[TrinoScheme] = Field(
        'trino', description='SQLAlchemy driver scheme options.'
    )
    username: Optional[str] = Field(
        None,
        description='username to connect  to the Snowflake. This user should have privileges to read all the metadata in Snowflake.',
    )
    password: Optional[SecretStr] = Field(
        None, description='password to connect  to the Trino.'
    )
    hostPort: Optional[str] = Field(
        None, description='Host and port of the data source.'
    )
    database: Optional[str] = Field(
        None,
        description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank , OpenMetadata Ingestion attempts to scan all the databases in Trino.',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = None
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = None
    supportedPipelineTypes: Optional[List[SupportedPipelineType19]] = Field(
        ['Metadata'], description='Supported Metadata Extraction Pipelines.'
    )
