# generated by datamodel-codegen:
#   filename:  schema/operations/pipelines/airflowPipeline.json
#   timestamp: 2022-04-05T06:49:57+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import BaseModel, Extra, Field, constr

from ...type import basic, entityHistory, entityReference
from . import databaseServiceMetadataPipeline, databaseServiceQueryUsagePipeline


class PipelineType(Enum):
    metadata = 'metadata'
    queryUsage = 'queryUsage'


class PipelineStatus(BaseModel):
    class Config:
        extra = Extra.forbid

    state: Optional[str] = Field(
        None, description='Pipeline status denotes if its failed or succeeded.'
    )
    startDate: Optional[str] = Field(
        None, description='startDate of the Pipeline run for this particular execution.'
    )
    endDate: Optional[str] = Field(
        None, description='endDate of the pipeline run for this particular execution.'
    )


class Schema(Enum):
    databaseServiceMetadataPipeline = 'databaseServiceMetadataPipeline'
    databaseServiceQueryUsagePipeline = 'databaseServiceQueryUsagePipeline'


class PipelineConfig(BaseModel):
    class Config:
        extra = Extra.forbid

    config: Optional[
        Union[
            databaseServiceMetadataPipeline.DatabaseServiceMetadataPipeline,
            databaseServiceQueryUsagePipeline.DatabaseServiceQueryUsagePipeline,
        ]
    ] = None
    schema_: Optional[Schema] = Field(None, alias='schema')


class AirflowPipeline(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[basic.Uuid] = Field(
        None, description='Unique identifier that identifies this pipeline.'
    )
    name: constr(min_length=1, max_length=128) = Field(
        ..., description='Name that identifies this pipeline instance uniquely.'
    )
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this Pipeline.'
    )
    description: Optional[str] = Field(None, description='Description of the Pipeline.')
    pipelineType: PipelineType
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this Pipeline.'
    )
    fullyQualifiedName: Optional[constr(min_length=1, max_length=256)] = Field(
        None, description='Name that uniquely identifies a Pipeline.'
    )
    pipelineConfig: PipelineConfig
    forceDeploy: Optional[bool] = Field(
        'false',
        description='Deploy the pipeline by overwriting existing pipeline with the same name.',
    )
    pausePipeline: Optional[bool] = Field(
        'false',
        description='pause the pipeline from running once the deploy is finished successfully.',
    )
    concurrency: Optional[int] = Field(1, description='Concurrency of the Pipeline.')
    startDate: basic.Date = Field(..., description='Start date of the pipeline.')
    endDate: Optional[basic.Date] = Field(None, description='End Date of the pipeline.')
    nextExecutionDate: Optional[basic.Date] = Field(
        None,
        description='Next execution date from the underlying pipeline platform once the pipeline scheduled.',
    )
    pipelineTimezone: Optional[str] = Field(
        'UTC', description='Timezone in which pipeline going to be scheduled.'
    )
    retries: Optional[int] = Field(1, description='Retry pipeline in case of failure.')
    retryDelay: Optional[int] = Field(
        300, description='Delay between retries in seconds.'
    )
    pipelineCatchup: Optional[bool] = Field(
        'false', description='Run past executions if the start date is in the past.'
    )
    scheduleInterval: Optional[str] = Field(
        None, description='Scheduler Interval for the pipeline in cron format.'
    )
    pipelineTimeout: Optional[int] = Field(
        60, description='Timeout for the pipeline in seconds.'
    )
    pipelineStatuses: Optional[List[PipelineStatus]] = Field(
        None, description='List of executions and status for the Pipeline.'
    )
    service: entityReference.EntityReference = Field(
        ...,
        description='Link to the database service where this database is hosted in.',
    )
    href: Optional[basic.Href] = Field(
        None, description='Link to this pipeline resource.'
    )
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the entity.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that led to this version of the entity.'
    )
    deleted: Optional[bool] = Field(
        False, description='When `true` indicates the entity has been soft deleted.'
    )
