# generated by datamodel-codegen:
#   filename:  schema/tests/basic.json
#   timestamp: 2022-04-05T06:49:57+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Optional

from pydantic import BaseModel, Extra, Field

from ..type import basic


class Basic(BaseModel):
    __root__: Any = Field(
        ...,
        description='This schema defines basic types that are used by other test schemas.',
        title='Basic',
    )


class TestCaseStatus(Enum):
    Success = 'Success'
    Failed = 'Failed'
    Aborted = 'Aborted'


class TestCaseExecutionFrequency(Enum):
    Hourly = 'Hourly'
    Daily = 'Daily'
    Weekly = 'Weekly'


class TestCaseResult(BaseModel):
    class Config:
        extra = Extra.forbid

    executionTime: Optional[basic.Timestamp] = Field(
        None, description='Data one which profile is taken.'
    )
    testCaseStatus: Optional[TestCaseStatus] = Field(
        None, description='Status of Test Case run.'
    )
    result: Optional[str] = Field(None, description='Details of test case results.')
    sampleData: Optional[str] = Field(
        None,
        description="sample data to capture rows/columns that didn't match the expressed testcase.",
    )
