"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EncryptedLogGroup = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_kms_1 = require("aws-cdk-lib/aws-kms");
const aws_logs_1 = require("aws-cdk-lib/aws-logs");
const constructs_1 = require("constructs");
/**
 * A log group encrypted by a KMS customer managed key.
 */
class EncryptedLogGroup extends constructs_1.Construct {
    /**
     * Creates a new EncryptedLogGroup.
     */
    constructor(scope, id, props) {
        super(scope, id);
        const { region, account } = aws_cdk_lib_1.Stack.of(this);
        const { logGroupName, removalPolicy, retention } = props;
        const key = props.encryptionKey ??
            new aws_kms_1.Key(this, "Key", {
                description: `Created by ${this.node.path}`,
                removalPolicy,
            });
        const group = new aws_logs_1.LogGroup(this, "LogGroup", {
            encryptionKey: key,
            removalPolicy,
            retention,
            logGroupName,
        });
        const principal = new aws_iam_1.ServicePrincipal(`logs.${region}.amazonaws.com`).withConditions({
            ArnEquals: {
                "kms:EncryptionContext:aws:logs:arn": `arn:aws:logs:${region}:${account}:log-group:${logGroupName}`,
            },
        });
        key.grantEncryptDecrypt(principal);
        this.key = key;
        this.logGroup = group;
    }
}
exports.EncryptedLogGroup = EncryptedLogGroup;
_a = JSII_RTTI_SYMBOL_1;
EncryptedLogGroup[_a] = { fqn: "shady-island.EncryptedLogGroup", version: "0.1.3" };
//# sourceMappingURL=data:application/json;base64,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