import { IVpc } from "aws-cdk-lib/aws-ec2";
import { Function } from "aws-cdk-lib/aws-lambda";
import { DatabaseCluster, DatabaseClusterFromSnapshot, DatabaseInstance, DatabaseInstanceFromSnapshot, ServerlessCluster, ServerlessClusterFromSnapshot } from "aws-cdk-lib/aws-rds";
import { ISecret } from "aws-cdk-lib/aws-secretsmanager";
import { ITrigger } from "aws-cdk-lib/triggers";
import { IConstruct, Construct } from "constructs";
import { BaseDatabase, BaseDatabaseProps, BaseDatabaseOptions } from "./base-database";
/**
 * PostgreSQL-specific options.
 */
export interface PostgresqlDatabaseOptions {
    /**
     * The Secrets Manager secret for the owner of the schema.
     */
    readonly ownerSecret: ISecret;
    /**
     * The name of the schema to create.
     *
     * @default - The username of the ownerSecret.
     */
    readonly schemaName?: string;
    /**
     * The database default encoding set to use.
     *
     * @default - "UTF8"
     */
    readonly encoding?: string;
    /**
     * The database default locale to use.
     *
     * @default - rely on PostgreSQL to choose the default locale.
     */
    readonly locale?: string;
}
/**
 * Constructor properties for PostgresqlDatabase.
 */
export interface PostgresqlDatabaseProps extends BaseDatabaseProps, PostgresqlDatabaseOptions {
}
/**
 * Properties to specify when using PostgresqlDatabase.forCluster().
 */
export interface PostgresqlDatabaseForClusterOptions extends PostgresqlDatabaseOptions, BaseDatabaseOptions {
    /**
     * A Secrets Manager secret that contains administrative credentials.
     */
    readonly adminSecret?: ISecret;
}
/**
 * Properties to specify when using PostgresqlDatabase.forServerlessCluster().
 */
export interface PostgresqlDatabaseForServerlessClusterOptions extends PostgresqlDatabaseForClusterOptions {
    /**
     * The VPC where the Lambda function will run.
     */
    readonly vpc: IVpc;
}
/**
 * A PostgreSQL database.
 */
export declare class PostgresqlDatabase extends BaseDatabase {
    /**
     * Create a new PostgresqlDatabase inside a DatabaseCluster.
     *
     * This method automatically adds the cluster to the CloudFormation
     * dependencies of the CDK Trigger.
     *
     * @param scope - The Construct that contains this one.
     * @param id - The identifier of this construct.
     * @param cluster - The database cluster construct.
     * @param options - The configuration properties for this construct.
     */
    static forCluster(scope: Construct, id: string, cluster: DatabaseCluster, options: PostgresqlDatabaseForClusterOptions): PostgresqlDatabase;
    /**
     * Create a new PostgresqlDatabase inside a DatabaseClusterFromSnapshot.
     *
     * This method automatically adds the cluster to the CloudFormation
     * dependencies of the CDK Trigger.
     *
     * @param scope - The Construct that contains this one.
     * @param id - The identifier of this construct.
     * @param cluster - The database cluster construct.
     * @param options - The configuration properties for this construct.
     */
    static forClusterFromSnapshot(scope: Construct, id: string, cluster: DatabaseClusterFromSnapshot, options: PostgresqlDatabaseForClusterOptions): PostgresqlDatabase;
    /**
     * Create a new PostgresqlDatabase inside a DatabaseCluster.
     *
     * This method automatically adds the cluster to the CloudFormation
     * dependencies of the CDK Trigger.
     *
     * @param scope - The Construct that contains this one.
     * @param id - The identifier of this construct.
     * @param cluster - The database cluster construct.
     * @param options - The configuration properties for this construct.
     */
    static forServerlessCluster(scope: Construct, id: string, cluster: ServerlessCluster, options: PostgresqlDatabaseForServerlessClusterOptions): PostgresqlDatabase;
    /**
     * Create a new PostgresqlDatabase inside a DatabaseClusterFromSnapshot.
     *
     * This method automatically adds the cluster to the CloudFormation
     * dependencies of the CDK Trigger.
     *
     * @param scope - The Construct that contains this one.
     * @param id - The identifier of this construct.
     * @param cluster - The database cluster construct.
     * @param options - The configuration properties for this construct.
     */
    static forServerlessClusterFromSnapshot(scope: Construct, id: string, cluster: ServerlessClusterFromSnapshot, options: PostgresqlDatabaseForServerlessClusterOptions): PostgresqlDatabase;
    /**
     * Create a new PostgresqlDatabase inside a DatabaseInstance.
     *
     * This method automatically adds the instance to the CloudFormation
     * dependencies of the CDK Trigger.
     *
     * @param scope - The Construct that contains this one.
     * @param id - The identifier of this construct.
     * @param instance - The database cluster construct.
     * @param options - The configuration properties for this construct.
     */
    static forInstance(scope: Construct, id: string, instance: DatabaseInstance, options: PostgresqlDatabaseForClusterOptions): PostgresqlDatabase;
    /**
     * Create a new PostgresqlDatabase inside a DatabaseInstanceFromSnapshot.
     *
     * This method automatically adds the instance to the CloudFormation
     * dependencies of the CDK Trigger.
     *
     * @param scope - The Construct that contains this one.
     * @param id - The identifier of this construct.
     * @param instance - The database cluster construct.
     * @param options - The configuration properties for this construct.
     */
    static forInstanceFromSnapshot(scope: Construct, id: string, instance: DatabaseInstanceFromSnapshot, options: PostgresqlDatabaseForClusterOptions): PostgresqlDatabase;
    readonly trigger: ITrigger;
    protected readonly lambdaFunction: Function;
    protected readonly ownerSecrets: ISecret[];
    protected readonly readerSecrets: ISecret[];
    protected readonly unprivilegedSecrets: ISecret[];
    /**
     * Creates a new PostgresqlDatabase.
     *
     * @param scope - The Construct that contains this one.
     * @param id - The identifier of this construct.
     * @param props - The configuration properties for this construct.
     */
    constructor(scope: IConstruct, id: string, props: PostgresqlDatabaseProps);
    addUserAsOwner(secret: ISecret): void;
    addUserAsReader(secret: ISecret): void;
    addUserAsUnprivileged(secret: ISecret): void;
}
