"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fetchAllSecrets = exports.fetchSecret = exports.parseJsonArrayFromEnv = void 0;
// eslint-disable-next-line import/no-extraneous-dependencies
const client_secrets_manager_1 = require("@aws-sdk/client-secrets-manager");
function parseJsonArrayFromEnv(variableName) {
    if (!Object.keys(process.env).includes(variableName)) {
        return [];
    }
    const hydrated = JSON.parse(process.env[variableName]);
    if (!Array.isArray(hydrated)) {
        throw new Error(`The ${variableName} environment variable must be a JSON array`);
    }
    return hydrated;
}
exports.parseJsonArrayFromEnv = parseJsonArrayFromEnv;
async function fetchSecret(arn, client) {
    console.log(`Requesting decoded secret from Secrets Manager: ${arn}`);
    const output = await client.send(new client_secrets_manager_1.GetSecretValueCommand({ SecretId: arn }));
    return output.SecretString ? JSON.parse(output.SecretString) : {};
}
exports.fetchSecret = fetchSecret;
async function fetchAllSecrets(arns, client) {
    if (arns.length === 0) {
        return [];
    }
    return Promise.all(arns.map((a) => fetchSecret(a, client)));
}
exports.fetchAllSecrets = fetchAllSecrets;
//# sourceMappingURL=data:application/json;base64,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