# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dataforseo_client.models.advertiser import Advertiser
from dataforseo_client.models.base_google_ads_advertisers_serp_element_item import BaseGoogleAdsAdvertisersSerpElementItem
from typing import Optional, Set
from typing_extensions import Self

class AdsMultiAccountAdvertiserSerpElementItem(BaseGoogleAdsAdvertisersSerpElementItem):
    """
    AdsMultiAccountAdvertiserSerpElementItem
    """ # noqa: E501
    title: Optional[StrictStr] = Field(default=None, description="title of the element")
    location: Optional[StrictStr] = Field(default=None, description="advertiser location")
    approx_ads_count: Optional[StrictInt] = Field(default=None, description="ads count the approximate number of ads that are run by the advertiser across all available Google Ads platforms")
    advertisers: Optional[List[Advertiser]] = Field(default=None, description="associated advertiser accounts contains objects with data on associated advertiser accounts")
    __properties: ClassVar[List[str]] = ["type", "rank_group", "rank_absolute", "title", "location", "approx_ads_count", "advertisers"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AdsMultiAccountAdvertiserSerpElementItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in advertisers (list)
        _items = []
        if self.advertisers:
            for _item_advertisers in self.advertisers:
                if _item_advertisers:
                    _items.append(_item_advertisers.to_dict())
            _dict['advertisers'] = _items
        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        # set to None if rank_group (nullable) is None
        # and model_fields_set contains the field
        if self.rank_group is None and "rank_group" in self.model_fields_set:
            _dict['rank_group'] = None

        # set to None if rank_absolute (nullable) is None
        # and model_fields_set contains the field
        if self.rank_absolute is None and "rank_absolute" in self.model_fields_set:
            _dict['rank_absolute'] = None

        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        # set to None if location (nullable) is None
        # and model_fields_set contains the field
        if self.location is None and "location" in self.model_fields_set:
            _dict['location'] = None

        # set to None if approx_ads_count (nullable) is None
        # and model_fields_set contains the field
        if self.approx_ads_count is None and "approx_ads_count" in self.model_fields_set:
            _dict['approx_ads_count'] = None

        # set to None if advertisers (nullable) is None
        # and model_fields_set contains the field
        if self.advertisers is None and "advertisers" in self.model_fields_set:
            _dict['advertisers'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AdsMultiAccountAdvertiserSerpElementItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "rank_group": obj.get("rank_group"),
            "rank_absolute": obj.get("rank_absolute"),
            "title": obj.get("title"),
            "location": obj.get("location"),
            "approx_ads_count": obj.get("approx_ads_count"),
            "advertisers": [Advertiser.from_dict(_item) for _item in obj["advertisers"]] if obj.get("advertisers") is not None else None
        })
        return _obj


