# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class AmazonApplicableVouchersItem(BaseModel):
    """
    AmazonApplicableVouchersItem
    """ # noqa: E501
    type: Optional[StrictStr] = Field(default=None, description="type of element")
    text: Optional[StrictStr] = Field(default=None, description="text of the voucher")
    fixed_discount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="value of the fixed discount")
    fixed_discount_currency: Optional[StrictStr] = Field(default=None, description="currency code of the fixed discount")
    percentage_discount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="value of the percentage discount if the discount is fixed, the value will be null")
    important_details: Optional[StrictStr] = Field(default=None, description="important details about the terms of discount vouchers")
    __properties: ClassVar[List[str]] = ["type", "text", "fixed_discount", "fixed_discount_currency", "percentage_discount", "important_details"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AmazonApplicableVouchersItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        # set to None if text (nullable) is None
        # and model_fields_set contains the field
        if self.text is None and "text" in self.model_fields_set:
            _dict['text'] = None

        # set to None if fixed_discount (nullable) is None
        # and model_fields_set contains the field
        if self.fixed_discount is None and "fixed_discount" in self.model_fields_set:
            _dict['fixed_discount'] = None

        # set to None if fixed_discount_currency (nullable) is None
        # and model_fields_set contains the field
        if self.fixed_discount_currency is None and "fixed_discount_currency" in self.model_fields_set:
            _dict['fixed_discount_currency'] = None

        # set to None if percentage_discount (nullable) is None
        # and model_fields_set contains the field
        if self.percentage_discount is None and "percentage_discount" in self.model_fields_set:
            _dict['percentage_discount'] = None

        # set to None if important_details (nullable) is None
        # and model_fields_set contains the field
        if self.important_details is None and "important_details" in self.model_fields_set:
            _dict['important_details'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AmazonApplicableVouchersItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "text": obj.get("text"),
            "fixed_discount": obj.get("fixed_discount"),
            "fixed_discount_currency": obj.get("fixed_discount_currency"),
            "percentage_discount": obj.get("percentage_discount"),
            "important_details": obj.get("important_details")
        })
        return _obj


