# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dataforseo_client.models.content_analysis_rating_info import ContentAnalysisRatingInfo
from dataforseo_client.models.social_metrics_info import SocialMetricsInfo
from typing import Optional, Set
from typing_extensions import Self

class AnalysisContentInfo(BaseModel):
    """
    AnalysisContentInfo
    """ # noqa: E501
    content_type: Optional[StrictStr] = Field(default=None, description="type of content example: page_content, comment")
    title: Optional[StrictStr] = Field(default=None, description="title of the result")
    main_title: Optional[StrictStr] = Field(default=None, description="page title")
    previous_title: Optional[StrictStr] = Field(default=None, description="title of the previous content block")
    level: Optional[StrictInt] = Field(default=None, description="title heading level indicates h-tag level from 1 (top) to 6 (bottom)")
    author: Optional[StrictStr] = Field(default=None, description="author of the content")
    snippet: Optional[StrictStr] = Field(default=None, description="content snippet")
    snippet_length: Optional[StrictInt] = Field(default=None, description="character length of the snippet")
    social_metrics: Optional[List[SocialMetricsInfo]] = Field(default=None, description="social media engagement metrics data on social media interactions associated with the content based on website embeds developed and supported by social media platforms")
    highlighted_text: Optional[StrictStr] = Field(default=None, description="highlighted text from the snippet")
    language: Optional[StrictStr] = Field(default=None, description="content language to obtain a full list of available languages, refer to the Languages endpoint")
    sentiment_connotations: Optional[Dict[str, Optional[StrictInt]]] = Field(default=None, description="sentiment connotations contains sentiments (emotional reactions) related to the given citation and probability index per each sentiment possible sentiment connotations: anger, happiness, love, sadness, share, fun")
    connotation_types: Optional[Dict[str, Optional[StrictInt]]] = Field(default=None, description="connotation types contains types of sentiments (sentiment polarity) related to the given citation and probability index per each sentiment type possible sentiment connotation types: positive, negative, neutral")
    text_category: Optional[List[StrictInt]] = Field(default=None, description="text category to obtain a full list of available categories, refer to the Categories endpoint")
    date_published: Optional[StrictStr] = Field(default=None, description="date and time when the content was published in the UTC format: “yyyy-mm-dd hh-mm-ss +00:00” example: 2017-01-24 13:20:59 +00:00")
    content_quality_score: Optional[StrictInt] = Field(default=None, description="content quality score this value is calculated based on the number of words, sentences and characters the content contains")
    semantic_location: Optional[StrictStr] = Field(default=None, description="semantic location indicates semantic element in HTML where the target keyword citation is located example: article, header")
    rating: Optional[ContentAnalysisRatingInfo] = None
    group_date: Optional[StrictStr] = Field(default=None, description="citation group date and time indicates content publication date or date and time when our crawler visited the page for the first time; this field can be used to group citations by date and display citation trends; date and time are provided in the UTC format: “yyyy-mm-dd hh-mm-ss +00:00” example: 2017-01-24 13:20:59 +00:00")
    __properties: ClassVar[List[str]] = ["content_type", "title", "main_title", "previous_title", "level", "author", "snippet", "snippet_length", "social_metrics", "highlighted_text", "language", "sentiment_connotations", "connotation_types", "text_category", "date_published", "content_quality_score", "semantic_location", "rating", "group_date"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AnalysisContentInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in social_metrics (list)
        _items = []
        if self.social_metrics:
            for _item_social_metrics in self.social_metrics:
                if _item_social_metrics:
                    _items.append(_item_social_metrics.to_dict())
            _dict['social_metrics'] = _items
        # override the default output from pydantic by calling `to_dict()` of rating
        if self.rating:
            _dict['rating'] = self.rating.to_dict()
        # set to None if content_type (nullable) is None
        # and model_fields_set contains the field
        if self.content_type is None and "content_type" in self.model_fields_set:
            _dict['content_type'] = None

        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        # set to None if main_title (nullable) is None
        # and model_fields_set contains the field
        if self.main_title is None and "main_title" in self.model_fields_set:
            _dict['main_title'] = None

        # set to None if previous_title (nullable) is None
        # and model_fields_set contains the field
        if self.previous_title is None and "previous_title" in self.model_fields_set:
            _dict['previous_title'] = None

        # set to None if level (nullable) is None
        # and model_fields_set contains the field
        if self.level is None and "level" in self.model_fields_set:
            _dict['level'] = None

        # set to None if author (nullable) is None
        # and model_fields_set contains the field
        if self.author is None and "author" in self.model_fields_set:
            _dict['author'] = None

        # set to None if snippet (nullable) is None
        # and model_fields_set contains the field
        if self.snippet is None and "snippet" in self.model_fields_set:
            _dict['snippet'] = None

        # set to None if snippet_length (nullable) is None
        # and model_fields_set contains the field
        if self.snippet_length is None and "snippet_length" in self.model_fields_set:
            _dict['snippet_length'] = None

        # set to None if social_metrics (nullable) is None
        # and model_fields_set contains the field
        if self.social_metrics is None and "social_metrics" in self.model_fields_set:
            _dict['social_metrics'] = None

        # set to None if highlighted_text (nullable) is None
        # and model_fields_set contains the field
        if self.highlighted_text is None and "highlighted_text" in self.model_fields_set:
            _dict['highlighted_text'] = None

        # set to None if language (nullable) is None
        # and model_fields_set contains the field
        if self.language is None and "language" in self.model_fields_set:
            _dict['language'] = None

        # set to None if sentiment_connotations (nullable) is None
        # and model_fields_set contains the field
        if self.sentiment_connotations is None and "sentiment_connotations" in self.model_fields_set:
            _dict['sentiment_connotations'] = None

        # set to None if connotation_types (nullable) is None
        # and model_fields_set contains the field
        if self.connotation_types is None and "connotation_types" in self.model_fields_set:
            _dict['connotation_types'] = None

        # set to None if text_category (nullable) is None
        # and model_fields_set contains the field
        if self.text_category is None and "text_category" in self.model_fields_set:
            _dict['text_category'] = None

        # set to None if date_published (nullable) is None
        # and model_fields_set contains the field
        if self.date_published is None and "date_published" in self.model_fields_set:
            _dict['date_published'] = None

        # set to None if content_quality_score (nullable) is None
        # and model_fields_set contains the field
        if self.content_quality_score is None and "content_quality_score" in self.model_fields_set:
            _dict['content_quality_score'] = None

        # set to None if semantic_location (nullable) is None
        # and model_fields_set contains the field
        if self.semantic_location is None and "semantic_location" in self.model_fields_set:
            _dict['semantic_location'] = None

        # set to None if group_date (nullable) is None
        # and model_fields_set contains the field
        if self.group_date is None and "group_date" in self.model_fields_set:
            _dict['group_date'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AnalysisContentInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "content_type": obj.get("content_type"),
            "title": obj.get("title"),
            "main_title": obj.get("main_title"),
            "previous_title": obj.get("previous_title"),
            "level": obj.get("level"),
            "author": obj.get("author"),
            "snippet": obj.get("snippet"),
            "snippet_length": obj.get("snippet_length"),
            "social_metrics": [SocialMetricsInfo.from_dict(_item) for _item in obj["social_metrics"]] if obj.get("social_metrics") is not None else None,
            "highlighted_text": obj.get("highlighted_text"),
            "language": obj.get("language"),
            "sentiment_connotations": obj.get("sentiment_connotations"),
            "connotation_types": obj.get("connotation_types"),
            "text_category": obj.get("text_category"),
            "date_published": obj.get("date_published"),
            "content_quality_score": obj.get("content_quality_score"),
            "semantic_location": obj.get("semantic_location"),
            "rating": ContentAnalysisRatingInfo.from_dict(obj["rating"]) if obj.get("rating") is not None else None,
            "group_date": obj.get("group_date")
        })
        return _obj


