# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from dataforseo_client.models.appendix_business_data_day_limits_rates_data_info import AppendixBusinessDataDayLimitsRatesDataInfo
from dataforseo_client.models.appendix_business_data_google_info import AppendixBusinessDataGoogleInfo
from dataforseo_client.models.appendix_business_listings_business_data_limits_rates_data_info import AppendixBusinessListingsBusinessDataLimitsRatesDataInfo
from dataforseo_client.models.appendix_social_media_business_data_limits_rates_data_info import AppendixSocialMediaBusinessDataLimitsRatesDataInfo
from typing import Optional, Set
from typing_extensions import Self

class AppendixBusinessDataLimitsRatesDataInfo(BaseModel):
    """
    AppendixBusinessDataLimitsRatesDataInfo
    """ # noqa: E501
    google: Optional[AppendixBusinessDataGoogleInfo] = None
    locations: Optional[Union[StrictFloat, StrictInt]] = None
    languages: Optional[Union[StrictFloat, StrictInt]] = None
    errors: Optional[Union[StrictFloat, StrictInt]] = None
    yelp: Optional[AppendixBusinessDataDayLimitsRatesDataInfo] = None
    social_media: Optional[AppendixSocialMediaBusinessDataLimitsRatesDataInfo] = None
    tripadvisor: Optional[AppendixBusinessDataDayLimitsRatesDataInfo] = None
    trustpilot: Optional[AppendixBusinessDataDayLimitsRatesDataInfo] = None
    business_listings: Optional[AppendixBusinessListingsBusinessDataLimitsRatesDataInfo] = None
    tasks_ready: Optional[Union[StrictFloat, StrictInt]] = None
    __properties: ClassVar[List[str]] = ["google", "locations", "languages", "errors", "yelp", "social_media", "tripadvisor", "trustpilot", "business_listings", "tasks_ready"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AppendixBusinessDataLimitsRatesDataInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of google
        if self.google:
            _dict['google'] = self.google.to_dict()
        # override the default output from pydantic by calling `to_dict()` of yelp
        if self.yelp:
            _dict['yelp'] = self.yelp.to_dict()
        # override the default output from pydantic by calling `to_dict()` of social_media
        if self.social_media:
            _dict['social_media'] = self.social_media.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tripadvisor
        if self.tripadvisor:
            _dict['tripadvisor'] = self.tripadvisor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of trustpilot
        if self.trustpilot:
            _dict['trustpilot'] = self.trustpilot.to_dict()
        # override the default output from pydantic by calling `to_dict()` of business_listings
        if self.business_listings:
            _dict['business_listings'] = self.business_listings.to_dict()
        # set to None if locations (nullable) is None
        # and model_fields_set contains the field
        if self.locations is None and "locations" in self.model_fields_set:
            _dict['locations'] = None

        # set to None if languages (nullable) is None
        # and model_fields_set contains the field
        if self.languages is None and "languages" in self.model_fields_set:
            _dict['languages'] = None

        # set to None if errors (nullable) is None
        # and model_fields_set contains the field
        if self.errors is None and "errors" in self.model_fields_set:
            _dict['errors'] = None

        # set to None if tasks_ready (nullable) is None
        # and model_fields_set contains the field
        if self.tasks_ready is None and "tasks_ready" in self.model_fields_set:
            _dict['tasks_ready'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AppendixBusinessDataLimitsRatesDataInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "google": AppendixBusinessDataGoogleInfo.from_dict(obj["google"]) if obj.get("google") is not None else None,
            "locations": obj.get("locations"),
            "languages": obj.get("languages"),
            "errors": obj.get("errors"),
            "yelp": AppendixBusinessDataDayLimitsRatesDataInfo.from_dict(obj["yelp"]) if obj.get("yelp") is not None else None,
            "social_media": AppendixSocialMediaBusinessDataLimitsRatesDataInfo.from_dict(obj["social_media"]) if obj.get("social_media") is not None else None,
            "tripadvisor": AppendixBusinessDataDayLimitsRatesDataInfo.from_dict(obj["tripadvisor"]) if obj.get("tripadvisor") is not None else None,
            "trustpilot": AppendixBusinessDataDayLimitsRatesDataInfo.from_dict(obj["trustpilot"]) if obj.get("trustpilot") is not None else None,
            "business_listings": AppendixBusinessListingsBusinessDataLimitsRatesDataInfo.from_dict(obj["business_listings"]) if obj.get("business_listings") is not None else None,
            "tasks_ready": obj.get("tasks_ready")
        })
        return _obj


