# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from dataforseo_client.models.appendix_info import AppendixInfo
from typing import Optional, Set
from typing_extensions import Self

class AppendixTechnologiesDomainAnalyticsLimitsRatesDataInfo(BaseModel):
    """
    AppendixTechnologiesDomainAnalyticsLimitsRatesDataInfo
    """ # noqa: E501
    domain_technologies: Optional[AppendixInfo] = None
    domains_by_technology: Optional[AppendixInfo] = None
    languages: Optional[Union[StrictFloat, StrictInt]] = None
    locations: Optional[Union[StrictFloat, StrictInt]] = None
    technologies: Optional[Union[StrictFloat, StrictInt]] = None
    aggregation_technologies: Optional[AppendixInfo] = None
    technologies_summary: Optional[AppendixInfo] = None
    domains_by_html_terms: Optional[AppendixInfo] = None
    technology_stats: Optional[AppendixInfo] = None
    __properties: ClassVar[List[str]] = ["domain_technologies", "domains_by_technology", "languages", "locations", "technologies", "aggregation_technologies", "technologies_summary", "domains_by_html_terms", "technology_stats"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AppendixTechnologiesDomainAnalyticsLimitsRatesDataInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of domain_technologies
        if self.domain_technologies:
            _dict['domain_technologies'] = self.domain_technologies.to_dict()
        # override the default output from pydantic by calling `to_dict()` of domains_by_technology
        if self.domains_by_technology:
            _dict['domains_by_technology'] = self.domains_by_technology.to_dict()
        # override the default output from pydantic by calling `to_dict()` of aggregation_technologies
        if self.aggregation_technologies:
            _dict['aggregation_technologies'] = self.aggregation_technologies.to_dict()
        # override the default output from pydantic by calling `to_dict()` of technologies_summary
        if self.technologies_summary:
            _dict['technologies_summary'] = self.technologies_summary.to_dict()
        # override the default output from pydantic by calling `to_dict()` of domains_by_html_terms
        if self.domains_by_html_terms:
            _dict['domains_by_html_terms'] = self.domains_by_html_terms.to_dict()
        # override the default output from pydantic by calling `to_dict()` of technology_stats
        if self.technology_stats:
            _dict['technology_stats'] = self.technology_stats.to_dict()
        # set to None if languages (nullable) is None
        # and model_fields_set contains the field
        if self.languages is None and "languages" in self.model_fields_set:
            _dict['languages'] = None

        # set to None if locations (nullable) is None
        # and model_fields_set contains the field
        if self.locations is None and "locations" in self.model_fields_set:
            _dict['locations'] = None

        # set to None if technologies (nullable) is None
        # and model_fields_set contains the field
        if self.technologies is None and "technologies" in self.model_fields_set:
            _dict['technologies'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AppendixTechnologiesDomainAnalyticsLimitsRatesDataInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "domain_technologies": AppendixInfo.from_dict(obj["domain_technologies"]) if obj.get("domain_technologies") is not None else None,
            "domains_by_technology": AppendixInfo.from_dict(obj["domains_by_technology"]) if obj.get("domains_by_technology") is not None else None,
            "languages": obj.get("languages"),
            "locations": obj.get("locations"),
            "technologies": obj.get("technologies"),
            "aggregation_technologies": AppendixInfo.from_dict(obj["aggregation_technologies"]) if obj.get("aggregation_technologies") is not None else None,
            "technologies_summary": AppendixInfo.from_dict(obj["technologies_summary"]) if obj.get("technologies_summary") is not None else None,
            "domains_by_html_terms": AppendixInfo.from_dict(obj["domains_by_html_terms"]) if obj.get("domains_by_html_terms") is not None else None,
            "technology_stats": AppendixInfo.from_dict(obj["technology_stats"]) if obj.get("technology_stats") is not None else None
        })
        return _obj


