# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class BacklinksPageMeta(BaseModel):
    """
    BacklinksPageMeta
    """ # noqa: E501
    title: Optional[StrictStr] = Field(default=None, description="page title")
    canonical: Optional[StrictStr] = Field(default=None, description="canonical page")
    internal_links_count: Optional[StrictInt] = Field(default=None, description="number of internal links on the page")
    external_links_count: Optional[StrictInt] = Field(default=None, description="number of external links on the page")
    images_count: Optional[StrictInt] = Field(default=None, description="number of images on the page")
    words_count: Optional[StrictInt] = Field(default=None, description="number of words on the page")
    page_spam_score: Optional[StrictInt] = Field(default=None, description="spam score of the page learn more about how the metric is calculated on this help center page")
    social_media_tags: Optional[Dict[str, Optional[StrictStr]]] = Field(default=None, description="array of social media tags found on the page contains social media tags and their content supported tags include but are not limited to Open Graph and Twitter card")
    h1: Optional[List[Optional[StrictStr]]] = Field(default=None, description="h1 tag content of h1 tags")
    h2: Optional[List[Optional[StrictStr]]] = Field(default=None, description="h2 tag content of h2 tags")
    h3: Optional[List[Optional[StrictStr]]] = Field(default=None, description="h3 tag content of h3 tags")
    images_alt: Optional[List[Optional[StrictStr]]] = Field(default=None, description="content of alt tags")
    powered_by: Optional[List[Optional[StrictStr]]] = Field(default=None, description="CMS details")
    language: Optional[StrictStr] = Field(default=None, description="page content language example: en")
    charset: Optional[StrictStr] = Field(default=None, description="character encoding examples: utf-8")
    platform_type: Optional[List[Optional[StrictStr]]] = Field(default=None, description="type of a platform")
    technologies: Optional[Dict[str, Optional[StrictStr]]] = Field(default=None, description="website technologies")
    __properties: ClassVar[List[str]] = ["title", "canonical", "internal_links_count", "external_links_count", "images_count", "words_count", "page_spam_score", "social_media_tags", "h1", "h2", "h3", "images_alt", "powered_by", "language", "charset", "platform_type", "technologies"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BacklinksPageMeta from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        # set to None if canonical (nullable) is None
        # and model_fields_set contains the field
        if self.canonical is None and "canonical" in self.model_fields_set:
            _dict['canonical'] = None

        # set to None if internal_links_count (nullable) is None
        # and model_fields_set contains the field
        if self.internal_links_count is None and "internal_links_count" in self.model_fields_set:
            _dict['internal_links_count'] = None

        # set to None if external_links_count (nullable) is None
        # and model_fields_set contains the field
        if self.external_links_count is None and "external_links_count" in self.model_fields_set:
            _dict['external_links_count'] = None

        # set to None if images_count (nullable) is None
        # and model_fields_set contains the field
        if self.images_count is None and "images_count" in self.model_fields_set:
            _dict['images_count'] = None

        # set to None if words_count (nullable) is None
        # and model_fields_set contains the field
        if self.words_count is None and "words_count" in self.model_fields_set:
            _dict['words_count'] = None

        # set to None if page_spam_score (nullable) is None
        # and model_fields_set contains the field
        if self.page_spam_score is None and "page_spam_score" in self.model_fields_set:
            _dict['page_spam_score'] = None

        # set to None if social_media_tags (nullable) is None
        # and model_fields_set contains the field
        if self.social_media_tags is None and "social_media_tags" in self.model_fields_set:
            _dict['social_media_tags'] = None

        # set to None if h1 (nullable) is None
        # and model_fields_set contains the field
        if self.h1 is None and "h1" in self.model_fields_set:
            _dict['h1'] = None

        # set to None if h2 (nullable) is None
        # and model_fields_set contains the field
        if self.h2 is None and "h2" in self.model_fields_set:
            _dict['h2'] = None

        # set to None if h3 (nullable) is None
        # and model_fields_set contains the field
        if self.h3 is None and "h3" in self.model_fields_set:
            _dict['h3'] = None

        # set to None if images_alt (nullable) is None
        # and model_fields_set contains the field
        if self.images_alt is None and "images_alt" in self.model_fields_set:
            _dict['images_alt'] = None

        # set to None if powered_by (nullable) is None
        # and model_fields_set contains the field
        if self.powered_by is None and "powered_by" in self.model_fields_set:
            _dict['powered_by'] = None

        # set to None if language (nullable) is None
        # and model_fields_set contains the field
        if self.language is None and "language" in self.model_fields_set:
            _dict['language'] = None

        # set to None if charset (nullable) is None
        # and model_fields_set contains the field
        if self.charset is None and "charset" in self.model_fields_set:
            _dict['charset'] = None

        # set to None if platform_type (nullable) is None
        # and model_fields_set contains the field
        if self.platform_type is None and "platform_type" in self.model_fields_set:
            _dict['platform_type'] = None

        # set to None if technologies (nullable) is None
        # and model_fields_set contains the field
        if self.technologies is None and "technologies" in self.model_fields_set:
            _dict['technologies'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BacklinksPageMeta from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "title": obj.get("title"),
            "canonical": obj.get("canonical"),
            "internal_links_count": obj.get("internal_links_count"),
            "external_links_count": obj.get("external_links_count"),
            "images_count": obj.get("images_count"),
            "words_count": obj.get("words_count"),
            "page_spam_score": obj.get("page_spam_score"),
            "social_media_tags": obj.get("social_media_tags"),
            "h1": obj.get("h1"),
            "h2": obj.get("h2"),
            "h3": obj.get("h3"),
            "images_alt": obj.get("images_alt"),
            "powered_by": obj.get("powered_by"),
            "language": obj.get("language"),
            "charset": obj.get("charset"),
            "platform_type": obj.get("platform_type"),
            "technologies": obj.get("technologies")
        })
        return _obj


