# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from importlib import import_module
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from dataforseo_client.models.data_amazon_amazon_paid_serp_element_item import DataAmazonAmazonPaidSerpElementItem
    from dataforseo_client.models.data_amazon_amazon_product_info_serp_element_item import DataAmazonAmazonProductInfoSerpElementItem
    from dataforseo_client.models.data_amazon_amazon_review_item_serp_element_item import DataAmazonAmazonReviewItemSerpElementItem
    from dataforseo_client.models.data_amazon_amazon_seller_item_serp_element_item import DataAmazonAmazonSellerItemSerpElementItem
    from dataforseo_client.models.data_amazon_amazon_seller_main_item_serp_element_item import DataAmazonAmazonSellerMainItemSerpElementItem
    from dataforseo_client.models.data_amazon_amazon_serp_serp_element_item import DataAmazonAmazonSerpSerpElementItem
    from dataforseo_client.models.data_amazon_editorial_recommendations_serp_element_item import DataAmazonEditorialRecommendationsSerpElementItem
    from dataforseo_client.models.data_amazon_related_searches_serp_element_item import DataAmazonRelatedSearchesSerpElementItem
    from dataforseo_client.models.data_amazon_top_rated_from_our_brands_serp_element_item import DataAmazonTopRatedFromOurBrandsSerpElementItem

class BaseAmazonSerpElementItem(BaseModel):
    """
    BaseAmazonSerpElementItem
    """ # noqa: E501
    type: Optional[StrictStr] = Field(default=None, description="type of element")
    rank_group: Optional[StrictInt] = Field(default=None, description="position within a group of elements with identical type values positions of elements with different type values are omitted from rank_group")
    rank_absolute: Optional[StrictInt] = Field(default=None, description="absolute rank in Amazon SERP absolute position among all the elements in SERP")
    xpath: Optional[StrictStr] = Field(default=None, description="the XPath of the element")
    __properties: ClassVar[List[str]] = ["type", "rank_group", "rank_absolute", "xpath"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = 'type'

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        'amazon_paid': 'DataAmazonAmazonPaidSerpElementItem','amazon_product_info': 'DataAmazonAmazonProductInfoSerpElementItem','amazon_review_item': 'DataAmazonAmazonReviewItemSerpElementItem','amazon_seller_item': 'DataAmazonAmazonSellerItemSerpElementItem','amazon_seller_main_item': 'DataAmazonAmazonSellerMainItemSerpElementItem','amazon_serp': 'DataAmazonAmazonSerpSerpElementItem','editorial_recommendations': 'DataAmazonEditorialRecommendationsSerpElementItem','related_searches': 'DataAmazonRelatedSearchesSerpElementItem','top_rated_from_our_brands': 'DataAmazonTopRatedFromOurBrandsSerpElementItem'
    }

    @classmethod
    def get_discriminator_value(cls, obj: Dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Union[DataAmazonAmazonPaidSerpElementItem, DataAmazonAmazonProductInfoSerpElementItem, DataAmazonAmazonReviewItemSerpElementItem, DataAmazonAmazonSellerItemSerpElementItem, DataAmazonAmazonSellerMainItemSerpElementItem, DataAmazonAmazonSerpSerpElementItem, DataAmazonEditorialRecommendationsSerpElementItem, DataAmazonRelatedSearchesSerpElementItem, DataAmazonTopRatedFromOurBrandsSerpElementItem]]:
        """Create an instance of BaseAmazonSerpElementItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        # set to None if rank_group (nullable) is None
        # and model_fields_set contains the field
        if self.rank_group is None and "rank_group" in self.model_fields_set:
            _dict['rank_group'] = None

        # set to None if rank_absolute (nullable) is None
        # and model_fields_set contains the field
        if self.rank_absolute is None and "rank_absolute" in self.model_fields_set:
            _dict['rank_absolute'] = None

        # set to None if xpath (nullable) is None
        # and model_fields_set contains the field
        if self.xpath is None and "xpath" in self.model_fields_set:
            _dict['xpath'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Optional[Union[DataAmazonAmazonPaidSerpElementItem, DataAmazonAmazonProductInfoSerpElementItem, DataAmazonAmazonReviewItemSerpElementItem, DataAmazonAmazonSellerItemSerpElementItem, DataAmazonAmazonSellerMainItemSerpElementItem, DataAmazonAmazonSerpSerpElementItem, DataAmazonEditorialRecommendationsSerpElementItem, DataAmazonRelatedSearchesSerpElementItem, DataAmazonTopRatedFromOurBrandsSerpElementItem]]:
        """Create an instance of BaseAmazonSerpElementItem from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type ==  'DataAmazonAmazonPaidSerpElementItem':
            return import_module("dataforseo_client.models.data_amazon_amazon_paid_serp_element_item").DataAmazonAmazonPaidSerpElementItem.from_dict(obj)
        if object_type ==  'DataAmazonAmazonProductInfoSerpElementItem':
            return import_module("dataforseo_client.models.data_amazon_amazon_product_info_serp_element_item").DataAmazonAmazonProductInfoSerpElementItem.from_dict(obj)
        if object_type ==  'DataAmazonAmazonReviewItemSerpElementItem':
            return import_module("dataforseo_client.models.data_amazon_amazon_review_item_serp_element_item").DataAmazonAmazonReviewItemSerpElementItem.from_dict(obj)
        if object_type ==  'DataAmazonAmazonSellerItemSerpElementItem':
            return import_module("dataforseo_client.models.data_amazon_amazon_seller_item_serp_element_item").DataAmazonAmazonSellerItemSerpElementItem.from_dict(obj)
        if object_type ==  'DataAmazonAmazonSellerMainItemSerpElementItem':
            return import_module("dataforseo_client.models.data_amazon_amazon_seller_main_item_serp_element_item").DataAmazonAmazonSellerMainItemSerpElementItem.from_dict(obj)
        if object_type ==  'DataAmazonAmazonSerpSerpElementItem':
            return import_module("dataforseo_client.models.data_amazon_amazon_serp_serp_element_item").DataAmazonAmazonSerpSerpElementItem.from_dict(obj)
        if object_type ==  'DataAmazonEditorialRecommendationsSerpElementItem':
            return import_module("dataforseo_client.models.data_amazon_editorial_recommendations_serp_element_item").DataAmazonEditorialRecommendationsSerpElementItem.from_dict(obj)
        if object_type ==  'DataAmazonRelatedSearchesSerpElementItem':
            return import_module("dataforseo_client.models.data_amazon_related_searches_serp_element_item").DataAmazonRelatedSearchesSerpElementItem.from_dict(obj)
        if object_type ==  'DataAmazonTopRatedFromOurBrandsSerpElementItem':
            return import_module("dataforseo_client.models.data_amazon_top_rated_from_our_brands_serp_element_item").DataAmazonTopRatedFromOurBrandsSerpElementItem.from_dict(obj)

        raise ValueError("BaseAmazonSerpElementItem failed to lookup discriminator value from " +
                            json.dumps(obj) + ". Discriminator property name: " + cls.__discriminator_property_name +
                            ", mapping: " + json.dumps(cls.__discriminator_value_class_map))


