# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from importlib import import_module
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from dataforseo_client.models.on_page_alternate_link_element_item import OnPageAlternateLinkElementItem
    from dataforseo_client.models.on_page_anchor_link_element_item import OnPageAnchorLinkElementItem
    from dataforseo_client.models.on_page_image_link_element_item import OnPageImageLinkElementItem
    from dataforseo_client.models.on_page_redirect_link_element_item import OnPageRedirectLinkElementItem

class BaseOnPageLinkItemInfo(BaseModel):
    """
    BaseOnPageLinkItemInfo
    """ # noqa: E501
    type: Optional[StrictStr] = Field(default=None, description="type of element")
    domain_from: Optional[StrictStr] = Field(default=None, description="referring domain the link was found on this domain")
    domain_to: Optional[StrictStr] = Field(default=None, description="referenced domain the link is pointing to this domain")
    page_from: Optional[StrictStr] = Field(default=None, description="referring page relative URL of the page on which the link was found")
    page_to: Optional[StrictStr] = Field(default=None, description="referenced page relative URL of the page to which the link is pointing")
    link_from: Optional[StrictStr] = Field(default=None, description="referring page absolute URL of the page on which the link was found")
    link_to: Optional[StrictStr] = Field(default=None, description="referenced page absolute URL of the page to which the link is pointing")
    dofollow: Optional[StrictBool] = Field(default=None, description="indicates whether the link is dofollow if the value is true, the link doesn’t have a rel=\"nofollow\" attribute")
    page_from_scheme: Optional[StrictStr] = Field(default=None, description="url scheme of the referring page")
    page_to_scheme: Optional[StrictStr] = Field(default=None, description="url scheme of the referenced page")
    direction: Optional[StrictStr] = Field(default=None, description="direction of the link possible values: internal, external")
    is_broken: Optional[StrictBool] = Field(default=None, description="link is broken indicates whether a link is directing to a broken page or resource")
    is_link_relation_conflict: Optional[StrictBool] = Field(default=None, description="indicates that the link may have a conflict with another link if true, at least one link pointing to link_to has a rel=\"nofollow\" attribute and at least one is dofollow")
    __properties: ClassVar[List[str]] = ["type", "domain_from", "domain_to", "page_from", "page_to", "link_from", "link_to", "dofollow", "page_from_scheme", "page_to_scheme", "direction", "is_broken", "is_link_relation_conflict"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    # JSON field name that stores the object type
    __discriminator_property_name: ClassVar[str] = 'type'

    # discriminator mappings
    __discriminator_value_class_map: ClassVar[Dict[str, str]] = {
        'alternate': 'OnPageAlternateLinkElementItem','anchor': 'OnPageAnchorLinkElementItem','image': 'OnPageImageLinkElementItem','redirect': 'OnPageRedirectLinkElementItem'
    }

    @classmethod
    def get_discriminator_value(cls, obj: Dict[str, Any]) -> Optional[str]:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Union[OnPageAlternateLinkElementItem, OnPageAnchorLinkElementItem, OnPageImageLinkElementItem, OnPageRedirectLinkElementItem]]:
        """Create an instance of BaseOnPageLinkItemInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        # set to None if domain_from (nullable) is None
        # and model_fields_set contains the field
        if self.domain_from is None and "domain_from" in self.model_fields_set:
            _dict['domain_from'] = None

        # set to None if domain_to (nullable) is None
        # and model_fields_set contains the field
        if self.domain_to is None and "domain_to" in self.model_fields_set:
            _dict['domain_to'] = None

        # set to None if page_from (nullable) is None
        # and model_fields_set contains the field
        if self.page_from is None and "page_from" in self.model_fields_set:
            _dict['page_from'] = None

        # set to None if page_to (nullable) is None
        # and model_fields_set contains the field
        if self.page_to is None and "page_to" in self.model_fields_set:
            _dict['page_to'] = None

        # set to None if link_from (nullable) is None
        # and model_fields_set contains the field
        if self.link_from is None and "link_from" in self.model_fields_set:
            _dict['link_from'] = None

        # set to None if link_to (nullable) is None
        # and model_fields_set contains the field
        if self.link_to is None and "link_to" in self.model_fields_set:
            _dict['link_to'] = None

        # set to None if dofollow (nullable) is None
        # and model_fields_set contains the field
        if self.dofollow is None and "dofollow" in self.model_fields_set:
            _dict['dofollow'] = None

        # set to None if page_from_scheme (nullable) is None
        # and model_fields_set contains the field
        if self.page_from_scheme is None and "page_from_scheme" in self.model_fields_set:
            _dict['page_from_scheme'] = None

        # set to None if page_to_scheme (nullable) is None
        # and model_fields_set contains the field
        if self.page_to_scheme is None and "page_to_scheme" in self.model_fields_set:
            _dict['page_to_scheme'] = None

        # set to None if direction (nullable) is None
        # and model_fields_set contains the field
        if self.direction is None and "direction" in self.model_fields_set:
            _dict['direction'] = None

        # set to None if is_broken (nullable) is None
        # and model_fields_set contains the field
        if self.is_broken is None and "is_broken" in self.model_fields_set:
            _dict['is_broken'] = None

        # set to None if is_link_relation_conflict (nullable) is None
        # and model_fields_set contains the field
        if self.is_link_relation_conflict is None and "is_link_relation_conflict" in self.model_fields_set:
            _dict['is_link_relation_conflict'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Optional[Union[OnPageAlternateLinkElementItem, OnPageAnchorLinkElementItem, OnPageImageLinkElementItem, OnPageRedirectLinkElementItem]]:
        """Create an instance of BaseOnPageLinkItemInfo from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type ==  'OnPageAlternateLinkElementItem':
            return import_module("dataforseo_client.models.on_page_alternate_link_element_item").OnPageAlternateLinkElementItem.from_dict(obj)
        if object_type ==  'OnPageAnchorLinkElementItem':
            return import_module("dataforseo_client.models.on_page_anchor_link_element_item").OnPageAnchorLinkElementItem.from_dict(obj)
        if object_type ==  'OnPageImageLinkElementItem':
            return import_module("dataforseo_client.models.on_page_image_link_element_item").OnPageImageLinkElementItem.from_dict(obj)
        if object_type ==  'OnPageRedirectLinkElementItem':
            return import_module("dataforseo_client.models.on_page_redirect_link_element_item").OnPageRedirectLinkElementItem.from_dict(obj)

        raise ValueError("BaseOnPageLinkItemInfo failed to lookup discriminator value from " +
                            json.dumps(obj) + ". Discriminator property name: " + cls.__discriminator_property_name +
                            ", mapping: " + json.dumps(cls.__discriminator_value_class_map))


