# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class ContentAnalysisRatingInfo(BaseModel):
    """
    ContentAnalysisRatingInfo
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="rating name here you can find the following elements: Max5, Percents, CustomMax")
    rating_value: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="the value of the rating")
    max_rating_value: Optional[StrictInt] = Field(default=None, description="maximum value for the rating name")
    rating_count: Optional[StrictInt] = Field(default=None, description="number of votes")
    relative_rating: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="relative rating")
    __properties: ClassVar[List[str]] = ["name", "rating_value", "max_rating_value", "rating_count", "relative_rating"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ContentAnalysisRatingInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if rating_value (nullable) is None
        # and model_fields_set contains the field
        if self.rating_value is None and "rating_value" in self.model_fields_set:
            _dict['rating_value'] = None

        # set to None if max_rating_value (nullable) is None
        # and model_fields_set contains the field
        if self.max_rating_value is None and "max_rating_value" in self.model_fields_set:
            _dict['max_rating_value'] = None

        # set to None if rating_count (nullable) is None
        # and model_fields_set contains the field
        if self.rating_count is None and "rating_count" in self.model_fields_set:
            _dict['rating_count'] = None

        # set to None if relative_rating (nullable) is None
        # and model_fields_set contains the field
        if self.relative_rating is None and "relative_rating" in self.model_fields_set:
            _dict['relative_rating'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ContentAnalysisRatingInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "rating_value": obj.get("rating_value"),
            "max_rating_value": obj.get("max_rating_value"),
            "rating_count": obj.get("rating_count"),
            "relative_rating": obj.get("relative_rating")
        })
        return _obj


