# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from dataforseo_client.models.amazon_applicable_vouchers_item import AmazonApplicableVouchersItem
from dataforseo_client.models.amazon_product_newer_model_info import AmazonProductNewerModelInfo
from dataforseo_client.models.base_amazon_serp_element_item import BaseAmazonSerpElementItem
from dataforseo_client.models.base_product_information_item import BaseProductInformationItem
from dataforseo_client.models.product_category_info import ProductCategoryInfo
from dataforseo_client.models.rating_element import RatingElement
from typing import Optional, Set
from typing_extensions import Self

class DataAmazonAmazonProductInfoSerpElementItem(BaseAmazonSerpElementItem):
    """
    DataAmazonAmazonProductInfoSerpElementItem
    """ # noqa: E501
    position: Optional[StrictStr] = Field(default=None, description="the alignment of the element in Amazon SERP possible values: left, right")
    title: Optional[StrictStr] = Field(default=None, description="product title")
    details: Optional[StrictStr] = Field(default=None, description="product specs and other details")
    image_url: Optional[StrictStr] = Field(default=None, description="the URL of the product image")
    author: Optional[StrictStr] = Field(default=None, description="product brand name")
    data_asin: Optional[StrictStr] = Field(default=None, description="ASIN of the product received in a POST array")
    parent_asin: Optional[StrictStr] = Field(default=None, description="parent ASIN of the product")
    product_asins: Optional[List[Optional[StrictStr]]] = Field(default=None, description="ASINs of all found product modifications")
    price_from: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="the lower limit of the product price range example: 49.98")
    price_to: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="the upper limit of the product price range example: 384.99")
    currency: Optional[StrictStr] = Field(default=None, description="currency in the ISO format example: USD")
    is_amazon_choice: Optional[StrictBool] = Field(default=None, description="“Amazon’s choice” label if the value is true, the product is marked with the “Amazon’s choice” label")
    rating: Optional[RatingElement] = None
    is_newer_model_available: Optional[StrictBool] = Field(default=None, description="indicates whether the newer model of the product is available")
    applicable_vouchers: Optional[List[AmazonApplicableVouchersItem]] = Field(default=None, description="array of objects containing information about applicable vouchers")
    newer_model: Optional[AmazonProductNewerModelInfo] = None
    categories: Optional[List[ProductCategoryInfo]] = Field(default=None, description="contains related product categories")
    product_information: Optional[List[BaseProductInformationItem]] = Field(default=None, description="contains related product information")
    product_images_list: Optional[List[Optional[StrictStr]]] = Field(default=None, description="contains URLs for all images of the product displayed on the left side of the main image")
    product_videos_list: Optional[List[Optional[StrictStr]]] = Field(default=None, description="contains URLs for all videos of the product displayed on the right side of the main video")
    description: Optional[StrictStr] = Field(default=None, description="contains description of the product")
    is_available: Optional[StrictBool] = Field(default=None, description="indicates whether the product is available for ordering if the value is true, the product can be ordered")
    top_local_reviews: Optional[List[BaseAmazonSerpElementItem]] = Field(default=None, description="array of objects with top reviews from target location to obtain additional local reviews, you can specify the load_more_local_reviews parameter in Task POST")
    top_global_reviews: Optional[List[BaseAmazonSerpElementItem]] = Field(default=None, description="array of objects with top reviews from around the world")
    __properties: ClassVar[List[str]] = ["type", "rank_group", "rank_absolute", "xpath", "position", "title", "details", "image_url", "author", "data_asin", "parent_asin", "product_asins", "price_from", "price_to", "currency", "is_amazon_choice", "rating", "is_newer_model_available", "applicable_vouchers", "newer_model", "categories", "product_information", "product_images_list", "product_videos_list", "description", "is_available", "top_local_reviews", "top_global_reviews"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DataAmazonAmazonProductInfoSerpElementItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of rating
        if self.rating:
            _dict['rating'] = self.rating.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in applicable_vouchers (list)
        _items = []
        if self.applicable_vouchers:
            for _item_applicable_vouchers in self.applicable_vouchers:
                if _item_applicable_vouchers:
                    _items.append(_item_applicable_vouchers.to_dict())
            _dict['applicable_vouchers'] = _items
        # override the default output from pydantic by calling `to_dict()` of newer_model
        if self.newer_model:
            _dict['newer_model'] = self.newer_model.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in categories (list)
        _items = []
        if self.categories:
            for _item_categories in self.categories:
                if _item_categories:
                    _items.append(_item_categories.to_dict())
            _dict['categories'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in product_information (list)
        _items = []
        if self.product_information:
            for _item_product_information in self.product_information:
                if _item_product_information:
                    _items.append(_item_product_information.to_dict())
            _dict['product_information'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in top_local_reviews (list)
        _items = []
        if self.top_local_reviews:
            for _item_top_local_reviews in self.top_local_reviews:
                if _item_top_local_reviews:
                    _items.append(_item_top_local_reviews.to_dict())
            _dict['top_local_reviews'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in top_global_reviews (list)
        _items = []
        if self.top_global_reviews:
            for _item_top_global_reviews in self.top_global_reviews:
                if _item_top_global_reviews:
                    _items.append(_item_top_global_reviews.to_dict())
            _dict['top_global_reviews'] = _items
        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        # set to None if rank_group (nullable) is None
        # and model_fields_set contains the field
        if self.rank_group is None and "rank_group" in self.model_fields_set:
            _dict['rank_group'] = None

        # set to None if rank_absolute (nullable) is None
        # and model_fields_set contains the field
        if self.rank_absolute is None and "rank_absolute" in self.model_fields_set:
            _dict['rank_absolute'] = None

        # set to None if xpath (nullable) is None
        # and model_fields_set contains the field
        if self.xpath is None and "xpath" in self.model_fields_set:
            _dict['xpath'] = None

        # set to None if position (nullable) is None
        # and model_fields_set contains the field
        if self.position is None and "position" in self.model_fields_set:
            _dict['position'] = None

        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        # set to None if details (nullable) is None
        # and model_fields_set contains the field
        if self.details is None and "details" in self.model_fields_set:
            _dict['details'] = None

        # set to None if image_url (nullable) is None
        # and model_fields_set contains the field
        if self.image_url is None and "image_url" in self.model_fields_set:
            _dict['image_url'] = None

        # set to None if author (nullable) is None
        # and model_fields_set contains the field
        if self.author is None and "author" in self.model_fields_set:
            _dict['author'] = None

        # set to None if data_asin (nullable) is None
        # and model_fields_set contains the field
        if self.data_asin is None and "data_asin" in self.model_fields_set:
            _dict['data_asin'] = None

        # set to None if parent_asin (nullable) is None
        # and model_fields_set contains the field
        if self.parent_asin is None and "parent_asin" in self.model_fields_set:
            _dict['parent_asin'] = None

        # set to None if product_asins (nullable) is None
        # and model_fields_set contains the field
        if self.product_asins is None and "product_asins" in self.model_fields_set:
            _dict['product_asins'] = None

        # set to None if price_from (nullable) is None
        # and model_fields_set contains the field
        if self.price_from is None and "price_from" in self.model_fields_set:
            _dict['price_from'] = None

        # set to None if price_to (nullable) is None
        # and model_fields_set contains the field
        if self.price_to is None and "price_to" in self.model_fields_set:
            _dict['price_to'] = None

        # set to None if currency (nullable) is None
        # and model_fields_set contains the field
        if self.currency is None and "currency" in self.model_fields_set:
            _dict['currency'] = None

        # set to None if is_amazon_choice (nullable) is None
        # and model_fields_set contains the field
        if self.is_amazon_choice is None and "is_amazon_choice" in self.model_fields_set:
            _dict['is_amazon_choice'] = None

        # set to None if is_newer_model_available (nullable) is None
        # and model_fields_set contains the field
        if self.is_newer_model_available is None and "is_newer_model_available" in self.model_fields_set:
            _dict['is_newer_model_available'] = None

        # set to None if applicable_vouchers (nullable) is None
        # and model_fields_set contains the field
        if self.applicable_vouchers is None and "applicable_vouchers" in self.model_fields_set:
            _dict['applicable_vouchers'] = None

        # set to None if categories (nullable) is None
        # and model_fields_set contains the field
        if self.categories is None and "categories" in self.model_fields_set:
            _dict['categories'] = None

        # set to None if product_information (nullable) is None
        # and model_fields_set contains the field
        if self.product_information is None and "product_information" in self.model_fields_set:
            _dict['product_information'] = None

        # set to None if product_images_list (nullable) is None
        # and model_fields_set contains the field
        if self.product_images_list is None and "product_images_list" in self.model_fields_set:
            _dict['product_images_list'] = None

        # set to None if product_videos_list (nullable) is None
        # and model_fields_set contains the field
        if self.product_videos_list is None and "product_videos_list" in self.model_fields_set:
            _dict['product_videos_list'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if is_available (nullable) is None
        # and model_fields_set contains the field
        if self.is_available is None and "is_available" in self.model_fields_set:
            _dict['is_available'] = None

        # set to None if top_local_reviews (nullable) is None
        # and model_fields_set contains the field
        if self.top_local_reviews is None and "top_local_reviews" in self.model_fields_set:
            _dict['top_local_reviews'] = None

        # set to None if top_global_reviews (nullable) is None
        # and model_fields_set contains the field
        if self.top_global_reviews is None and "top_global_reviews" in self.model_fields_set:
            _dict['top_global_reviews'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DataAmazonAmazonProductInfoSerpElementItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "rank_group": obj.get("rank_group"),
            "rank_absolute": obj.get("rank_absolute"),
            "xpath": obj.get("xpath"),
            "position": obj.get("position"),
            "title": obj.get("title"),
            "details": obj.get("details"),
            "image_url": obj.get("image_url"),
            "author": obj.get("author"),
            "data_asin": obj.get("data_asin"),
            "parent_asin": obj.get("parent_asin"),
            "product_asins": obj.get("product_asins"),
            "price_from": obj.get("price_from"),
            "price_to": obj.get("price_to"),
            "currency": obj.get("currency"),
            "is_amazon_choice": obj.get("is_amazon_choice"),
            "rating": RatingElement.from_dict(obj["rating"]) if obj.get("rating") is not None else None,
            "is_newer_model_available": obj.get("is_newer_model_available"),
            "applicable_vouchers": [AmazonApplicableVouchersItem.from_dict(_item) for _item in obj["applicable_vouchers"]] if obj.get("applicable_vouchers") is not None else None,
            "newer_model": AmazonProductNewerModelInfo.from_dict(obj["newer_model"]) if obj.get("newer_model") is not None else None,
            "categories": [ProductCategoryInfo.from_dict(_item) for _item in obj["categories"]] if obj.get("categories") is not None else None,
            "product_information": [BaseProductInformationItem.from_dict(_item) for _item in obj["product_information"]] if obj.get("product_information") is not None else None,
            "product_images_list": obj.get("product_images_list"),
            "product_videos_list": obj.get("product_videos_list"),
            "description": obj.get("description"),
            "is_available": obj.get("is_available"),
            "top_local_reviews": [BaseAmazonSerpElementItem.from_dict(_item) for _item in obj["top_local_reviews"]] if obj.get("top_local_reviews") is not None else None,
            "top_global_reviews": [BaseAmazonSerpElementItem.from_dict(_item) for _item in obj["top_global_reviews"]] if obj.get("top_global_reviews") is not None else None
        })
        return _obj


