# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class DataforseoLabsAvailableFiltersResultInfo(BaseModel):
    """
    DataforseoLabsAvailableFiltersResultInfo
    """ # noqa: E501
    related_keywords: Optional[Dict[str, Optional[Dict[str, Optional[StrictStr]]]]] = None
    keyword_suggestions: Optional[Dict[str, Optional[Dict[str, Optional[StrictStr]]]]] = None
    ranked_keywords: Optional[Dict[str, Optional[Dict[str, Optional[StrictStr]]]]] = None
    keyword_ideas: Optional[Dict[str, Optional[Dict[str, Optional[StrictStr]]]]] = None
    serp_competitors: Optional[Dict[str, Optional[Dict[str, Optional[StrictStr]]]]] = None
    relevant_pages: Optional[Dict[str, Optional[Dict[str, Optional[StrictStr]]]]] = None
    subdomains: Optional[Dict[str, Optional[Dict[str, Optional[StrictStr]]]]] = None
    competitors_domain: Optional[Dict[str, Optional[Dict[str, Optional[StrictStr]]]]] = None
    categories_for_domain: Optional[Dict[str, Optional[Dict[str, Optional[StrictStr]]]]] = None
    keywords_for_categories: Optional[Dict[str, Optional[Dict[str, Optional[StrictStr]]]]] = None
    domain_intersection: Optional[Dict[str, Optional[Dict[str, Optional[StrictStr]]]]] = None
    page_intersection: Optional[Dict[str, Optional[Dict[str, Optional[StrictStr]]]]] = None
    domain_whois_overview: Optional[Dict[str, Optional[Dict[str, Optional[StrictStr]]]]] = None
    top_searches: Optional[Dict[str, Optional[Dict[str, Optional[StrictStr]]]]] = None
    domain_metrics_by_categories: Optional[Dict[str, Optional[Dict[str, Optional[StrictStr]]]]] = None
    keywords_for_site: Optional[Dict[str, Optional[Dict[str, Optional[StrictStr]]]]] = None
    product_competitors: Optional[Dict[str, Optional[Dict[str, Optional[StrictStr]]]]] = None
    product_keyword_intersections: Optional[Dict[str, Optional[Dict[str, Optional[StrictStr]]]]] = None
    app_intersection: Optional[Dict[str, Optional[Dict[str, Optional[StrictStr]]]]] = None
    app_competitors: Optional[Dict[str, Optional[Dict[str, Optional[StrictStr]]]]] = None
    keywords_for_app: Optional[Dict[str, Optional[Dict[str, Optional[StrictStr]]]]] = None
    database_rows_count: Optional[Dict[str, Optional[StrictStr]]] = None
    __properties: ClassVar[List[str]] = ["related_keywords", "keyword_suggestions", "ranked_keywords", "keyword_ideas", "serp_competitors", "relevant_pages", "subdomains", "competitors_domain", "categories_for_domain", "keywords_for_categories", "domain_intersection", "page_intersection", "domain_whois_overview", "top_searches", "domain_metrics_by_categories", "keywords_for_site", "product_competitors", "product_keyword_intersections", "app_intersection", "app_competitors", "keywords_for_app", "database_rows_count"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DataforseoLabsAvailableFiltersResultInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if related_keywords (nullable) is None
        # and model_fields_set contains the field
        if self.related_keywords is None and "related_keywords" in self.model_fields_set:
            _dict['related_keywords'] = None

        # set to None if keyword_suggestions (nullable) is None
        # and model_fields_set contains the field
        if self.keyword_suggestions is None and "keyword_suggestions" in self.model_fields_set:
            _dict['keyword_suggestions'] = None

        # set to None if ranked_keywords (nullable) is None
        # and model_fields_set contains the field
        if self.ranked_keywords is None and "ranked_keywords" in self.model_fields_set:
            _dict['ranked_keywords'] = None

        # set to None if keyword_ideas (nullable) is None
        # and model_fields_set contains the field
        if self.keyword_ideas is None and "keyword_ideas" in self.model_fields_set:
            _dict['keyword_ideas'] = None

        # set to None if serp_competitors (nullable) is None
        # and model_fields_set contains the field
        if self.serp_competitors is None and "serp_competitors" in self.model_fields_set:
            _dict['serp_competitors'] = None

        # set to None if relevant_pages (nullable) is None
        # and model_fields_set contains the field
        if self.relevant_pages is None and "relevant_pages" in self.model_fields_set:
            _dict['relevant_pages'] = None

        # set to None if subdomains (nullable) is None
        # and model_fields_set contains the field
        if self.subdomains is None and "subdomains" in self.model_fields_set:
            _dict['subdomains'] = None

        # set to None if competitors_domain (nullable) is None
        # and model_fields_set contains the field
        if self.competitors_domain is None and "competitors_domain" in self.model_fields_set:
            _dict['competitors_domain'] = None

        # set to None if categories_for_domain (nullable) is None
        # and model_fields_set contains the field
        if self.categories_for_domain is None and "categories_for_domain" in self.model_fields_set:
            _dict['categories_for_domain'] = None

        # set to None if keywords_for_categories (nullable) is None
        # and model_fields_set contains the field
        if self.keywords_for_categories is None and "keywords_for_categories" in self.model_fields_set:
            _dict['keywords_for_categories'] = None

        # set to None if domain_intersection (nullable) is None
        # and model_fields_set contains the field
        if self.domain_intersection is None and "domain_intersection" in self.model_fields_set:
            _dict['domain_intersection'] = None

        # set to None if page_intersection (nullable) is None
        # and model_fields_set contains the field
        if self.page_intersection is None and "page_intersection" in self.model_fields_set:
            _dict['page_intersection'] = None

        # set to None if domain_whois_overview (nullable) is None
        # and model_fields_set contains the field
        if self.domain_whois_overview is None and "domain_whois_overview" in self.model_fields_set:
            _dict['domain_whois_overview'] = None

        # set to None if top_searches (nullable) is None
        # and model_fields_set contains the field
        if self.top_searches is None and "top_searches" in self.model_fields_set:
            _dict['top_searches'] = None

        # set to None if domain_metrics_by_categories (nullable) is None
        # and model_fields_set contains the field
        if self.domain_metrics_by_categories is None and "domain_metrics_by_categories" in self.model_fields_set:
            _dict['domain_metrics_by_categories'] = None

        # set to None if keywords_for_site (nullable) is None
        # and model_fields_set contains the field
        if self.keywords_for_site is None and "keywords_for_site" in self.model_fields_set:
            _dict['keywords_for_site'] = None

        # set to None if product_competitors (nullable) is None
        # and model_fields_set contains the field
        if self.product_competitors is None and "product_competitors" in self.model_fields_set:
            _dict['product_competitors'] = None

        # set to None if product_keyword_intersections (nullable) is None
        # and model_fields_set contains the field
        if self.product_keyword_intersections is None and "product_keyword_intersections" in self.model_fields_set:
            _dict['product_keyword_intersections'] = None

        # set to None if app_intersection (nullable) is None
        # and model_fields_set contains the field
        if self.app_intersection is None and "app_intersection" in self.model_fields_set:
            _dict['app_intersection'] = None

        # set to None if app_competitors (nullable) is None
        # and model_fields_set contains the field
        if self.app_competitors is None and "app_competitors" in self.model_fields_set:
            _dict['app_competitors'] = None

        # set to None if keywords_for_app (nullable) is None
        # and model_fields_set contains the field
        if self.keywords_for_app is None and "keywords_for_app" in self.model_fields_set:
            _dict['keywords_for_app'] = None

        # set to None if database_rows_count (nullable) is None
        # and model_fields_set contains the field
        if self.database_rows_count is None and "database_rows_count" in self.model_fields_set:
            _dict['database_rows_count'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DataforseoLabsAvailableFiltersResultInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "related_keywords": obj.get("related_keywords"),
            "keyword_suggestions": obj.get("keyword_suggestions"),
            "ranked_keywords": obj.get("ranked_keywords"),
            "keyword_ideas": obj.get("keyword_ideas"),
            "serp_competitors": obj.get("serp_competitors"),
            "relevant_pages": obj.get("relevant_pages"),
            "subdomains": obj.get("subdomains"),
            "competitors_domain": obj.get("competitors_domain"),
            "categories_for_domain": obj.get("categories_for_domain"),
            "keywords_for_categories": obj.get("keywords_for_categories"),
            "domain_intersection": obj.get("domain_intersection"),
            "page_intersection": obj.get("page_intersection"),
            "domain_whois_overview": obj.get("domain_whois_overview"),
            "top_searches": obj.get("top_searches"),
            "domain_metrics_by_categories": obj.get("domain_metrics_by_categories"),
            "keywords_for_site": obj.get("keywords_for_site"),
            "product_competitors": obj.get("product_competitors"),
            "product_keyword_intersections": obj.get("product_keyword_intersections"),
            "app_intersection": obj.get("app_intersection"),
            "app_competitors": obj.get("app_competitors"),
            "keywords_for_app": obj.get("keywords_for_app"),
            "database_rows_count": obj.get("database_rows_count")
        })
        return _obj


