# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class GoogleBusinessAnswerElement(BaseModel):
    """
    GoogleBusinessAnswerElement
    """ # noqa: E501
    type: Optional[StrictStr] = Field(default=None, description="type of element")
    answer_id: Optional[StrictStr] = Field(default=None, description="ID of the answer")
    profile_image_url: Optional[StrictStr] = Field(default=None, description="URL of the user’s profile image")
    profile_url: Optional[StrictStr] = Field(default=None, description="URL of the user’s profile")
    profile_name: Optional[StrictStr] = Field(default=None, description="displayed name of the user")
    answer_text: Optional[StrictStr] = Field(default=None, description="current text of the answer")
    original_answer_text: Optional[StrictStr] = Field(default=None, description="original text of the answer")
    time_ago: Optional[StrictStr] = Field(default=None, description="estimated time when the answer was posted")
    timestamp: Optional[StrictStr] = Field(default=None, description="exact time when the answer was posted")
    __properties: ClassVar[List[str]] = ["type", "answer_id", "profile_image_url", "profile_url", "profile_name", "answer_text", "original_answer_text", "time_ago", "timestamp"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GoogleBusinessAnswerElement from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        # set to None if answer_id (nullable) is None
        # and model_fields_set contains the field
        if self.answer_id is None and "answer_id" in self.model_fields_set:
            _dict['answer_id'] = None

        # set to None if profile_image_url (nullable) is None
        # and model_fields_set contains the field
        if self.profile_image_url is None and "profile_image_url" in self.model_fields_set:
            _dict['profile_image_url'] = None

        # set to None if profile_url (nullable) is None
        # and model_fields_set contains the field
        if self.profile_url is None and "profile_url" in self.model_fields_set:
            _dict['profile_url'] = None

        # set to None if profile_name (nullable) is None
        # and model_fields_set contains the field
        if self.profile_name is None and "profile_name" in self.model_fields_set:
            _dict['profile_name'] = None

        # set to None if answer_text (nullable) is None
        # and model_fields_set contains the field
        if self.answer_text is None and "answer_text" in self.model_fields_set:
            _dict['answer_text'] = None

        # set to None if original_answer_text (nullable) is None
        # and model_fields_set contains the field
        if self.original_answer_text is None and "original_answer_text" in self.model_fields_set:
            _dict['original_answer_text'] = None

        # set to None if time_ago (nullable) is None
        # and model_fields_set contains the field
        if self.time_ago is None and "time_ago" in self.model_fields_set:
            _dict['time_ago'] = None

        # set to None if timestamp (nullable) is None
        # and model_fields_set contains the field
        if self.timestamp is None and "timestamp" in self.model_fields_set:
            _dict['timestamp'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GoogleBusinessAnswerElement from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "answer_id": obj.get("answer_id"),
            "profile_image_url": obj.get("profile_image_url"),
            "profile_url": obj.get("profile_url"),
            "profile_name": obj.get("profile_name"),
            "answer_text": obj.get("answer_text"),
            "original_answer_text": obj.get("original_answer_text"),
            "time_ago": obj.get("time_ago"),
            "timestamp": obj.get("timestamp")
        })
        return _obj


