# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from dataforseo_client.models.historical_metrics_info import HistoricalMetricsInfo
from typing import Optional, Set
from typing_extensions import Self

class HistoricalMetricsBundleInfo(BaseModel):
    """
    HistoricalMetricsBundleInfo
    """ # noqa: E501
    organic: Optional[List[HistoricalMetricsInfo]] = Field(default=None, description="traffic data from organic search")
    paid: Optional[List[HistoricalMetricsInfo]] = Field(default=None, description="traffic data from paid search")
    local_pack: Optional[List[HistoricalMetricsInfo]] = Field(default=None, description="traffic data from the featured snippet results in Google SERP")
    featured_snippet: Optional[List[HistoricalMetricsInfo]] = Field(default=None, description="traffic data from the local pack results in SERP")
    __properties: ClassVar[List[str]] = ["organic", "paid", "local_pack", "featured_snippet"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HistoricalMetricsBundleInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in organic (list)
        _items = []
        if self.organic:
            for _item_organic in self.organic:
                if _item_organic:
                    _items.append(_item_organic.to_dict())
            _dict['organic'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in paid (list)
        _items = []
        if self.paid:
            for _item_paid in self.paid:
                if _item_paid:
                    _items.append(_item_paid.to_dict())
            _dict['paid'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in local_pack (list)
        _items = []
        if self.local_pack:
            for _item_local_pack in self.local_pack:
                if _item_local_pack:
                    _items.append(_item_local_pack.to_dict())
            _dict['local_pack'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in featured_snippet (list)
        _items = []
        if self.featured_snippet:
            for _item_featured_snippet in self.featured_snippet:
                if _item_featured_snippet:
                    _items.append(_item_featured_snippet.to_dict())
            _dict['featured_snippet'] = _items
        # set to None if organic (nullable) is None
        # and model_fields_set contains the field
        if self.organic is None and "organic" in self.model_fields_set:
            _dict['organic'] = None

        # set to None if paid (nullable) is None
        # and model_fields_set contains the field
        if self.paid is None and "paid" in self.model_fields_set:
            _dict['paid'] = None

        # set to None if local_pack (nullable) is None
        # and model_fields_set contains the field
        if self.local_pack is None and "local_pack" in self.model_fields_set:
            _dict['local_pack'] = None

        # set to None if featured_snippet (nullable) is None
        # and model_fields_set contains the field
        if self.featured_snippet is None and "featured_snippet" in self.model_fields_set:
            _dict['featured_snippet'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HistoricalMetricsBundleInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "organic": [HistoricalMetricsInfo.from_dict(_item) for _item in obj["organic"]] if obj.get("organic") is not None else None,
            "paid": [HistoricalMetricsInfo.from_dict(_item) for _item in obj["paid"]] if obj.get("paid") is not None else None,
            "local_pack": [HistoricalMetricsInfo.from_dict(_item) for _item in obj["local_pack"]] if obj.get("local_pack") is not None else None,
            "featured_snippet": [HistoricalMetricsInfo.from_dict(_item) for _item in obj["featured_snippet"]] if obj.get("featured_snippet") is not None else None
        })
        return _obj


