# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class HotelAmenityItemInfo(BaseModel):
    """
    HotelAmenityItemInfo
    """ # noqa: E501
    amenity: Optional[StrictStr] = Field(default=None, description="standardised amenity name")
    amenity_label: Optional[StrictStr] = Field(default=None, description="displayed amenity name")
    hint: Optional[StrictStr] = Field(default=None, description="standardised details about the amenity")
    hint_label: Optional[StrictStr] = Field(default=None, description="displayed details about the amenity")
    is_available: Optional[StrictBool] = Field(default=None, description="indicates whether the amenity is available in the hotel")
    __properties: ClassVar[List[str]] = ["amenity", "amenity_label", "hint", "hint_label", "is_available"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HotelAmenityItemInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if amenity (nullable) is None
        # and model_fields_set contains the field
        if self.amenity is None and "amenity" in self.model_fields_set:
            _dict['amenity'] = None

        # set to None if amenity_label (nullable) is None
        # and model_fields_set contains the field
        if self.amenity_label is None and "amenity_label" in self.model_fields_set:
            _dict['amenity_label'] = None

        # set to None if hint (nullable) is None
        # and model_fields_set contains the field
        if self.hint is None and "hint" in self.model_fields_set:
            _dict['hint'] = None

        # set to None if hint_label (nullable) is None
        # and model_fields_set contains the field
        if self.hint_label is None and "hint_label" in self.model_fields_set:
            _dict['hint_label'] = None

        # set to None if is_available (nullable) is None
        # and model_fields_set contains the field
        if self.is_available is None and "is_available" in self.model_fields_set:
            _dict['is_available'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HotelAmenityItemInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "amenity": obj.get("amenity"),
            "amenity_label": obj.get("amenity_label"),
            "hint": obj.get("hint"),
            "hint_label": obj.get("hint_label"),
            "is_available": obj.get("is_available")
        })
        return _obj


