# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class HotelInfoPriceOffer(BaseModel):
    """
    featured price offers
    """ # noqa: E501
    type: Optional[StrictStr] = Field(default=None, description="type of element")
    title: Optional[StrictStr] = Field(default=None, description="title of the hotel")
    price: Optional[StrictInt] = Field(default=None, description="price per night")
    currency: Optional[StrictStr] = Field(default=None, description="price currency USD is applied by default, unless specified in the POST array")
    url: Optional[StrictStr] = Field(default=None, description="url of the price offer URL to the page of the website where price offer appears")
    max_visitors: Optional[StrictInt] = Field(default=None, description="the maximal number of visitors the maximum number of visitors for which the price offer is valid")
    offer_images: Optional[List[Optional[StrictStr]]] = Field(default=None, description="price offer images URLs of the images featured in the price offer")
    free_cancellation_until: Optional[StrictStr] = Field(default=None, description="date until free cancellation is available in the UTC format: “yyyy-mm-dd hh-mm-ss +00:00” equals null if free cancellation is not available for the selected dates")
    __properties: ClassVar[List[str]] = ["type", "title", "price", "currency", "url", "max_visitors", "offer_images", "free_cancellation_until"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HotelInfoPriceOffer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        # set to None if price (nullable) is None
        # and model_fields_set contains the field
        if self.price is None and "price" in self.model_fields_set:
            _dict['price'] = None

        # set to None if currency (nullable) is None
        # and model_fields_set contains the field
        if self.currency is None and "currency" in self.model_fields_set:
            _dict['currency'] = None

        # set to None if url (nullable) is None
        # and model_fields_set contains the field
        if self.url is None and "url" in self.model_fields_set:
            _dict['url'] = None

        # set to None if max_visitors (nullable) is None
        # and model_fields_set contains the field
        if self.max_visitors is None and "max_visitors" in self.model_fields_set:
            _dict['max_visitors'] = None

        # set to None if offer_images (nullable) is None
        # and model_fields_set contains the field
        if self.offer_images is None and "offer_images" in self.model_fields_set:
            _dict['offer_images'] = None

        # set to None if free_cancellation_until (nullable) is None
        # and model_fields_set contains the field
        if self.free_cancellation_until is None and "free_cancellation_until" in self.model_fields_set:
            _dict['free_cancellation_until'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HotelInfoPriceOffer from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "title": obj.get("title"),
            "price": obj.get("price"),
            "currency": obj.get("currency"),
            "url": obj.get("url"),
            "max_visitors": obj.get("max_visitors"),
            "offer_images": obj.get("offer_images"),
            "free_cancellation_until": obj.get("free_cancellation_until")
        })
        return _obj


