# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from dataforseo_client.models.address_info import AddressInfo
from dataforseo_client.models.base_google_maps_serp_element_item import BaseGoogleMapsSerpElementItem
from dataforseo_client.models.local_justification_info import LocalJustificationInfo
from dataforseo_client.models.rating_info import RatingInfo
from dataforseo_client.models.work_hours import WorkHours
from typing import Optional, Set
from typing_extensions import Self

class MapsSearchSerpElementItem(BaseGoogleMapsSerpElementItem):
    """
    MapsSearchSerpElementItem
    """ # noqa: E501
    contact_url: Optional[StrictStr] = Field(default=None, description="URL of the preferred contact page")
    contributor_url: Optional[StrictStr] = Field(default=None, description="URL of the user’s or entity’s Local Guides profile, if available")
    book_online_url: Optional[StrictStr] = Field(default=None, description="URL in the ‘book online’ button of the element URL directing users to the online booking or order page of the business entity")
    hotel_rating: Optional[StrictInt] = Field(default=None, description="hotel class rating class ratings range between 1-5 stars, learn more if there is no hotel class rating information, the value will be null")
    price_level: Optional[StrictStr] = Field(default=None, description="property price level can take values: inexpensive, moderate, expensive, very_expensive if there is no price level information, the value will be null")
    snippet: Optional[StrictStr] = Field(default=None, description="element snippet contains the address and other information about the local establishment featured in the element")
    address: Optional[StrictStr] = Field(default=None, description="address line address of the local establishment featured in the element")
    address_info: Optional[AddressInfo] = None
    place_id: Optional[StrictStr] = Field(default=None, description="unique place identifier place id of the local establishment featured in the element")
    phone: Optional[StrictStr] = Field(default=None, description="phone number phone number of the local establishment featured in the element")
    main_image: Optional[StrictStr] = Field(default=None, description="URL of the main image featured in Google My Business profile")
    total_photos: Optional[StrictInt] = Field(default=None, description="total count of images featured in Google My Business profile")
    category: Optional[StrictStr] = Field(default=None, description="business category Google My Business general category that best describes the services provided by the business entity")
    additional_categories: Optional[List[Optional[StrictStr]]] = Field(default=None, description="additional business categories additional Google My Business categories that describe the services provided by the business entity in more detail")
    category_ids: Optional[List[Optional[StrictStr]]] = Field(default=None, description="global category IDs universal category IDs that do not change based on the selected country")
    work_hours: Optional[WorkHours] = None
    feature_id: Optional[StrictStr] = Field(default=None, description="the unique identifier of the element in SERP")
    cid: Optional[StrictStr] = Field(default=None, description="google-defined client id unique id of a local establishment; can be used with Google Reviews API to get a full list of reviews")
    latitude: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="latitude coordinate of the local establishments in google maps example: \"latitude\": 51.584091")
    longitude: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="longitude coordinate of the local establishment in google maps example: \"longitude\": -0.31365919999999997")
    is_claimed: Optional[StrictBool] = Field(default=None, description="indicates whether ownership of this local establishment is claimed")
    local_justifications: Optional[List[LocalJustificationInfo]] = Field(default=None, description="Google local justifications snippets of text that “justify” why the business is showing up for search query")
    is_directory_item: Optional[StrictBool] = Field(default=None, description="indicates whether this local establishment is a directory")
    __properties: ClassVar[List[str]] = ["type", "rank_group", "rank_absolute", "domain", "title", "url", "rating", "rating_distribution", "contact_url", "contributor_url", "book_online_url", "hotel_rating", "price_level", "snippet", "address", "address_info", "place_id", "phone", "main_image", "total_photos", "category", "additional_categories", "category_ids", "work_hours", "feature_id", "cid", "latitude", "longitude", "is_claimed", "local_justifications", "is_directory_item"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MapsSearchSerpElementItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of rating
        if self.rating:
            _dict['rating'] = self.rating.to_dict()
        # override the default output from pydantic by calling `to_dict()` of address_info
        if self.address_info:
            _dict['address_info'] = self.address_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of work_hours
        if self.work_hours:
            _dict['work_hours'] = self.work_hours.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in local_justifications (list)
        _items = []
        if self.local_justifications:
            for _item_local_justifications in self.local_justifications:
                if _item_local_justifications:
                    _items.append(_item_local_justifications.to_dict())
            _dict['local_justifications'] = _items
        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        # set to None if rank_group (nullable) is None
        # and model_fields_set contains the field
        if self.rank_group is None and "rank_group" in self.model_fields_set:
            _dict['rank_group'] = None

        # set to None if rank_absolute (nullable) is None
        # and model_fields_set contains the field
        if self.rank_absolute is None and "rank_absolute" in self.model_fields_set:
            _dict['rank_absolute'] = None

        # set to None if domain (nullable) is None
        # and model_fields_set contains the field
        if self.domain is None and "domain" in self.model_fields_set:
            _dict['domain'] = None

        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        # set to None if url (nullable) is None
        # and model_fields_set contains the field
        if self.url is None and "url" in self.model_fields_set:
            _dict['url'] = None

        # set to None if rating_distribution (nullable) is None
        # and model_fields_set contains the field
        if self.rating_distribution is None and "rating_distribution" in self.model_fields_set:
            _dict['rating_distribution'] = None

        # set to None if contact_url (nullable) is None
        # and model_fields_set contains the field
        if self.contact_url is None and "contact_url" in self.model_fields_set:
            _dict['contact_url'] = None

        # set to None if contributor_url (nullable) is None
        # and model_fields_set contains the field
        if self.contributor_url is None and "contributor_url" in self.model_fields_set:
            _dict['contributor_url'] = None

        # set to None if book_online_url (nullable) is None
        # and model_fields_set contains the field
        if self.book_online_url is None and "book_online_url" in self.model_fields_set:
            _dict['book_online_url'] = None

        # set to None if hotel_rating (nullable) is None
        # and model_fields_set contains the field
        if self.hotel_rating is None and "hotel_rating" in self.model_fields_set:
            _dict['hotel_rating'] = None

        # set to None if price_level (nullable) is None
        # and model_fields_set contains the field
        if self.price_level is None and "price_level" in self.model_fields_set:
            _dict['price_level'] = None

        # set to None if snippet (nullable) is None
        # and model_fields_set contains the field
        if self.snippet is None and "snippet" in self.model_fields_set:
            _dict['snippet'] = None

        # set to None if address (nullable) is None
        # and model_fields_set contains the field
        if self.address is None and "address" in self.model_fields_set:
            _dict['address'] = None

        # set to None if place_id (nullable) is None
        # and model_fields_set contains the field
        if self.place_id is None and "place_id" in self.model_fields_set:
            _dict['place_id'] = None

        # set to None if phone (nullable) is None
        # and model_fields_set contains the field
        if self.phone is None and "phone" in self.model_fields_set:
            _dict['phone'] = None

        # set to None if main_image (nullable) is None
        # and model_fields_set contains the field
        if self.main_image is None and "main_image" in self.model_fields_set:
            _dict['main_image'] = None

        # set to None if total_photos (nullable) is None
        # and model_fields_set contains the field
        if self.total_photos is None and "total_photos" in self.model_fields_set:
            _dict['total_photos'] = None

        # set to None if category (nullable) is None
        # and model_fields_set contains the field
        if self.category is None and "category" in self.model_fields_set:
            _dict['category'] = None

        # set to None if additional_categories (nullable) is None
        # and model_fields_set contains the field
        if self.additional_categories is None and "additional_categories" in self.model_fields_set:
            _dict['additional_categories'] = None

        # set to None if category_ids (nullable) is None
        # and model_fields_set contains the field
        if self.category_ids is None and "category_ids" in self.model_fields_set:
            _dict['category_ids'] = None

        # set to None if feature_id (nullable) is None
        # and model_fields_set contains the field
        if self.feature_id is None and "feature_id" in self.model_fields_set:
            _dict['feature_id'] = None

        # set to None if cid (nullable) is None
        # and model_fields_set contains the field
        if self.cid is None and "cid" in self.model_fields_set:
            _dict['cid'] = None

        # set to None if latitude (nullable) is None
        # and model_fields_set contains the field
        if self.latitude is None and "latitude" in self.model_fields_set:
            _dict['latitude'] = None

        # set to None if longitude (nullable) is None
        # and model_fields_set contains the field
        if self.longitude is None and "longitude" in self.model_fields_set:
            _dict['longitude'] = None

        # set to None if is_claimed (nullable) is None
        # and model_fields_set contains the field
        if self.is_claimed is None and "is_claimed" in self.model_fields_set:
            _dict['is_claimed'] = None

        # set to None if local_justifications (nullable) is None
        # and model_fields_set contains the field
        if self.local_justifications is None and "local_justifications" in self.model_fields_set:
            _dict['local_justifications'] = None

        # set to None if is_directory_item (nullable) is None
        # and model_fields_set contains the field
        if self.is_directory_item is None and "is_directory_item" in self.model_fields_set:
            _dict['is_directory_item'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MapsSearchSerpElementItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "rank_group": obj.get("rank_group"),
            "rank_absolute": obj.get("rank_absolute"),
            "domain": obj.get("domain"),
            "title": obj.get("title"),
            "url": obj.get("url"),
            "rating": RatingInfo.from_dict(obj["rating"]) if obj.get("rating") is not None else None,
            "rating_distribution": obj.get("rating_distribution"),
            "contact_url": obj.get("contact_url"),
            "contributor_url": obj.get("contributor_url"),
            "book_online_url": obj.get("book_online_url"),
            "hotel_rating": obj.get("hotel_rating"),
            "price_level": obj.get("price_level"),
            "snippet": obj.get("snippet"),
            "address": obj.get("address"),
            "address_info": AddressInfo.from_dict(obj["address_info"]) if obj.get("address_info") is not None else None,
            "place_id": obj.get("place_id"),
            "phone": obj.get("phone"),
            "main_image": obj.get("main_image"),
            "total_photos": obj.get("total_photos"),
            "category": obj.get("category"),
            "additional_categories": obj.get("additional_categories"),
            "category_ids": obj.get("category_ids"),
            "work_hours": WorkHours.from_dict(obj["work_hours"]) if obj.get("work_hours") is not None else None,
            "feature_id": obj.get("feature_id"),
            "cid": obj.get("cid"),
            "latitude": obj.get("latitude"),
            "longitude": obj.get("longitude"),
            "is_claimed": obj.get("is_claimed"),
            "local_justifications": [LocalJustificationInfo.from_dict(_item) for _item in obj["local_justifications"]] if obj.get("local_justifications") is not None else None,
            "is_directory_item": obj.get("is_directory_item")
        })
        return _obj


