# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dataforseo_client.models.base_on_page_resource_item_info import BaseOnPageResourceItemInfo
from dataforseo_client.models.cache_control import CacheControl
from dataforseo_client.models.fetch_timing import FetchTiming
from dataforseo_client.models.last_modified import LastModified
from dataforseo_client.models.on_page_resource_issue_info import OnPageResourceIssueInfo
from dataforseo_client.models.page_meta_info import PageMetaInfo
from typing import Optional, Set
from typing_extensions import Self

class OnPageBrokenResourceElementItem(BaseOnPageResourceItemInfo):
    """
    OnPageBrokenResourceElementItem
    """ # noqa: E501
    meta: Optional[PageMetaInfo] = None
    fetch_timing: Optional[FetchTiming] = None
    accept_type: Optional[StrictStr] = Field(default=None, description="indicates the expected type of resource for example, if \"resource_type\": \"broken\", accept_type will indicate the type of the broken resource possible values: any, none, image, sitemap, robots, script, stylesheet, redirect, html, text, other, font")
    __properties: ClassVar[List[str]] = ["resource_type", "status_code", "location", "url", "resource_errors", "size", "encoded_size", "total_transfer_size", "fetch_time", "cache_control", "checks", "content_encoding", "media_type", "server", "last_modified", "meta", "fetch_timing", "accept_type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OnPageBrokenResourceElementItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of resource_errors
        if self.resource_errors:
            _dict['resource_errors'] = self.resource_errors.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cache_control
        if self.cache_control:
            _dict['cache_control'] = self.cache_control.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_modified
        if self.last_modified:
            _dict['last_modified'] = self.last_modified.to_dict()
        # override the default output from pydantic by calling `to_dict()` of meta
        if self.meta:
            _dict['meta'] = self.meta.to_dict()
        # override the default output from pydantic by calling `to_dict()` of fetch_timing
        if self.fetch_timing:
            _dict['fetch_timing'] = self.fetch_timing.to_dict()
        # set to None if resource_type (nullable) is None
        # and model_fields_set contains the field
        if self.resource_type is None and "resource_type" in self.model_fields_set:
            _dict['resource_type'] = None

        # set to None if status_code (nullable) is None
        # and model_fields_set contains the field
        if self.status_code is None and "status_code" in self.model_fields_set:
            _dict['status_code'] = None

        # set to None if location (nullable) is None
        # and model_fields_set contains the field
        if self.location is None and "location" in self.model_fields_set:
            _dict['location'] = None

        # set to None if url (nullable) is None
        # and model_fields_set contains the field
        if self.url is None and "url" in self.model_fields_set:
            _dict['url'] = None

        # set to None if size (nullable) is None
        # and model_fields_set contains the field
        if self.size is None and "size" in self.model_fields_set:
            _dict['size'] = None

        # set to None if encoded_size (nullable) is None
        # and model_fields_set contains the field
        if self.encoded_size is None and "encoded_size" in self.model_fields_set:
            _dict['encoded_size'] = None

        # set to None if total_transfer_size (nullable) is None
        # and model_fields_set contains the field
        if self.total_transfer_size is None and "total_transfer_size" in self.model_fields_set:
            _dict['total_transfer_size'] = None

        # set to None if fetch_time (nullable) is None
        # and model_fields_set contains the field
        if self.fetch_time is None and "fetch_time" in self.model_fields_set:
            _dict['fetch_time'] = None

        # set to None if checks (nullable) is None
        # and model_fields_set contains the field
        if self.checks is None and "checks" in self.model_fields_set:
            _dict['checks'] = None

        # set to None if content_encoding (nullable) is None
        # and model_fields_set contains the field
        if self.content_encoding is None and "content_encoding" in self.model_fields_set:
            _dict['content_encoding'] = None

        # set to None if media_type (nullable) is None
        # and model_fields_set contains the field
        if self.media_type is None and "media_type" in self.model_fields_set:
            _dict['media_type'] = None

        # set to None if server (nullable) is None
        # and model_fields_set contains the field
        if self.server is None and "server" in self.model_fields_set:
            _dict['server'] = None

        # set to None if accept_type (nullable) is None
        # and model_fields_set contains the field
        if self.accept_type is None and "accept_type" in self.model_fields_set:
            _dict['accept_type'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OnPageBrokenResourceElementItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "resource_type": obj.get("resource_type"),
            "status_code": obj.get("status_code"),
            "location": obj.get("location"),
            "url": obj.get("url"),
            "resource_errors": OnPageResourceIssueInfo.from_dict(obj["resource_errors"]) if obj.get("resource_errors") is not None else None,
            "size": obj.get("size"),
            "encoded_size": obj.get("encoded_size"),
            "total_transfer_size": obj.get("total_transfer_size"),
            "fetch_time": obj.get("fetch_time"),
            "cache_control": CacheControl.from_dict(obj["cache_control"]) if obj.get("cache_control") is not None else None,
            "checks": obj.get("checks"),
            "content_encoding": obj.get("content_encoding"),
            "media_type": obj.get("media_type"),
            "server": obj.get("server"),
            "last_modified": LastModified.from_dict(obj["last_modified"]) if obj.get("last_modified") is not None else None,
            "meta": PageMetaInfo.from_dict(obj["meta"]) if obj.get("meta") is not None else None,
            "fetch_timing": FetchTiming.from_dict(obj["fetch_timing"]) if obj.get("fetch_timing") is not None else None,
            "accept_type": obj.get("accept_type")
        })
        return _obj


