# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dataforseo_client.models.crawl_status_info import CrawlStatusInfo
from dataforseo_client.models.domain_info import DomainInfo
from dataforseo_client.models.page_metrics import PageMetrics
from typing import Optional, Set
from typing_extensions import Self

class OnPageSummaryResultInfo(BaseModel):
    """
    OnPageSummaryResultInfo
    """ # noqa: E501
    crawl_progress: Optional[StrictStr] = Field(default=None, description="status of the crawling session possible values: in_progress, finished")
    crawl_status: Optional[CrawlStatusInfo] = None
    crawl_gateway_address: Optional[StrictStr] = Field(default=None, description="crawler ip address displays the IP address used by the crawler to initiate the current crawling session you can find the full list of IPs used by our crawler in the Overview section")
    crawl_stop_reason: Optional[StrictStr] = Field(default=None, description="reason why the crawling stopped information about the reason why the crawling process stopped; possible values: limit_exceeded – the limit set in the max_crawl_pages was exceeded; empty_queue – all URLs in the queue were crawled; force_stopped – the crawling process was halted using the On Page API Force Stop function; unexpected_exception – an internal error was encountered while crawling the target, contact support for more info")
    domain_info: Optional[DomainInfo] = None
    page_metrics: Optional[PageMetrics] = None
    __properties: ClassVar[List[str]] = ["crawl_progress", "crawl_status", "crawl_gateway_address", "crawl_stop_reason", "domain_info", "page_metrics"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OnPageSummaryResultInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of crawl_status
        if self.crawl_status:
            _dict['crawl_status'] = self.crawl_status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of domain_info
        if self.domain_info:
            _dict['domain_info'] = self.domain_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of page_metrics
        if self.page_metrics:
            _dict['page_metrics'] = self.page_metrics.to_dict()
        # set to None if crawl_progress (nullable) is None
        # and model_fields_set contains the field
        if self.crawl_progress is None and "crawl_progress" in self.model_fields_set:
            _dict['crawl_progress'] = None

        # set to None if crawl_gateway_address (nullable) is None
        # and model_fields_set contains the field
        if self.crawl_gateway_address is None and "crawl_gateway_address" in self.model_fields_set:
            _dict['crawl_gateway_address'] = None

        # set to None if crawl_stop_reason (nullable) is None
        # and model_fields_set contains the field
        if self.crawl_stop_reason is None and "crawl_stop_reason" in self.model_fields_set:
            _dict['crawl_stop_reason'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OnPageSummaryResultInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "crawl_progress": obj.get("crawl_progress"),
            "crawl_status": CrawlStatusInfo.from_dict(obj["crawl_status"]) if obj.get("crawl_status") is not None else None,
            "crawl_gateway_address": obj.get("crawl_gateway_address"),
            "crawl_stop_reason": obj.get("crawl_stop_reason"),
            "domain_info": DomainInfo.from_dict(obj["domain_info"]) if obj.get("domain_info") is not None else None,
            "page_metrics": PageMetrics.from_dict(obj["page_metrics"]) if obj.get("page_metrics") is not None else None
        })
        return _obj


