# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from dataforseo_client.models.html_content_info import HtmlContentInfo
from dataforseo_client.models.on_page_resource_issue_info import OnPageResourceIssueInfo
from dataforseo_client.models.spell_info import SpellInfo
from typing import Optional, Set
from typing_extensions import Self

class PageMetaInfo(BaseModel):
    """
    PageMetaInfo
    """ # noqa: E501
    title: Optional[StrictStr] = Field(default=None, description="page title")
    charset: Optional[StrictInt] = Field(default=None, description="code page example: 65001")
    follow: Optional[StrictBool] = Field(default=None, description="indicates whether a page’s ‘meta robots’ allows crawlers to follow the links on the page if false, the page’s ‘meta robots’ tag contains “nofollow” parameter instructing crawlers not to follow the links on the page")
    generator: Optional[StrictStr] = Field(default=None, description="meta tag generator")
    htags: Optional[Dict[str, Optional[List[StrictStr]]]] = Field(default=None, description="HTML header tags")
    description: Optional[StrictStr] = Field(default=None, description="content of the meta description tag")
    favicon: Optional[StrictStr] = Field(default=None, description="favicon of the page")
    meta_keywords: Optional[StrictStr] = Field(default=None, description="content of the keywords meta tag")
    canonical: Optional[StrictStr] = Field(default=None, description="canonical page")
    internal_links_count: Optional[StrictInt] = Field(default=None, description="number of internal links on the page")
    external_links_count: Optional[StrictInt] = Field(default=None, description="number of external links on the page")
    inbound_links_count: Optional[StrictInt] = Field(default=None, description="number of internal links pointing at the page")
    images_count: Optional[StrictInt] = Field(default=None, description="number of images on the page")
    images_size: Optional[StrictInt] = Field(default=None, description="total size of images on the page measured in bytes")
    scripts_count: Optional[StrictInt] = Field(default=None, description="number of scripts on the page")
    scripts_size: Optional[StrictInt] = Field(default=None, description="total size of scripts on the page measured in bytes")
    stylesheets_count: Optional[StrictInt] = Field(default=None, description="number of stylesheets on the page")
    stylesheets_size: Optional[StrictInt] = Field(default=None, description="total size of stylesheets on the page measured in bytes")
    title_length: Optional[StrictInt] = Field(default=None, description="length of the title tag in characters")
    description_length: Optional[StrictInt] = Field(default=None, description="length of the description tag in characters")
    render_blocking_scripts_count: Optional[StrictInt] = Field(default=None, description="number of scripts on the page that block page rendering")
    render_blocking_stylesheets_count: Optional[StrictInt] = Field(default=None, description="number of CSS styles on the page that block page rendering")
    cumulative_layout_shift: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Core Web Vitals metric measuring the layout stability of the page measures the sum total of all individual layout shift scores for every unexpected layout shift that occurs during the entire lifespan of the page. Learn more.")
    meta_title: Optional[StrictStr] = Field(default=None, description="meta title of the page meta tag in the head section of an HTML document that defines the title of a page")
    content: Optional[HtmlContentInfo] = None
    deprecated_tags: Optional[List[Optional[StrictStr]]] = Field(default=None, description="deprecated tags on the page")
    duplicate_meta_tags: Optional[List[Optional[StrictStr]]] = Field(default=None, description="duplicate meta tags on the page")
    spell: Optional[SpellInfo] = None
    social_media_tags: Optional[Dict[str, Optional[StrictStr]]] = Field(default=None, description="object of social media tags found on the page contains social media tags and their content supported tags include but are not limited to Open Graph and Twitter card")
    broken_html: Optional[OnPageResourceIssueInfo] = None
    __properties: ClassVar[List[str]] = ["title", "charset", "follow", "generator", "htags", "description", "favicon", "meta_keywords", "canonical", "internal_links_count", "external_links_count", "inbound_links_count", "images_count", "images_size", "scripts_count", "scripts_size", "stylesheets_count", "stylesheets_size", "title_length", "description_length", "render_blocking_scripts_count", "render_blocking_stylesheets_count", "cumulative_layout_shift", "meta_title", "content", "deprecated_tags", "duplicate_meta_tags", "spell", "social_media_tags", "broken_html"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PageMetaInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of content
        if self.content:
            _dict['content'] = self.content.to_dict()
        # override the default output from pydantic by calling `to_dict()` of spell
        if self.spell:
            _dict['spell'] = self.spell.to_dict()
        # override the default output from pydantic by calling `to_dict()` of broken_html
        if self.broken_html:
            _dict['broken_html'] = self.broken_html.to_dict()
        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        # set to None if charset (nullable) is None
        # and model_fields_set contains the field
        if self.charset is None and "charset" in self.model_fields_set:
            _dict['charset'] = None

        # set to None if follow (nullable) is None
        # and model_fields_set contains the field
        if self.follow is None and "follow" in self.model_fields_set:
            _dict['follow'] = None

        # set to None if generator (nullable) is None
        # and model_fields_set contains the field
        if self.generator is None and "generator" in self.model_fields_set:
            _dict['generator'] = None

        # set to None if htags (nullable) is None
        # and model_fields_set contains the field
        if self.htags is None and "htags" in self.model_fields_set:
            _dict['htags'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if favicon (nullable) is None
        # and model_fields_set contains the field
        if self.favicon is None and "favicon" in self.model_fields_set:
            _dict['favicon'] = None

        # set to None if meta_keywords (nullable) is None
        # and model_fields_set contains the field
        if self.meta_keywords is None and "meta_keywords" in self.model_fields_set:
            _dict['meta_keywords'] = None

        # set to None if canonical (nullable) is None
        # and model_fields_set contains the field
        if self.canonical is None and "canonical" in self.model_fields_set:
            _dict['canonical'] = None

        # set to None if internal_links_count (nullable) is None
        # and model_fields_set contains the field
        if self.internal_links_count is None and "internal_links_count" in self.model_fields_set:
            _dict['internal_links_count'] = None

        # set to None if external_links_count (nullable) is None
        # and model_fields_set contains the field
        if self.external_links_count is None and "external_links_count" in self.model_fields_set:
            _dict['external_links_count'] = None

        # set to None if inbound_links_count (nullable) is None
        # and model_fields_set contains the field
        if self.inbound_links_count is None and "inbound_links_count" in self.model_fields_set:
            _dict['inbound_links_count'] = None

        # set to None if images_count (nullable) is None
        # and model_fields_set contains the field
        if self.images_count is None and "images_count" in self.model_fields_set:
            _dict['images_count'] = None

        # set to None if images_size (nullable) is None
        # and model_fields_set contains the field
        if self.images_size is None and "images_size" in self.model_fields_set:
            _dict['images_size'] = None

        # set to None if scripts_count (nullable) is None
        # and model_fields_set contains the field
        if self.scripts_count is None and "scripts_count" in self.model_fields_set:
            _dict['scripts_count'] = None

        # set to None if scripts_size (nullable) is None
        # and model_fields_set contains the field
        if self.scripts_size is None and "scripts_size" in self.model_fields_set:
            _dict['scripts_size'] = None

        # set to None if stylesheets_count (nullable) is None
        # and model_fields_set contains the field
        if self.stylesheets_count is None and "stylesheets_count" in self.model_fields_set:
            _dict['stylesheets_count'] = None

        # set to None if stylesheets_size (nullable) is None
        # and model_fields_set contains the field
        if self.stylesheets_size is None and "stylesheets_size" in self.model_fields_set:
            _dict['stylesheets_size'] = None

        # set to None if title_length (nullable) is None
        # and model_fields_set contains the field
        if self.title_length is None and "title_length" in self.model_fields_set:
            _dict['title_length'] = None

        # set to None if description_length (nullable) is None
        # and model_fields_set contains the field
        if self.description_length is None and "description_length" in self.model_fields_set:
            _dict['description_length'] = None

        # set to None if render_blocking_scripts_count (nullable) is None
        # and model_fields_set contains the field
        if self.render_blocking_scripts_count is None and "render_blocking_scripts_count" in self.model_fields_set:
            _dict['render_blocking_scripts_count'] = None

        # set to None if render_blocking_stylesheets_count (nullable) is None
        # and model_fields_set contains the field
        if self.render_blocking_stylesheets_count is None and "render_blocking_stylesheets_count" in self.model_fields_set:
            _dict['render_blocking_stylesheets_count'] = None

        # set to None if cumulative_layout_shift (nullable) is None
        # and model_fields_set contains the field
        if self.cumulative_layout_shift is None and "cumulative_layout_shift" in self.model_fields_set:
            _dict['cumulative_layout_shift'] = None

        # set to None if meta_title (nullable) is None
        # and model_fields_set contains the field
        if self.meta_title is None and "meta_title" in self.model_fields_set:
            _dict['meta_title'] = None

        # set to None if deprecated_tags (nullable) is None
        # and model_fields_set contains the field
        if self.deprecated_tags is None and "deprecated_tags" in self.model_fields_set:
            _dict['deprecated_tags'] = None

        # set to None if duplicate_meta_tags (nullable) is None
        # and model_fields_set contains the field
        if self.duplicate_meta_tags is None and "duplicate_meta_tags" in self.model_fields_set:
            _dict['duplicate_meta_tags'] = None

        # set to None if social_media_tags (nullable) is None
        # and model_fields_set contains the field
        if self.social_media_tags is None and "social_media_tags" in self.model_fields_set:
            _dict['social_media_tags'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PageMetaInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "title": obj.get("title"),
            "charset": obj.get("charset"),
            "follow": obj.get("follow"),
            "generator": obj.get("generator"),
            "htags": obj.get("htags"),
            "description": obj.get("description"),
            "favicon": obj.get("favicon"),
            "meta_keywords": obj.get("meta_keywords"),
            "canonical": obj.get("canonical"),
            "internal_links_count": obj.get("internal_links_count"),
            "external_links_count": obj.get("external_links_count"),
            "inbound_links_count": obj.get("inbound_links_count"),
            "images_count": obj.get("images_count"),
            "images_size": obj.get("images_size"),
            "scripts_count": obj.get("scripts_count"),
            "scripts_size": obj.get("scripts_size"),
            "stylesheets_count": obj.get("stylesheets_count"),
            "stylesheets_size": obj.get("stylesheets_size"),
            "title_length": obj.get("title_length"),
            "description_length": obj.get("description_length"),
            "render_blocking_scripts_count": obj.get("render_blocking_scripts_count"),
            "render_blocking_stylesheets_count": obj.get("render_blocking_stylesheets_count"),
            "cumulative_layout_shift": obj.get("cumulative_layout_shift"),
            "meta_title": obj.get("meta_title"),
            "content": HtmlContentInfo.from_dict(obj["content"]) if obj.get("content") is not None else None,
            "deprecated_tags": obj.get("deprecated_tags"),
            "duplicate_meta_tags": obj.get("duplicate_meta_tags"),
            "spell": SpellInfo.from_dict(obj["spell"]) if obj.get("spell") is not None else None,
            "social_media_tags": obj.get("social_media_tags"),
            "broken_html": OnPageResourceIssueInfo.from_dict(obj["broken_html"]) if obj.get("broken_html") is not None else None
        })
        return _obj


