# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class Table(BaseModel):
    """
    Table
    """ # noqa: E501
    table_element: Optional[StrictStr] = Field(default=None, description="name assigned to the table element possible values: table_element")
    table_header: Optional[List[Optional[StrictStr]]] = Field(default=None, description="column names")
    table_content: Optional[List[Optional[List[Optional[StrictStr]]]]] = Field(default=None, description="the content of the table one line of the table in this element of the array")
    __properties: ClassVar[List[str]] = ["table_element", "table_header", "table_content"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Table from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if table_element (nullable) is None
        # and model_fields_set contains the field
        if self.table_element is None and "table_element" in self.model_fields_set:
            _dict['table_element'] = None

        # set to None if table_header (nullable) is None
        # and model_fields_set contains the field
        if self.table_header is None and "table_header" in self.model_fields_set:
            _dict['table_header'] = None

        # set to None if table_content (nullable) is None
        # and model_fields_set contains the field
        if self.table_content is None and "table_content" in self.model_fields_set:
            _dict['table_content'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Table from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "table_element": obj.get("table_element"),
            "table_header": obj.get("table_header"),
            "table_content": obj.get("table_content")
        })
        return _obj


