# coding: utf-8

"""
    DataForSEO API documentation

    DataForSEO API is the starting point on your journey towards building powerful SEO software. With DataForSEO you can get all the data you need to build an efficient application while also saving your time and budget. DataForSEO API is using the REST technology for interchanging data between your application and our service. The data exchange is made through the widely used HTTP protocol, which allows applying our API to almost all programming languages.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dataforseo_client.models.content_item_info import ContentItemInfo
from dataforseo_client.models.table_content import TableContent
from typing import Optional, Set
from typing_extensions import Self

class TopicInfo(BaseModel):
    """
    TopicInfo
    """ # noqa: E501
    h_title: Optional[StrictStr] = Field(default=None, description="meta title")
    main_title: Optional[StrictStr] = Field(default=None, description="main title of the block")
    author: Optional[StrictStr] = Field(default=None, description="content author name")
    language: Optional[StrictStr] = Field(default=None, description="content language")
    level: Optional[StrictStr] = Field(default=None, description="HTML level")
    primary_content: Optional[List[ContentItemInfo]] = Field(default=None, description="primary content on the page you can find more information about content priority calculation in this help center article")
    secondary_content: Optional[List[ContentItemInfo]] = Field(default=None, description="secondary content on the page you can find more information about content priority calculation in this help center article")
    table_content: Optional[List[TableContent]] = Field(default=None, description="content of the table on the page")
    __properties: ClassVar[List[str]] = ["h_title", "main_title", "author", "language", "level", "primary_content", "secondary_content", "table_content"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TopicInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in primary_content (list)
        _items = []
        if self.primary_content:
            for _item_primary_content in self.primary_content:
                if _item_primary_content:
                    _items.append(_item_primary_content.to_dict())
            _dict['primary_content'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in secondary_content (list)
        _items = []
        if self.secondary_content:
            for _item_secondary_content in self.secondary_content:
                if _item_secondary_content:
                    _items.append(_item_secondary_content.to_dict())
            _dict['secondary_content'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in table_content (list)
        _items = []
        if self.table_content:
            for _item_table_content in self.table_content:
                if _item_table_content:
                    _items.append(_item_table_content.to_dict())
            _dict['table_content'] = _items
        # set to None if h_title (nullable) is None
        # and model_fields_set contains the field
        if self.h_title is None and "h_title" in self.model_fields_set:
            _dict['h_title'] = None

        # set to None if main_title (nullable) is None
        # and model_fields_set contains the field
        if self.main_title is None and "main_title" in self.model_fields_set:
            _dict['main_title'] = None

        # set to None if author (nullable) is None
        # and model_fields_set contains the field
        if self.author is None and "author" in self.model_fields_set:
            _dict['author'] = None

        # set to None if language (nullable) is None
        # and model_fields_set contains the field
        if self.language is None and "language" in self.model_fields_set:
            _dict['language'] = None

        # set to None if level (nullable) is None
        # and model_fields_set contains the field
        if self.level is None and "level" in self.model_fields_set:
            _dict['level'] = None

        # set to None if primary_content (nullable) is None
        # and model_fields_set contains the field
        if self.primary_content is None and "primary_content" in self.model_fields_set:
            _dict['primary_content'] = None

        # set to None if secondary_content (nullable) is None
        # and model_fields_set contains the field
        if self.secondary_content is None and "secondary_content" in self.model_fields_set:
            _dict['secondary_content'] = None

        # set to None if table_content (nullable) is None
        # and model_fields_set contains the field
        if self.table_content is None and "table_content" in self.model_fields_set:
            _dict['table_content'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TopicInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "h_title": obj.get("h_title"),
            "main_title": obj.get("main_title"),
            "author": obj.get("author"),
            "language": obj.get("language"),
            "level": obj.get("level"),
            "primary_content": [ContentItemInfo.from_dict(_item) for _item in obj["primary_content"]] if obj.get("primary_content") is not None else None,
            "secondary_content": [ContentItemInfo.from_dict(_item) for _item in obj["secondary_content"]] if obj.get("secondary_content") is not None else None,
            "table_content": [TableContent.from_dict(_item) for _item in obj["table_content"]] if obj.get("table_content") is not None else None
        })
        return _obj


